/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import gui.program.EntityFactory;
import gui.program.ThreadNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.Collections;
import java.util.Map;

public class ThreadNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<ThreadNode> {
    private static final String NAME = "name";
    private static final String RUN_ONLY_ONCE = "runOnlyOnce";
    private final EntityFactory entityFactory;

    public ThreadNodeConversionStrategy(EntityFactory entityFactory) {
        super(ThreadNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToAttributes(ThreadNode node, PersistWriter writer) {
        writer.addAttribute(NAME, node.getName());
        writer.addAttribute(RUN_ONLY_ONCE, node.getRunOnlyOnce());
    }

    @Override
    protected ThreadNode createNode(PersistReader reader) {
        ThreadNode result = this.entityFactory.createThreadNode();
        result.removeAllChildren();
        return result;
    }

    @Override
    public void readFromAttributes(ThreadNode node, PersistReader reader) {
        node.setName(reader.getStringAttribute(NAME));
        node.setRunOnlyOnce(reader.getBooleanAttribute(RUN_ONLY_ONCE));
    }

    @Override
    public Map<String, Class<? extends ThreadNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("Thread", ThreadNode.class);
    }
}

