/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.BijectiveEnumMap;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.view.variables.core.ProgramVariable;
import gui.program.EntityFactory;
import gui.program.TimerNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import java.util.HashMap;
import java.util.Map;

public class TimerNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<TimerNode> {
    private static final String VARIABLE_NODE = "variable";
    private static final String TIMER_ACTION_ATTIBUTE = "action";
    private static final BijectiveEnumMap<TimerNode.TimerAction, String> TIMER_ACTION_NAMES = new BijectiveEnumMap(TimerNode.TimerAction.class).put((Enum)TimerNode.TimerAction.START, (Object)"Start").put((Enum)TimerNode.TimerAction.STOP, (Object)"Stop").put((Enum)TimerNode.TimerAction.RESET, (Object)"Reset").put((Enum)TimerNode.TimerAction.UNDEFINED, (Object)"Undefined").seal();
    private final EntityFactory entityFactory;

    public TimerNodeConversionStrategy(EntityFactory entityFactory) {
        super(TimerNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToAttributes(TimerNode node, PersistWriter writer) {
        writer.addAttribute(TIMER_ACTION_ATTIBUTE, (String)TIMER_ACTION_NAMES.getValue((Enum)node.getTimerAction()));
    }

    @Override
    public void writeToChildNodes(TimerNode node, PersistWriter writer) {
        writer.writeNodeWithValue(VARIABLE_NODE, (Object)node.getVariable());
    }

    @Override
    protected TimerNode createNode(PersistReader reader) {
        return this.entityFactory.createTimerNode();
    }

    @Override
    public void readFromAttributes(TimerNode node, PersistReader reader) {
        node.setTimerAction((TimerNode.TimerAction)TIMER_ACTION_NAMES.getKey((Object)reader.getStringAttribute(TIMER_ACTION_ATTIBUTE)));
    }

    @Override
    public boolean tryReadFromChildNode(TimerNode node, PersistReader reader) {
        String nodeName = reader.getNodeName();
        if (EqualsUtil.equals((Object)VARIABLE_NODE, (Object)nodeName)) {
            ProgramVariable variable = (ProgramVariable)reader.convertContainedValue(ProgramVariable.class);
            if (!variable.getProperties().containsKey("TimerVariable")) {
                variable.setProperty("TimerVariable", "TRUE");
            }
            node.setVariable(variable);
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Class<? extends TimerNode>> getTypeAliases(boolean forMarshalling) {
        HashMap<String, Class<? extends TimerNode>> result = new HashMap<String, Class<? extends TimerNode>>();
        result.put("Timer", TimerNode.class);
        return result;
    }
}

