/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.nodes.ProgramNodeType;
import com.ur.polyscope.program.nodes.ProgramNodeTypeImpl;
import com.ur.polyscope.program.nodes.until.UntilNode;
import com.ur.polyscope.program.nodes.until.persistence.UntilTypeConversionStrategy;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import gui.program.until.types.NullUntilTypeNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class UntilNodeConversionStrategyBase
extends ProgramNodeConversionStrategyBase<gui.program.until.UntilNode> {
    public static String SELECTED_UNTIL_TYPE_NODE = "type";
    public static String ALLOWS_ACTIONS = "allowActions";
    private Map<UntilTypeNode.Type, UntilTypeConversionStrategy> conversionStrategyMap = new HashMap<UntilTypeNode.Type, UntilTypeConversionStrategy>();

    @Inject
    public UntilNodeConversionStrategyBase(Set<UntilTypeConversionStrategy> untilTypeConversionStrategies) {
        super(gui.program.until.UntilNode.class);
        this.addConversionStrategiesToMap(untilTypeConversionStrategies);
    }

    private void addConversionStrategiesToMap(Set<UntilTypeConversionStrategy> untilTypeConversionStrategies) {
        for (UntilTypeConversionStrategy conversionStrategy : untilTypeConversionStrategies) {
            this.conversionStrategyMap.put(conversionStrategy.getType(), conversionStrategy);
        }
    }

    @Override
    protected gui.program.until.UntilNode createNode(PersistReader reader) {
        return new gui.program.until.UntilNode();
    }

    @Override
    public void writeToAttributes(gui.program.until.UntilNode node, PersistWriter writer) {
        UntilTypeNode untilType = node.getSelectedTypeNode();
        writer.addAttribute(SELECTED_UNTIL_TYPE_NODE, (Enum)untilType.getType());
        writer.addAttribute(ALLOWS_ACTIONS, node.getNodeType().isChildrenAllowed());
        if (!(untilType instanceof NullUntilTypeNode)) {
            this.conversionStrategyMap.get(untilType.getType()).marshal(untilType, writer);
        }
    }

    @Override
    public void readFromAttributes(gui.program.until.UntilNode node, PersistReader reader) {
        UntilTypeNode.Type type;
        if (reader.getBooleanAttribute(ALLOWS_ACTIONS)) {
            node.setProgramNodeType((ProgramNodeType)new ProgramNodeTypeImpl(true, true));
        }
        if (this.conversionStrategyMap.containsKey(type = (UntilTypeNode.Type)reader.getEnumAttribute(SELECTED_UNTIL_TYPE_NODE, UntilTypeNode.Type.class))) {
            this.conversionStrategyMap.get(type).unmarshal(reader, (UntilNode)node);
        }
    }

    @Override
    public Map<String, Class<? extends gui.program.until.UntilNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("Until", gui.program.until.UntilNode.class);
    }
}

