/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.version.urversion.URVersion;
import java.util.Collections;
import java.util.Map;

public class VersionConversionStrategy
extends ConversionStrategyTemplate<URVersion> {
    private static final String MAJOR = "major";
    private static final String MINOR = "minor";
    private static final String REVISION = "revision";
    private static final String BUGFIX = "bugfix";

    public VersionConversionStrategy() {
        super(URVersion.class);
    }

    public void marshal(URVersion version, PersistWriter writer) {
        writer.addAttribute(MAJOR, version.getMajorVersion());
        writer.addAttribute(MINOR, version.getMinorVersion());
        writer.addAttribute(BUGFIX, version.getPatchVersion());
    }

    public URVersion unmarshal(PersistReader reader) {
        int majorVersion = reader.getIntegerAttribute(MAJOR);
        int minorVersion = reader.getIntegerAttribute(MINOR);
        int bugfix = reader.getIntegerAttribute(REVISION);
        if (bugfix == 0) {
            bugfix = reader.getIntegerAttribute(BUGFIX);
        }
        return new URVersion(majorVersion, minorVersion, bugfix);
    }

    public Map<String, Class<? extends URVersion>> getClassAliases(boolean forMarshalling) {
        return Collections.singletonMap("Version", URVersion.class);
    }
}

