/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.polyscope.version.urversion.URVersion;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionReader {
    private static final int READ_BUFFER_LENGTH = 500;
    private static final Pattern URP_VERSION_PATTERN = Pattern.compile("<.*lastSavedIn\\s*=\\s*\"([0-9]+)\\.([0-9]+)\\.([0-9]+)(\\.([0-9]+))?\".*");
    private URVersion urpVersion;

    public Reader readVersionAndPushBack(Reader reader) throws IOException {
        PushbackReader pushbackReader = new PushbackReader(reader, 500);
        char[] buffer = new char[500];
        int numberRead = pushbackReader.read(buffer);
        pushbackReader.unread(buffer, 0, numberRead);
        String urpPrefix = new String(buffer);
        Matcher urpVersionMatcher = URP_VERSION_PATTERN.matcher(urpPrefix);
        if (urpVersionMatcher.find()) {
            int majorVersion = Integer.parseInt(urpVersionMatcher.group(1));
            int minorVersion = Integer.parseInt(urpVersionMatcher.group(2));
            int bugfixVersion = Integer.parseInt(urpVersionMatcher.group(3));
            this.urpVersion = new URVersion(majorVersion, minorVersion, bugfixVersion);
        }
        return pushbackReader;
    }

    public URVersion getVersion() {
        return this.urpVersion;
    }
}

