/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.lang.BijectiveEnumMap;
import com.ur.lang.EqualsUtil;
import com.ur.move.Position;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.valueobjects.Percentage;
import com.ur.polyscope.valueobjects.Time;
import com.ur.view.variables.core.Variable;
import gui.program.EntityFactory;
import gui.program.OptiMoveNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import gui.program.position.WaypointNode;
import java.util.Collections;
import java.util.Map;

public abstract class WaypointNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<WaypointNode> {
    public static final String WAYPOINT_ALIAS = "Waypoint";
    public static final String TYPE_ATTRIBUTE = "type";
    static final String RELATIVE_FROM_POSITION_NODE = "relativeFromPosition";
    static final String POSITION_NODE = "position";
    static final String POSE_IN_FEATURE_COORDINATES_NODE = "poseInFeatureCoordinates";
    static final String VARIABLE_NODE = "variable";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String KINEMATICS_FLAGS_ATTRIBUTE = "kinematicsFlags";
    private static final String MOTION_PARAMETERS_NODE = "motionParameters";
    private static final String JOINT_SPEED_ATTRIBUTE = "jointSpeed";
    private static final String JOINT_ACCELERATION_ATTRIBUTE = "jointAcceleration";
    private static final String CARTESIAN_SPEED_ATTRIBUTE = "cartesianSpeed";
    private static final String CARTESIAN_ACCELERATION_ATTRIBUTE = "cartesianAcceleration";
    private static final String NEXT_MOTION_TIME_ATTRIBUTE = "nextMotionTime";
    private static final String BLEND_RADIUS_ATTRIBUTE = "blendRadius";
    private static final String OPTIMOVE_SPEED = "optiMoveSpeed";
    private static final String OPTIMOVE_ACCELERATION = "optiMoveAcceleration";
    private static final BijectiveEnumMap<PositionNodeType, String> TYPE_NAMES = new BijectiveEnumMap(PositionNodeType.class).put((Enum)PositionNodeType.UNDEFINED, (Object)"Undefined").put((Enum)PositionNodeType.FIXED, (Object)"Fixed").put((Enum)PositionNodeType.RELATIVE, (Object)"Relative").put((Enum)PositionNodeType.VARIABLE, (Object)"Variable").seal();
    private final EntityFactory entityFactory;

    public WaypointNodeConversionStrategy(EntityFactory entityFactory) {
        super(WaypointNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public boolean canUnmarshalFrom(PersistReader reader) {
        return reader.getStringAttribute(TYPE_ATTRIBUTE) != null;
    }

    @Override
    public void writeToAttributes(WaypointNode node, PersistWriter writer) {
        PositionNodeType type = node.getPositionNodeType();
        writer.addAttribute(TYPE_ATTRIBUTE, (String)TYPE_NAMES.getValue((Enum)type));
        writer.addAttribute(NAME_ATTRIBUTE, node.getOwnName());
        writer.addAttribute(KINEMATICS_FLAGS_ATTRIBUTE, node.getKinematicFlags());
    }

    @Override
    protected WaypointNode createNode(PersistReader reader) {
        return this.entityFactory.createWaypointNode();
    }

    @Override
    public void readFromAttributes(WaypointNode node, PersistReader reader) {
        node.setPositionNodeType((PositionNodeType)TYPE_NAMES.getKey((Object)reader.getStringAttribute(TYPE_ATTRIBUTE)));
        node.setName(reader.getStringAttribute(NAME_ATTRIBUTE));
        node.setKinematicFlags(reader.getIntegerAttribute(KINEMATICS_FLAGS_ATTRIBUTE));
    }

    @Override
    public Map<String, Class<? extends WaypointNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap(WAYPOINT_ALIAS, WaypointNode.class);
    }

    @Override
    public boolean tryReadFromChildNode(WaypointNode node, PersistReader reader) {
        String nodeName;
        if (EqualsUtil.equals((Object)MOTION_PARAMETERS_NODE, (Object)reader.getNodeName())) {
            this.handleMotionNodeRead(node, reader);
        }
        if (EqualsUtil.equals((Object)RELATIVE_FROM_POSITION_NODE, (Object)(nodeName = reader.getNodeName()))) {
            node.setRelativeFromPosition((Position)reader.convertContainedValue(this.getPositionClass()));
        } else if (EqualsUtil.equals((Object)POSITION_NODE, (Object)nodeName)) {
            node.setPosition((Position)reader.convertContainedValue(this.getPositionClass()));
        } else if (EqualsUtil.equals((Object)VARIABLE_NODE, (Object)nodeName)) {
            node.setInternalVariable((Variable)reader.convertContainedValue(Variable.class));
        } else {
            return false;
        }
        return true;
    }

    abstract Class<? extends Position> getPositionClass();

    boolean nodeHasSpecificMotionParameter(WaypointNode node) {
        return !node.isUseSharedBlendParameter() || !node.isUsingSharedParameters() || node.isStopPoint();
    }

    boolean writePosition(String nodeName, Position position, PersistWriter writer) {
        boolean result;
        boolean bl = result = position != null && !position.isUndefined();
        if (result) {
            writer.writeNodeWithValue(nodeName, (Object)position);
        }
        return result;
    }

    private void handleMotionNodeRead(WaypointNode node, PersistReader reader) {
        this.handleNextMotionTime(node, reader);
        this.handleIndividualParameters(node, reader);
        this.handleBlendRadius(node, reader);
    }

    private void handleNextMotionTime(WaypointNode node, PersistReader reader) {
        if (reader.hasOneOfAttributes(new String[]{NEXT_MOTION_TIME_ATTRIBUTE})) {
            node.setUsingNextMotionTime();
            node.setNextMotionTime(Time.from((double)reader.getDoubleAttribute(NEXT_MOTION_TIME_ATTRIBUTE), (Time.Unit)Time.Unit.SI));
        }
    }

    private void handleIndividualParameters(WaypointNode node, PersistReader reader) {
        this.readLegacyOptiMoveParameters(node, reader);
        this.readOptiMovePercentageParameters(node, reader);
        this.readIndividualOptiMoveParameters(node, reader);
        this.readIndividualMotionParameters(node, reader);
    }

    @Deprecated
    private void readLegacyOptiMoveParameters(OptiMoveNode node, PersistReader reader) {
        if (!reader.hasOneOfAttributes(new String[]{"optiMovePercentage"})) {
            return;
        }
        int combinedEffort = reader.getIntegerAttribute("optiMovePercentage");
        node.setOptiMoveSpeed(Percentage.from((double)((double)combinedEffort / 100.0)));
        node.setOptiMoveAcceleration(Percentage.from((double)((double)combinedEffort / 100.0)));
        node.setUsingOptiMove(true);
    }

    @Deprecated
    private void readOptiMovePercentageParameters(OptiMoveNode node, PersistReader reader) {
        if (!reader.hasOneOfAttributes(new String[]{"optiMoveSpeedPercentage", "optiMoveAccelerationPercentage"})) {
            return;
        }
        double speed = reader.getDoubleAttribute("optiMoveSpeedPercentage");
        double acceleration = reader.getDoubleAttribute("optiMoveAccelerationPercentage");
        node.setOptiMoveSpeed(Percentage.from((double)(speed / 100.0)));
        node.setOptiMoveAcceleration(Percentage.from((double)(acceleration / 100.0)));
    }

    private void readIndividualOptiMoveParameters(OptiMoveNode node, PersistReader reader) {
        if (!reader.hasOneOfAttributes(new String[]{OPTIMOVE_SPEED, OPTIMOVE_ACCELERATION})) {
            return;
        }
        double speed = reader.getDoubleAttribute(OPTIMOVE_SPEED);
        double acceleration = reader.getDoubleAttribute(OPTIMOVE_ACCELERATION);
        node.setOptiMoveSpeed(Percentage.from((double)speed));
        node.setOptiMoveAcceleration(Percentage.from((double)acceleration));
        node.setUsingOptiMove(true);
    }

    private void readIndividualMotionParameters(WaypointNode node, PersistReader reader) {
        if (!reader.hasOneOfAttributes(new String[]{JOINT_SPEED_ATTRIBUTE, JOINT_ACCELERATION_ATTRIBUTE, CARTESIAN_SPEED_ATTRIBUTE, CARTESIAN_ACCELERATION_ATTRIBUTE})) {
            return;
        }
        node.setUsingIndividualParameters();
        node.setUsingOptiMove(false);
        node.setJointSpeed(reader.getDoubleAttribute(JOINT_SPEED_ATTRIBUTE));
        node.setJointAcceleration(reader.getDoubleAttribute(JOINT_ACCELERATION_ATTRIBUTE));
        node.setCartesianSpeed(reader.getDoubleAttribute(CARTESIAN_SPEED_ATTRIBUTE));
        node.setCartesianAcceleration(reader.getDoubleAttribute(CARTESIAN_ACCELERATION_ATTRIBUTE));
    }

    private void handleBlendRadius(WaypointNode node, PersistReader reader) {
        if (reader.hasOneOfAttributes(new String[]{BLEND_RADIUS_ATTRIBUTE})) {
            node.setUseSharedBlendParameter(false);
            node.setStopPoint(false);
            node.setBlendRadius(reader.getDoubleAttribute(BLEND_RADIUS_ATTRIBUTE));
        }
    }

    void writeMotionNode(WaypointNode node, PersistWriter writer) {
        writer.startNode(MOTION_PARAMETERS_NODE);
        this.writeMotionParameters(node, writer);
        this.writeBlendParameters(node, writer);
        writer.endNode();
    }

    private void writeMotionParameters(WaypointNode node, PersistWriter writer) {
        if (node.isUsingSharedParameters()) {
            return;
        }
        if (node.isUsingNextMotionTime()) {
            writer.addAttribute(NEXT_MOTION_TIME_ATTRIBUTE, node.getNextMotionTime().getIn(Time.Unit.SI));
        } else if (node.isUsingOptiMove()) {
            writer.addAttribute(OPTIMOVE_SPEED, node.getOptiMoveSpeed().getValue());
            writer.addAttribute(OPTIMOVE_ACCELERATION, node.getOptiMoveAcceleration().getValue());
        } else {
            this.writeMotionAttributes(node, writer);
        }
    }

    private void writeMotionAttributes(WaypointNode node, PersistWriter writer) {
        writer.addAttribute(JOINT_SPEED_ATTRIBUTE, node.getJointSpeed());
        writer.addAttribute(JOINT_ACCELERATION_ATTRIBUTE, node.getJointAcceleration());
        writer.addAttribute(CARTESIAN_SPEED_ATTRIBUTE, node.getCartesianSpeed());
        writer.addAttribute(CARTESIAN_ACCELERATION_ATTRIBUTE, node.getCartesianAcceleration());
    }

    private void writeBlendParameters(WaypointNode node, PersistWriter writer) {
        if (!node.isUseSharedBlendParameter()) {
            writer.addAttribute(BLEND_RADIUS_ATTRIBUTE, node.getBlendRadius());
        }
    }
}

