/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsFactory;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import gui.program.AnchoredSequenceNode;
import gui.program.DirectionNode;
import gui.program.EntityFactory;
import gui.program.MotionDefiningNode;
import gui.program.MoveNode;
import gui.program.PatternNode;
import gui.program.ProgramRootNode;
import gui.program.StackNode;
import gui.program.persistence.KinematicsCalibrationConversionStrategy;
import gui.program.persistence_pre_v3_2.KinematicsCalibrationConversionStrategy_v3_1;
import gui.program.position.MeasuredPosition;
import gui.program.position.MeasuredWaypointNode;
import gui.program.services.ProgramReferenceService;
import gui.program.services.geom.GeomFeatureReference;
import gui.program.services.geom.GeomFeatureReferenceBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import javax.media.j3d.Transform3D;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class WaypointRepresentationUpgradeHelper {
    private static final String WAYPOINT_UNLINK_PREFIX = "UL_";
    private final ProgramReferenceService programReferenceService;
    private EntityFactory entityFactory;

    public WaypointRepresentationUpgradeHelper(EntityFactory entityFactory, ProgramReferenceService programReferenceService) {
        this.entityFactory = entityFactory;
        this.programReferenceService = programReferenceService;
    }

    public void upgradeProgram(ProgramRootNode result) {
        Map<MotionDefiningNode, List<MeasuredWaypointNode>> map = this.createMoveMap(result);
        this.handleSchizophrenicAndLinkedWaypoints(map);
        this.handleUseToolFlangeAndFeatureMoveNodeUpgrade(map);
        map = null;
    }

    public void adjustWaypointsWithBaseFeature(ProgramRootNode result) {
        Map<MotionDefiningNode, List<MeasuredWaypointNode>> moveMap = this.createMoveMap(result);
        GeomFeatureReference baseGeomFeatureReference = this.programReferenceService.getGeomFeatureReference("Joint_0_name");
        Iterator<MotionDefiningNode> iterator = moveMap.keySet().iterator();
        ArrayList<MeasuredWaypointNode> waypointsUsingBase = new ArrayList<MeasuredWaypointNode>();
        while (iterator.hasNext()) {
            boolean isBase;
            MotionDefiningNode motionDefiningNode = iterator.next();
            if (this.isTemplateNode(motionDefiningNode) || !(motionDefiningNode instanceof MoveNode)) continue;
            MoveNode moveNode = (MoveNode)motionDefiningNode;
            boolean bl = isBase = motionDefiningNode.getDereferencedGeomFeature() == baseGeomFeatureReference.dereference();
            if (!isBase) continue;
            List<MeasuredWaypointNode> measuredWaypointNodes = moveMap.get(moveNode);
            for (MeasuredWaypointNode mvn : measuredWaypointNodes) {
                if (!this.hasDefinedBaseToFeatureTransform(mvn)) continue;
                waypointsUsingBase.add(mvn);
            }
        }
        this.unlinkWaypoints(moveMap, waypointsUsingBase);
        for (MeasuredWaypointNode mvn : waypointsUsingBase) {
            mvn.setBaseToFeatureTransform(new Transform3D());
        }
    }

    private boolean hasDefinedBaseToFeatureTransform(MeasuredWaypointNode mvn) {
        return mvn.getBaseToFeatureTransform() != null && !mvn.getBaseToFeatureTransform().equals(new Transform3D());
    }

    private Map<MotionDefiningNode, List<MeasuredWaypointNode>> createMoveMap(ProgramRootNode result) {
        HashMap<MotionDefiningNode, List<MeasuredWaypointNode>> map = new HashMap<MotionDefiningNode, List<MeasuredWaypointNode>>();
        Enumeration nodes = result.breadthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            MeasuredWaypointNode wp;
            MotionDefiningNode motionDefiningNode;
            Object each = nodes.nextElement();
            if (!(each instanceof MeasuredWaypointNode) || (motionDefiningNode = (wp = (MeasuredWaypointNode)each).getMotionDefiningNode()) == null) continue;
            ArrayList<MeasuredWaypointNode> measuredWaypointNodes = (ArrayList<MeasuredWaypointNode>)map.get(motionDefiningNode);
            if (measuredWaypointNodes == null) {
                measuredWaypointNodes = new ArrayList<MeasuredWaypointNode>();
            }
            measuredWaypointNodes.add(wp);
            map.put(motionDefiningNode, measuredWaypointNodes);
        }
        return map;
    }

    private boolean isTemplateNode(MotionDefiningNode motionDefiningNode) {
        return motionDefiningNode instanceof StackNode || motionDefiningNode instanceof PatternNode || motionDefiningNode instanceof DirectionNode || motionDefiningNode instanceof AnchoredSequenceNode;
    }

    private void handleSchizophrenicAndLinkedWaypoints(Map<MotionDefiningNode, List<MeasuredWaypointNode>> map) {
        List<MeasuredWaypointNode> JointAngleWaypoints = this.getJointAngleWaypoints(map);
        this.removeTcpOffset(JointAngleWaypoints);
        this.unlinkWaypoints(map, JointAngleWaypoints);
    }

    private void handleUseToolFlangeAndFeatureMoveNodeUpgrade(Map<MotionDefiningNode, List<MeasuredWaypointNode>> map) {
        for (MotionDefiningNode motionDefiningNode : map.keySet()) {
            boolean allWaypointsAreRelativeOrUndefined;
            boolean checkIfFeatureShouldChangeToBase;
            if (this.isTemplateNode(motionDefiningNode)) {
                motionDefiningNode.setUseActiveTCP(true);
                continue;
            }
            if (!(motionDefiningNode instanceof MoveNode)) continue;
            MoveNode moveNode = (MoveNode)motionDefiningNode;
            GeomFeatureReference baseGeomFeatureReference = this.programReferenceService.getGeomFeatureReference("Joint_0_name");
            GeomFeatureReference toolGeomFeatureReference = this.programReferenceService.getGeomFeatureReference("Joint_6_name");
            GeomFeature dereferencedGeomFeature = motionDefiningNode.getDereferencedGeomFeature();
            GeomFeatureReferenceBase referencedGeomFeature = motionDefiningNode.getFeatureReference();
            boolean isUsingNonVariableNonBaseFeature = !this.selectedFeaturePersistedIsVariable(motionDefiningNode) && dereferencedGeomFeature != baseGeomFeatureReference.dereference();
            boolean isUsingToolFeature = dereferencedGeomFeature == toolGeomFeatureReference.dereference();
            boolean willUseVariableFeatureAfterUpgrade = this.selectedFeaturePersistedIsVariable(motionDefiningNode) && dereferencedGeomFeature != baseGeomFeatureReference.dereference();
            boolean checkIfTCPShouldChangeToUseActive = moveNode.isIgnoreTCP();
            boolean bl = checkIfFeatureShouldChangeToBase = isUsingNonVariableNonBaseFeature && !isUsingToolFeature;
            if (!checkIfTCPShouldChangeToUseActive && !checkIfFeatureShouldChangeToBase) continue;
            List<MeasuredWaypointNode> measuredWaypointNodes = map.get(moveNode);
            boolean wrapVariableWaypointsDueToTCP = false;
            boolean wrapVariableWaypointsDueToFeature = false;
            if (measuredWaypointNodes.size() == 0) continue;
            int fixedCnt = 0;
            int variableCnt = 0;
            for (MeasuredWaypointNode node : measuredWaypointNodes) {
                switch (node.getPositionNodeType()) {
                    case FIXED: {
                        ++fixedCnt;
                        break;
                    }
                    case VARIABLE: {
                        ++variableCnt;
                        break;
                    }
                }
            }
            boolean allWaypointsAreVariable = fixedCnt == 0;
            boolean allWaypointsAreFixed = variableCnt == 0;
            boolean bl2 = allWaypointsAreRelativeOrUndefined = fixedCnt == 0 && variableCnt == 0;
            if (checkIfTCPShouldChangeToUseActive) {
                if (willUseVariableFeatureAfterUpgrade || moveNode.isProcessMove()) {
                    moveNode.setUseActiveTCP(true);
                } else if (!allWaypointsAreRelativeOrUndefined) {
                    if (allWaypointsAreVariable) {
                        moveNode.setUseActiveTCP(true);
                    } else if (!allWaypointsAreFixed) {
                        wrapVariableWaypointsDueToTCP = true;
                    }
                }
            }
            if (checkIfFeatureShouldChangeToBase && !allWaypointsAreRelativeOrUndefined && !allWaypointsAreVariable) {
                if (allWaypointsAreFixed) {
                    motionDefiningNode.setFeatureReference(baseGeomFeatureReference);
                } else {
                    motionDefiningNode.setFeatureReference(baseGeomFeatureReference);
                    wrapVariableWaypointsDueToFeature = true;
                }
            }
            if (!wrapVariableWaypointsDueToTCP && !wrapVariableWaypointsDueToFeature) continue;
            for (MeasuredWaypointNode node : measuredWaypointNodes) {
                if (node.getPositionNodeType() != PositionNodeType.VARIABLE) continue;
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                int index = parent.getIndex((TreeNode)((Object)node));
                MoveNode newMoveNode = this.entityFactory.createMoveNode();
                newMoveNode.removeAllChildren();
                newMoveNode.copyDataFrom(moveNode);
                if (wrapVariableWaypointsDueToTCP) {
                    newMoveNode.setUseActiveTCP(true);
                }
                if (wrapVariableWaypointsDueToFeature) {
                    newMoveNode.setFeatureReference(referencedGeomFeature);
                }
                newMoveNode.add((MutableTreeNode)((Object)node));
                parent.insert((MutableTreeNode)((Object)newMoveNode), index);
            }
        }
    }

    private List<MeasuredWaypointNode> flattenMapValues(Collection<List<MeasuredWaypointNode>> values) {
        ArrayList<MeasuredWaypointNode> flattened = new ArrayList<MeasuredWaypointNode>();
        for (List<MeasuredWaypointNode> list : values) {
            flattened.addAll(list);
        }
        return flattened;
    }

    private List<MeasuredWaypointNode> getJointAngleWaypoints(Map<MotionDefiningNode, List<MeasuredWaypointNode>> map) {
        ArrayList<MeasuredWaypointNode> JointAngleWaypoints = new ArrayList<MeasuredWaypointNode>();
        for (MotionDefiningNode motionDefiningNode : map.keySet()) {
            if (this.isTemplateNode(motionDefiningNode) || !motionDefiningNode.isJointMove() && !motionDefiningNode.isLinearMove() || !motionDefiningNode.isIgnoreTCP() || this.selectedFeaturePersistedIsVariable(motionDefiningNode)) continue;
            List<MeasuredWaypointNode> measuredWaypointNodes = map.get(motionDefiningNode);
            for (MeasuredWaypointNode measuredWaypointNode : measuredWaypointNodes) {
                if (measuredWaypointNode.getPositionNodeType() != PositionNodeType.FIXED) continue;
                JointAngleWaypoints.add(measuredWaypointNode);
            }
        }
        return JointAngleWaypoints;
    }

    private void unlinkWaypoints(Map<MotionDefiningNode, List<MeasuredWaypointNode>> map, List<MeasuredWaypointNode> waypointsThatCanNotBeLinked) {
        List<MeasuredWaypointNode> measuredWaypointNodes = this.flattenMapValues(map.values());
        measuredWaypointNodes.removeAll(waypointsThatCanNotBeLinked);
        for (MeasuredWaypointNode wp : measuredWaypointNodes) {
            if (!this.isLinked(wp, waypointsThatCanNotBeLinked)) continue;
            String newName = WAYPOINT_UNLINK_PREFIX + wp.getName();
            if (newName.length() >= 15) {
                newName = newName.substring(0, 15);
            }
            wp.setName(newName);
        }
    }

    private boolean isLinked(MeasuredWaypointNode wp, List<MeasuredWaypointNode> any) {
        for (MeasuredWaypointNode measuredWaypointNode : any) {
            if (!wp.getName().equals(measuredWaypointNode.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean selectedFeaturePersistedIsVariable(MotionDefiningNode motionDefiningNode) {
        if (motionDefiningNode.isJointMove()) {
            return false;
        }
        GeomFeature geomFeature = motionDefiningNode.getDereferencedGeomFeature();
        return geomFeature == null ? false : geomFeature.persistedIsVariable();
    }

    private void removeTcpOffset(List<MeasuredWaypointNode> waypoints) {
        for (MeasuredWaypointNode waypointNode : waypoints) {
            ((MeasuredPosition)waypointNode.getPositionReference()).removeTcpOffset();
        }
    }

    public static class CachingKinematicsCalibrationConversionStrategy
    extends KinematicsCalibrationConversionStrategy
    implements Provider<KinematicsCalibration> {
        private KinematicsCalibration kinematicsCalibration;
        private Provider<KinematicsCalibration> kinematicsProvider;

        CachingKinematicsCalibrationConversionStrategy(Provider<KinematicsCalibration> kinematicsProvider, KinematicsFactory kinematicsFactory) {
            super(kinematicsFactory);
            this.kinematicsProvider = kinematicsProvider;
        }

        @Override
        public KinematicsCalibration unmarshal(PersistReader reader) {
            this.kinematicsCalibration = super.unmarshal(reader);
            return this.kinematicsCalibration;
        }

        public KinematicsCalibration get() {
            if (this.kinematicsCalibration != null) {
                return this.kinematicsCalibration;
            }
            return (KinematicsCalibration)this.kinematicsProvider.get();
        }
    }

    public static class CachingKinematicsCalibrationConversionStrategy_v3_1
    extends KinematicsCalibrationConversionStrategy_v3_1
    implements Provider<KinematicsCalibration> {
        private KinematicsCalibration kinematicsCalibration;
        private Provider<KinematicsCalibration> kinematicsProvider;

        public CachingKinematicsCalibrationConversionStrategy_v3_1(Provider<KinematicsCalibration> kinematicsProvider, KinematicsFactory kinematicsFactory) {
            super(kinematicsFactory);
            this.kinematicsProvider = kinematicsProvider;
        }

        @Override
        public KinematicsCalibration unmarshal(PersistReader reader) {
            this.kinematicsCalibration = super.unmarshal(reader);
            return this.kinematicsCalibration;
        }

        public KinematicsCalibration get() {
            if (this.kinematicsCalibration != null) {
                return this.kinematicsCalibration;
            }
            return (KinematicsCalibration)this.kinematicsProvider.get();
        }
    }
}

