/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence_pre_v3_2;

import com.ur.lang.BijectiveEnumMap;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.swing.expression.Expression;
import com.ur.view.variables.InstallationVariableReference;
import com.ur.view.variables.core.Variable;
import gui.program.AssignmentNode;
import gui.program.EntityFactory;
import gui.program.persistence_pre_v3_2.LegacyProgramNodeBuilder;
import gui.program.services.ProgramReferenceService;
import java.util.Collections;
import java.util.Map;

public class AssignmentNodeConversionStrategy_v3_1
extends ConversionStrategyTemplate<AssignmentNode> {
    private static final BijectiveEnumMap<AssignmentNode.ValueSource, String> VALUE_SOURCE_NAMES = new BijectiveEnumMap(AssignmentNode.ValueSource.class).put((Enum)AssignmentNode.ValueSource.EXPRESSION, (Object)"EXPRESSION").put((Enum)AssignmentNode.ValueSource.OPERATOR, (Object)"OPERATOR").seal();
    private static final BijectiveEnumMap<AssignmentNode.OperatorValueType, String> VALUE_TYPE_NAMES = new BijectiveEnumMap(AssignmentNode.OperatorValueType.class).put((Enum)AssignmentNode.OperatorValueType.BOOLEAN, (Object)"BOOLEAN").put((Enum)AssignmentNode.OperatorValueType.INTEGER, (Object)"INTEGER").put((Enum)AssignmentNode.OperatorValueType.FLOAT, (Object)"FLOAT").put((Enum)AssignmentNode.OperatorValueType.STRING, (Object)"STRING").seal();
    private final EntityFactory entityFactory;
    private final ProgramReferenceService programReferenceService;

    public AssignmentNodeConversionStrategy_v3_1(EntityFactory entityFactory, ProgramReferenceService programReferenceService) {
        super(AssignmentNode.class);
        this.entityFactory = entityFactory;
        this.programReferenceService = programReferenceService;
    }

    public void marshal(AssignmentNode node, PersistWriter writer) {
    }

    public AssignmentNode unmarshal(PersistReader reader) {
        return (AssignmentNode)new AssignmentNodeBuilder(reader).buildNode();
    }

    public Map<String, Class<? extends AssignmentNode>> getClassAliases(boolean forMarshalling) {
        if (forMarshalling) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("gui.program.AssignmentNode", AssignmentNode.class);
    }

    private class AssignmentNodeBuilder
    extends LegacyProgramNodeBuilder<AssignmentNode> {
        private static final String VARIABLE_NODE = "variable";
        private static final String VARIABLE_NAME_NODE = "variableName";
        private static final String EXPR_NODE = "expr";
        private static final String VALUE_SOURCE = "valueSource";
        private static final String OPERATOR_VALUE_TYPE = "operatorValueType";
        private static final String ASSIGNMENT_OPERATOR_MESSAGE = "assignmentOperatorMessage";

        public AssignmentNodeBuilder(PersistReader reader) {
            super(AssignmentNode.class, reader);
        }

        @Override
        protected AssignmentNode createNode() {
            return AssignmentNodeConversionStrategy_v3_1.this.entityFactory.createAssignmentNode();
        }

        @Override
        public boolean tryReadFromChildNode(AssignmentNode node, PersistReader reader) {
            if (!EqualsUtil.equals((Object)"gui.program.AssignmentNode", (Object)reader.getNodeName())) {
                return false;
            }
            if (this.moveToDefaultNode(reader)) {
                while (reader.hasMoreNodes()) {
                    reader.moveToChildNode();
                    String nodeName = reader.getNodeName();
                    if (EXPR_NODE.equals(nodeName)) {
                        this.readExpression(node, reader);
                    } else if (ASSIGNMENT_OPERATOR_MESSAGE.equals(nodeName)) {
                        String assignmentOperatorMessage = reader.getStringValue();
                        node.setAssignmentOperatorMessage(assignmentOperatorMessage);
                    } else if (OPERATOR_VALUE_TYPE.equals(nodeName)) {
                        String operatorValueType = reader.getStringValue();
                        node.setOperatorValueType((AssignmentNode.OperatorValueType)VALUE_TYPE_NAMES.getKey((Object)operatorValueType));
                    } else if (VALUE_SOURCE.equals(nodeName)) {
                        String valueSource = reader.getStringValue();
                        node.setValueSource((AssignmentNode.ValueSource)VALUE_SOURCE_NAMES.getKey((Object)valueSource));
                    } else if (VARIABLE_NODE.equals(nodeName)) {
                        this.readVariable(node, reader);
                    } else if (VARIABLE_NAME_NODE.equals(nodeName)) {
                        this.readInstallationVariable(node, reader);
                    }
                    reader.moveToParentNode();
                }
                this.moveOutOfDefaultNode(reader);
            }
            if (node.getVariable() == null) {
                node.setVariable(AssignmentNodeConversionStrategy_v3_1.this.entityFactory.createVariable());
            }
            return true;
        }

        private void readExpression(AssignmentNode node, PersistReader reader) {
            Expression ebn = (Expression)reader.convertContainedValue(Expression.class);
            node.setExpression(ebn.getExpression());
        }

        private void readVariable(AssignmentNode node, PersistReader reader) {
            Variable variable = (Variable)reader.convertContainedValue(Variable.class);
            node.setVariable(variable);
        }

        private void readInstallationVariable(AssignmentNode node, PersistReader reader) {
            String installationVariableName = reader.getStringValue();
            InstallationVariableReference variable = AssignmentNodeConversionStrategy_v3_1.this.programReferenceService.getInstallationVariableReference(installationVariableName);
            node.setVariable(variable);
        }
    }
}

