/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence_pre_v3_2;

import com.ur.lang.BijectiveEnumMap;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.view.polyscope.program.ForceType;
import gui.program.EntityFactory;
import gui.program.ForceNode;
import gui.program.persistence_pre_v3_2.LegacyProgramNodeBuilder;
import gui.program.services.geom.GeomFeatureReference;
import java.util.Collections;
import java.util.Map;

public class ForceNodeConversionStrategy_v3_1
extends ConversionStrategyTemplate<ForceNode> {
    private final EntityFactory entityFactory;
    private static final BijectiveEnumMap<ForceType, String> FORCE_TYPE_NAMES = new BijectiveEnumMap(ForceType.class).put((Enum)ForceType.SIMPLE, (Object)"FORCE_TYPE_SIMPLE").put((Enum)ForceType.FRAME, (Object)"FORCE_TYPE_FRAME").put((Enum)ForceType.POINT, (Object)"FORCE_TYPE_POINT").put((Enum)ForceType.MOTION, (Object)"FORCE_TYPE_MOTION").seal();

    public ForceNodeConversionStrategy_v3_1(EntityFactory entityFactory) {
        super(ForceNode.class);
        this.entityFactory = entityFactory;
    }

    public void marshal(ForceNode node, PersistWriter writer) {
    }

    public ForceNode unmarshal(PersistReader reader) {
        return (ForceNode)new ForceNodeBuilder(reader).buildNode();
    }

    public Map<String, Class<? extends ForceNode>> getClassAliases(boolean forMarshalling) {
        if (forMarshalling) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("gui.program.ForceNode", ForceNode.class);
    }

    private class ForceNodeBuilder
    extends LegacyProgramNodeBuilder<ForceNode> {
        private static final String FEATURE_REFERENCE = "feature_reference";
        private static final String FORCE_MODE_WRENCH = "force_mode_wrench";
        private static final String LIMITS_FORCE = "limits_force";
        private static final String LIMITS_MOTION = "limits_motion";
        private static final String SELECTION_VECTOR = "selection_vector";
        private static final String TYPE = "type";

        protected ForceNodeBuilder(PersistReader reader) {
            super(ForceNode.class, reader);
        }

        @Override
        protected ForceNode createNode() {
            ForceNode result = ForceNodeConversionStrategy_v3_1.this.entityFactory.createForceNode();
            result.removeAllChildren();
            return result;
        }

        @Override
        public boolean tryReadFromChildNode(ForceNode node, PersistReader reader) {
            if (!EqualsUtil.equals((Object)"gui.program.ForceNode", (Object)reader.getNodeName())) {
                return false;
            }
            if (this.moveToDefaultNode(reader)) {
                while (reader.hasMoreNodes()) {
                    reader.moveToChildNode();
                    String nodeName = reader.getNodeName();
                    if (EqualsUtil.equals((Object)FEATURE_REFERENCE, (Object)nodeName)) {
                        GeomFeatureReference reference = (GeomFeatureReference)((Object)reader.convertContainedValue(GeomFeatureReference.class));
                        node.setFeatureReference(reference);
                    } else if (EqualsUtil.equals((Object)FORCE_MODE_WRENCH, (Object)nodeName)) {
                        node.setWrenchVector(reader.getDoubleArrayValue());
                    } else if (EqualsUtil.equals((Object)LIMITS_FORCE, (Object)nodeName)) {
                        node.setForceControlSpeedLimits(reader.getDoubleArrayValue());
                    } else if (EqualsUtil.equals((Object)LIMITS_MOTION, (Object)nodeName)) {
                        node.setMotionControlErrorLimits(reader.getDoubleArrayValue());
                    } else if (EqualsUtil.equals((Object)SELECTION_VECTOR, (Object)nodeName)) {
                        node.setSelectionVector(reader.getIntegerArrayValue());
                    } else if (EqualsUtil.equals((Object)TYPE, (Object)nodeName)) {
                        node.setForceType((ForceType)FORCE_TYPE_NAMES.getKey((Object)reader.getStringValue()));
                    }
                    reader.moveToParentNode();
                }
                this.moveOutOfDefaultNode(reader);
            }
            return true;
        }
    }
}

