/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence_pre_v3_2;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsFactory;
import com.ur.view.constants.dev.CalibrationStatus;
import java.util.Collections;
import java.util.Map;

public class KinematicsCalibrationConversionStrategy_v3_1
extends ConversionStrategyTemplate<KinematicsCalibration> {
    private KinematicsFactory kinematicsFactory;

    public KinematicsCalibrationConversionStrategy_v3_1(KinematicsFactory kinematicsFactory) {
        super(KinematicsCalibration.class);
        this.kinematicsFactory = kinematicsFactory;
    }

    public void marshal(KinematicsCalibration node, PersistWriter writer) {
    }

    public KinematicsCalibration unmarshal(PersistReader reader) {
        double[] deltaTheta = null;
        double[] a = null;
        double[] d = null;
        double[] alpha = null;
        int[] jointChecksum = null;
        CalibrationStatus status = null;
        boolean validChecksum = false;
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            String nodeName = reader.getNodeName();
            if (EqualsUtil.equals((Object)"deltaTheta", (Object)nodeName)) {
                deltaTheta = reader.getDoubleArrayValue();
            } else if (EqualsUtil.equals((Object)"a", (Object)nodeName)) {
                a = reader.getDoubleArrayValue();
            } else if (EqualsUtil.equals((Object)"d", (Object)nodeName)) {
                d = reader.getDoubleArrayValue();
            } else if (EqualsUtil.equals((Object)"alpha", (Object)nodeName)) {
                alpha = reader.getDoubleArrayValue();
            } else if (EqualsUtil.equals((Object)"jointChecksum", (Object)nodeName)) {
                jointChecksum = reader.getIntegerArrayValue();
            } else if (EqualsUtil.equals((Object)"status", (Object)nodeName)) {
                String statusString = reader.getStringValue();
                if (EqualsUtil.equals((Object)"notInitialized", (Object)statusString)) {
                    status = CalibrationStatus.NOT_INITIALIZED;
                } else if (EqualsUtil.equals((Object)"notLinearised", (Object)statusString)) {
                    status = CalibrationStatus.NOT_LINEARIZED;
                } else if (EqualsUtil.equals((Object)"linearised", (Object)statusString)) {
                    status = CalibrationStatus.LINEARIZED;
                }
            } else if (EqualsUtil.equals((Object)"validChecksum", (Object)nodeName)) {
                validChecksum = reader.getBooleanValue();
            }
            reader.moveToParentNode();
        }
        return this.kinematicsFactory.createKinematicsCalibration(deltaTheta, a, d, alpha, jointChecksum, status, validChecksum);
    }

    public Map<String, Class<? extends KinematicsCalibration>> getClassAliases(boolean forMarshalling) {
        if (!forMarshalling) {
            return Collections.singletonMap("gui.program.KinematicsCalibration", KinematicsCalibration.class);
        }
        return Collections.emptyMap();
    }
}

