/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence_pre_v3_2;

import com.ur.lang.EqualsUtil;
import com.ur.monitor.model.JointPositionVector;
import com.ur.move.Position;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import gui.program.persistence_pre_v3_2.PositionConversionStrategy_v3_1;
import gui.program.position.MeasuredPositionFactory;
import javax.inject.Provider;
import javax.vecmath.Point3d;

public class MeasuredPositionConversionStrategy_v3_1
extends PositionConversionStrategy_v3_1 {
    private final Provider<KinematicsCalibration> programKinematicsCalibrationProvider;

    public MeasuredPositionConversionStrategy_v3_1(Provider<KinematicsCalibration> programKinematicsCalibrationProvider) {
        this.programKinematicsCalibrationProvider = programKinematicsCalibrationProvider;
    }

    public Position unmarshal(PersistReader reader) {
        JointPositionVector jointPositions = new JointPositionVector();
        Point3d toolPosition = new Point3d();
        Point3d toolAxisAngle = new Point3d();
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            String nodeName = reader.getNodeName();
            if (EqualsUtil.equals((Object)"jpv", (Object)nodeName)) {
                jointPositions = this.readJointPositions(reader);
            } else if (EqualsUtil.equals((Object)"toolPosition", (Object)nodeName)) {
                toolPosition = (Point3d)reader.convertContainedValue(Point3d.class);
            } else if (EqualsUtil.equals((Object)"toolAxisAngle", (Object)nodeName)) {
                toolAxisAngle = (Point3d)reader.convertContainedValue(Point3d.class);
            }
            reader.moveToParentNode();
        }
        KinematicsCalibration kinematicsCalibration = (KinematicsCalibration)this.programKinematicsCalibrationProvider.get();
        return MeasuredPositionFactory.createMeasuredPosition(jointPositions, toolPosition, toolAxisAngle, kinematicsCalibration);
    }
}

