/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence_pre_v3_2;

import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.Position;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import gui.program.EntityFactory;
import gui.program.persistence.WaypointNodeConversionHelper;
import gui.program.persistence_pre_v3_2.WaypointNodeConversionStrategy_v3_1;
import gui.program.position.MeasuredPositionFactory;
import gui.program.position.MeasuredWaypointNode;
import gui.program.position.WaypointNode;
import gui.program.services.ProgramReferenceService;
import javax.inject.Provider;
import javax.vecmath.Point3d;

public class MeasuredWaypointNodeConversionStrategy_v3_1
extends WaypointNodeConversionStrategy_v3_1 {
    private Provider<KinematicsCalibration> kinematicsCalibrationProvider;

    public MeasuredWaypointNodeConversionStrategy_v3_1(EntityFactory entityFactory, ProgramReferenceService programReferenceService, Provider<KinematicsCalibration> kinematicsCalibrationProvider) {
        super(entityFactory, programReferenceService);
        this.kinematicsCalibrationProvider = kinematicsCalibrationProvider;
    }

    @Override
    Position createPosition(JointPositionVector jointPositionVector, Point3d toolPosition, Point3d toolAxisAngle) {
        return MeasuredPositionFactory.createMeasuredPosition(jointPositionVector, toolPosition, toolAxisAngle, (KinematicsCalibration)this.kinematicsCalibrationProvider.get());
    }

    @Override
    void handleWaypointPoseInFeatureCoordinates(WaypointNode node, Pose6d waypointPoseInFeatureCoordinates) {
        ((MeasuredWaypointNode)node).setBaseToFeatureTransform(WaypointNodeConversionHelper.calculateBaseToFeatureTransformation(node.getPose6d(), waypointPoseInFeatureCoordinates));
    }
}

