/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence_pre_v3_2;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.pin.PinReference;
import com.ur.util.logging.Log;
import gui.program.services.ProgramReferenceService;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PinConversionStrategy_v3_0
extends ConversionStrategyTemplate<PinReference> {
    public static final Map<String, String> INVERSE_EUROMAP_SIGNAL_TRANSLATIONS = Collections.unmodifiableMap(PinConversionStrategy_v3_0.makeInverseTranslations());
    private final ProgramReferenceService programReferenceService;

    public PinConversionStrategy_v3_0(ProgramReferenceService programReferenceService) {
        super(PinReference.class);
        this.programReferenceService = programReferenceService;
    }

    public boolean canUnmarshalFrom(PersistReader reader) {
        return reader.getStringAttribute("ioName") == null;
    }

    public void marshal(PinReference toMarshal, PersistWriter writer) {
    }

    public PinReference unmarshal(PersistReader reader) {
        String ioName = null;
        while (reader.hasMoreNodes() && ioName == null) {
            reader.moveToChildNode();
            String nodeName = reader.getNodeName();
            if (EqualsUtil.equals((Object)nodeName, (Object)"installationNameReference")) {
                ioName = reader.getStringValue();
            } else if (EqualsUtil.equals((Object)nodeName, (Object)"signal")) {
                while (reader.hasMoreNodes() && ioName == null) {
                    reader.moveToChildNode();
                    if (EqualsUtil.equals((Object)"name", (Object)reader.getNodeName())) {
                        ioName = reader.getStringValue();
                    }
                    reader.moveToParentNode();
                }
            } else if (EqualsUtil.equals((Object)nodeName, (Object)"name")) {
                ioName = reader.getStringValue();
            }
            reader.moveToParentNode();
        }
        String inverseTranslation = INVERSE_EUROMAP_SIGNAL_TRANSLATIONS.get(ioName);
        return this.programReferenceService.getPinReference(inverseTranslation == null ? ioName : inverseTranslation);
    }

    public Map<String, Class<? extends PinReference>> getTypeAliases(boolean forMarshalling) {
        if (forMarshalling) {
            return Collections.emptyMap();
        }
        HashMap<String, Class<? extends PinReference>> result = new HashMap<String, Class<? extends PinReference>>();
        result.put("gui.program.ModbusSignalProgramReference", PinReference.class);
        result.put("gui.installation.EuromapSignal", PinReference.class);
        return result;
    }

    public static Map<String, String> makeInverseTranslations() {
        Properties euromapSignalNames = new Properties();
        try {
            euromapSignalNames.load(new InputStreamReader(PinConversionStrategy_v3_0.class.getResourceAsStream("euromap_signal_names.properties"), "UTF-8"));
        }
        catch (IOException e) {
            Log.error((String)"Cannot load resource for deserializing programs saved before software version 3.2", (Throwable)e);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Pattern translationPattern = Pattern.compile("\"([^\"]*)\"");
        for (String key : euromapSignalNames.stringPropertyNames()) {
            Matcher matcher = translationPattern.matcher(euromapSignalNames.getProperty(key));
            while (matcher.find()) {
                result.put(matcher.group(1), key);
            }
        }
        return result;
    }
}

