/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence_pre_v3_2;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentificationProvider;
import com.ur.polyscope.version.urversion.URVersion;
import gui.program.EntityFactory;
import gui.program.FileManagementProgramComponent;
import gui.program.MainProgram;
import gui.program.ProgramMetaDataComponent;
import gui.program.ProgramRootNode;
import gui.program.calibration.KinematicDataComponent;
import gui.program.persistence_pre_v3_2.LegacyProgramNodeBuilder;
import java.util.Collections;
import java.util.Map;

public class ProgramRootNodeConversionStrategy_v3_1
extends ConversionStrategyTemplate<ProgramRootNode> {
    private final EntityFactory entityFactory;
    private final RobotIdentificationProvider robotIdentificationProvider;

    public ProgramRootNodeConversionStrategy_v3_1(EntityFactory entityFactory, RobotIdentificationProvider robotIdentificationProvider) {
        super(ProgramRootNode.class);
        this.entityFactory = entityFactory;
        this.robotIdentificationProvider = robotIdentificationProvider;
    }

    public void marshal(ProgramRootNode node, PersistWriter writer) {
    }

    public ProgramRootNode unmarshal(PersistReader reader) {
        return (ProgramRootNode)new ProgramRootNodeBuilder(reader).buildNode();
    }

    public Map<String, Class<? extends ProgramRootNode>> getClassAliases(boolean forMarshalling) {
        if (forMarshalling) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("gui.program.ProgramRootNode", ProgramRootNode.class);
    }

    private class ProgramRootNodeBuilder
    extends LegacyProgramNodeBuilder<ProgramRootNode> {
        protected ProgramRootNodeBuilder(PersistReader reader) {
            super(ProgramRootNode.class, reader);
        }

        @Override
        protected ProgramRootNode createNode() {
            ProgramRootNode result = ProgramRootNodeConversionStrategy_v3_1.this.entityFactory.createProgramRootNode();
            result.removeAllChildren();
            return result;
        }

        @Override
        public boolean tryReadFromChildNode(ProgramRootNode node, PersistReader reader) {
            if (!EqualsUtil.equals((Object)"gui.program.ProgramRootNode", (Object)reader.getNodeName())) {
                return false;
            }
            if (this.moveToDefaultNode(reader)) {
                URVersion programVersion = null;
                URVersion lastSaved = null;
                RobotIdentification serianNumber = null;
                while (reader.hasMoreNodes()) {
                    reader.moveToChildNode();
                    String nodeName = reader.getNodeName();
                    if (EqualsUtil.equals((Object)"name", (Object)nodeName)) {
                        node.setName(reader.getStringValue());
                    } else if (EqualsUtil.equals((Object)"directory", (Object)nodeName)) {
                        node.getComponent(FileManagementProgramComponent.class).setProgramDirectory(reader.getStringValue());
                    } else if (EqualsUtil.equals((Object)"robotEnvironmentFileName", (Object)nodeName)) {
                        node.getComponent(FileManagementProgramComponent.class).setInstallationFileName(reader.getStringValue());
                    } else if (EqualsUtil.equals((Object)"mainProgram", (Object)nodeName)) {
                        node.setMainProgram((MainProgram)reader.convertContainedValue(MainProgram.class));
                    } else if (EqualsUtil.equals((Object)"kinematics", (Object)nodeName)) {
                        node.setComponent(new KinematicDataComponent((KinematicsCalibration)reader.convertContainedValue(KinematicsCalibration.class)));
                    } else if (EqualsUtil.equalsOneOf((Object)nodeName, (Object[])new String[]{"programVersion", "programEditedInPolyScopeVersion"})) {
                        programVersion = (URVersion)reader.convertContainedValue(URVersion.class);
                    } else if (EqualsUtil.equals((Object)"lastSavedInVersion", (Object)nodeName)) {
                        lastSaved = (URVersion)reader.convertContainedValue(URVersion.class);
                    } else if (EqualsUtil.equals((Object)"serialNumberRobot", (Object)nodeName)) {
                        serianNumber = ProgramRootNodeConversionStrategy_v3_1.this.robotIdentificationProvider.fromStringHydrateProgram(reader.getStringValue());
                    }
                    reader.moveToParentNode();
                }
                if (programVersion != null) {
                    node.setComponent(new ProgramMetaDataComponent(programVersion, lastSaved, serianNumber));
                }
                this.moveOutOfDefaultNode(reader);
            }
            return true;
        }
    }
}

