/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence_pre_v3_2;

import com.ur.lang.BijectiveEnumMap;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.application.PersistComponent;
import com.ur.polyscope.application.XmlDataModel;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.swing.expression.Expression;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.view.variables.core.Variable;
import gui.program.EntityFactory;
import gui.program.persistence_pre_v3_2.LegacyProgramNodeBuilder;
import gui.program.persistence_pre_v3_2.SetNodeConversionStrategy_v3_0$SetNodeBuilder$1$AjcClosure1;
import gui.program.persistence_pre_v3_2.SetNodeConversionStrategy_v3_0$SetNodeBuilder$1$AjcClosure3;
import gui.program.services.ProgramReferenceService;
import gui.program.setnode.SetNode;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class SetNodeConversionStrategy_v3_0
extends ConversionStrategyTemplate<SetNode> {
    private final EntityFactory entityFactory;
    private final ProgramReferenceService programReferenceService;
    private final IOService ioService;
    private final PersistComponent payloadComponent;
    static final BijectiveEnumMap<SetNode.Type, String> TYPE_NAMES = new BijectiveEnumMap(SetNode.Type.class).put((Enum)SetNode.Type.UNDEFINED, (Object)"UNDEFINED").put((Enum)SetNode.Type.NO_ACTION, (Object)"NO_ACTION").put((Enum)SetNode.Type.DIGITAL_OUTPUT_ACTION, (Object)"DIGITAL_OUTPUT_ACTION").put((Enum)SetNode.Type.ANALOG_OUTPUT_ACTION, (Object)"ANALOG_OUTPUT_ACTION").put((Enum)SetNode.Type.EXPRESSION_OUTPUT_ACTION, (Object)"EXPRESSION_OUTPUT_ACTION").put((Enum)SetNode.Type.INCREMENT_VARIABLE, (Object)"INCREMENT_VARIABLE").put((Enum)SetNode.Type.SINGLE_DIGITAL_PULSE, (Object)"Not Supported").seal();

    @Inject
    public SetNodeConversionStrategy_v3_0(EntityFactory entityFactory, ProgramReferenceService programReferenceService, IOService ioService, @Named(value="payload-with-cog") @Named(value="payload-with-cog") PersistComponent payloadComponent) {
        super(SetNode.class);
        this.entityFactory = entityFactory;
        this.programReferenceService = programReferenceService;
        this.ioService = ioService;
        this.payloadComponent = payloadComponent;
    }

    public boolean canUnmarshalFrom(PersistReader reader) {
        return reader.getStringAttribute("type") == null;
    }

    public void marshal(SetNode node, PersistWriter writer) {
    }

    public SetNode unmarshal(PersistReader reader) {
        return (SetNode)new SetNodeBuilder(reader).buildNode();
    }

    public Map<String, Class<? extends SetNode>> getClassAliases(boolean forMarshalling) {
        if (forMarshalling) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("gui.program.ActionNode", SetNode.class);
    }

    private class SetNodeBuilder
    extends LegacyProgramNodeBuilder<SetNode> {
        private SetNode.Type type;
        private int selectedDigitalSensor;
        private boolean configurableOutputIO;
        private boolean toolOutputIO;
        private boolean analogIO;
        private PinReference pinReference;
        private int digitalValue;
        private int selectedAnalogSensor;
        private double analogValue;
        private Expression expression;
        private Variable selectedVariable;
        private String selectedVariableName;
        private boolean setPayloadValue;
        private double payloadValue;

        public SetNodeBuilder(PersistReader reader) {
            super(SetNode.class, reader);
            this.type = SetNode.Type.UNDEFINED;
            this.selectedDigitalSensor = -1;
            this.configurableOutputIO = false;
            this.toolOutputIO = false;
            this.analogIO = false;
            this.pinReference = null;
            this.digitalValue = 0;
            this.selectedAnalogSensor = -1;
            this.analogValue = 0.0;
            this.setPayloadValue = false;
            this.payloadValue = 0.0;
        }

        @Override
        protected SetNode createNode() {
            return SetNodeConversionStrategy_v3_0.this.entityFactory.createSetNode();
        }

        @Override
        public boolean tryReadFromChildNode(SetNode node, PersistReader reader) {
            if (!EqualsUtil.equals((Object)"gui.program.ActionNode", (Object)reader.getNodeName())) {
                return false;
            }
            if (this.moveToDefaultNode(reader)) {
                while (reader.hasMoreNodes()) {
                    reader.moveToChildNode();
                    String nodeName = reader.getNodeName();
                    if (EqualsUtil.equals((Object)nodeName, (Object)"type")) {
                        this.type = (SetNode.Type)TYPE_NAMES.getKey((Object)reader.getStringValue());
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"selectedDigitalSensor")) {
                        this.selectedDigitalSensor = reader.getIntegerValue();
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"configurableOutputIO")) {
                        this.configurableOutputIO = reader.getBooleanValue();
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"toolOutputIO")) {
                        this.toolOutputIO = reader.getBooleanValue();
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"analogIO")) {
                        this.analogIO = reader.getBooleanValue();
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"modbusSignalProgramReference")) {
                        this.pinReference = (PinReference)reader.convertContainedValue(PinReference.class);
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"euromapSignal")) {
                        this.pinReference = (PinReference)reader.convertContainedValue(PinReference.class);
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"digitalValue")) {
                        this.digitalValue = reader.getIntegerValue();
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"selectedAnalogSensor")) {
                        this.selectedAnalogSensor = reader.getIntegerValue();
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"analogValue")) {
                        this.analogValue = reader.getDoubleValue();
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"expr")) {
                        this.expression = (Expression)reader.convertContainedValue(Expression.class);
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"selectedVariable")) {
                        this.selectedVariable = (Variable)reader.convertContainedValue(Variable.class);
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"selectedVariableName")) {
                        this.selectedVariableName = reader.getStringValue();
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"setPayloadValue")) {
                        this.setPayloadValue = reader.getBooleanValue();
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"payloadValue")) {
                        this.payloadValue = reader.getDoubleValue();
                    }
                    reader.moveToParentNode();
                }
                this.moveOutOfDefaultNode(reader);
            }
            node.setType(this.type);
            this.setPinReference(node, this.type);
            node.setDigitalValue(this.digitalValue);
            node.setAnalogValue(this.analogValue);
            if (this.expression != null) {
                node.setExpression(this.expression.getExpression());
            }
            if (this.selectedVariable != null) {
                node.setVariable(SetNodeConversionStrategy_v3_0.this.programReferenceService.getInstallationVariableReference(this.selectedVariable.getName()));
            }
            if (this.selectedVariableName != null) {
                node.setVariable(SetNodeConversionStrategy_v3_0.this.programReferenceService.getInstallationVariableReference(this.selectedVariableName));
            }
            this.readPayload(node, (DataModel)new XmlDataModel(reader){
                private static final String PAYLOAD_ATTRIBUTE = "payload";
                private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
                private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

                public double get(String key, double value) {
                    String string = key;
                    double d = value;
                    JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)Conversions.doubleObject((double)d));
                    Object[] objectArray = new Object[]{this, string, Conversions.doubleObject((double)d), joinPoint};
                    SetNodeConversionStrategy_v3_0$SetNodeBuilder$1$AjcClosure1 setNodeConversionStrategy_v3_0$SetNodeBuilder$1$AjcClosure1 = new SetNodeConversionStrategy_v3_0$SetNodeBuilder$1$AjcClosure1(objectArray);
                    return Conversions.doubleValue((Object)UncaughtExceptionAspect.aspectOf().aroundMethod(setNodeConversionStrategy_v3_0$SetNodeBuilder$1$AjcClosure1.linkClosureAndJoinPoint(69648)));
                }

                public boolean isSet(String key) {
                    String string = key;
                    JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string);
                    Object[] objectArray = new Object[]{this, string, joinPoint};
                    SetNodeConversionStrategy_v3_0$SetNodeBuilder$1$AjcClosure3 setNodeConversionStrategy_v3_0$SetNodeBuilder$1$AjcClosure3 = new SetNodeConversionStrategy_v3_0$SetNodeBuilder$1$AjcClosure3(objectArray);
                    return Conversions.booleanValue((Object)UncaughtExceptionAspect.aspectOf().aroundMethod(setNodeConversionStrategy_v3_0$SetNodeBuilder$1$AjcClosure3.linkClosureAndJoinPoint(69648)));
                }

                static {
                    1.ajc$preClinit();
                }

                static final /* synthetic */ double get_aroundBody0(1 ajc$this, String key, double value, JoinPoint joinPoint) {
                    if (ajc$this.SetNodeBuilder.this.setPayloadValue && PAYLOAD_ATTRIBUTE.equals(key)) {
                        return ajc$this.SetNodeBuilder.this.payloadValue;
                    }
                    return Double.NaN;
                }

                static final /* synthetic */ boolean isSet_aroundBody2(1 ajc$this, String key, JoinPoint joinPoint) {
                    if (PAYLOAD_ATTRIBUTE.equals(key)) {
                        return ajc$this.SetNodeBuilder.this.setPayloadValue;
                    }
                    return false;
                }

                private static /* synthetic */ void ajc$preClinit() {
                    Factory factory = new Factory("SetNodeConversionStrategy_v3_0.java", 1.class);
                    ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "get", "gui.program.persistence_pre_v3_2.SetNodeConversionStrategy_v3_0$SetNodeBuilder$1", "java.lang.String:double", "key:value", "", "double"), 176);
                    ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isSet", "gui.program.persistence_pre_v3_2.SetNodeConversionStrategy_v3_0$SetNodeBuilder$1", "java.lang.String", "key", "", "boolean"), 184);
                }
            });
            return true;
        }

        protected void readPayload(SetNode node, DataModel reader) {
            node.setPayloadWithCog(SetNodeConversionStrategy_v3_0.this.payloadComponent.deserializer(reader));
        }

        private void setPinReference(SetNode result, SetNode.Type type) {
            Pin<?> digitalOutput = this.getDigitalOutput();
            Pin<?> analogOutput = this.getAnalogOutput();
            switch (type) {
                case ANALOG_OUTPUT_ACTION: {
                    if (analogOutput == null) break;
                    result.setAnalogPinReference(SetNodeConversionStrategy_v3_0.this.programReferenceService.getPinReference(analogOutput));
                    break;
                }
                case DIGITAL_OUTPUT_ACTION: {
                    if (digitalOutput != null) {
                        result.setDigitalPinReference(SetNodeConversionStrategy_v3_0.this.programReferenceService.getPinReference(digitalOutput));
                        break;
                    }
                    if (this.pinReference == null) break;
                    result.setDigitalPinReference(this.pinReference);
                    break;
                }
                case EXPRESSION_OUTPUT_ACTION: {
                    if (digitalOutput != null) {
                        result.setDigitalExpressionPinReference(SetNodeConversionStrategy_v3_0.this.programReferenceService.getPinReference(digitalOutput));
                        break;
                    }
                    if (this.pinReference != null) {
                        result.setDigitalExpressionPinReference(this.pinReference);
                        break;
                    }
                    if (analogOutput == null) break;
                    result.setDigitalExpressionPinReference(SetNodeConversionStrategy_v3_0.this.programReferenceService.getPinReference(analogOutput));
                    break;
                }
            }
        }

        private Pin<?> getDigitalOutput() {
            if (this.selectedDigitalSensor < 0) {
                return null;
            }
            if (this.configurableOutputIO) {
                return SetNodeConversionStrategy_v3_0.this.ioService.getConfigurableDigitalOutputPins()[this.selectedDigitalSensor];
            }
            if (this.toolOutputIO) {
                return SetNodeConversionStrategy_v3_0.this.ioService.getToolDigitalOutputPins()[this.selectedDigitalSensor];
            }
            if (this.analogIO) {
                return SetNodeConversionStrategy_v3_0.this.ioService.getStandardAnalogOutputPins()[this.selectedDigitalSensor];
            }
            if (this.selectedDigitalSensor < 8) {
                return SetNodeConversionStrategy_v3_0.this.ioService.getStandardDigitalOutputPins()[this.selectedDigitalSensor];
            }
            if (this.selectedDigitalSensor < 10) {
                return SetNodeConversionStrategy_v3_0.this.ioService.getToolDigitalOutputPins()[this.selectedDigitalSensor - 8];
            }
            return SetNodeConversionStrategy_v3_0.this.ioService.getStandardAnalogOutputPins()[this.selectedDigitalSensor - 10];
        }

        private Pin<?> getAnalogOutput() {
            if (this.selectedAnalogSensor < 0) {
                return null;
            }
            return SetNodeConversionStrategy_v3_0.this.ioService.getStandardAnalogOutputPins()[this.selectedAnalogSensor];
        }
    }
}

