/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence_pre_v3_2;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.application.PersistComponent;
import com.ur.polyscope.application.XmlDataModel;
import com.ur.polyscope.persistence.ConversionStrategy;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.pin.PinReference;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.view.variables.InstallationVariableReference;
import gui.program.EntityFactory;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import gui.program.persistence_pre_v3_2.SetNodeConversionStrategy_v3_0;
import gui.program.setnode.SetNode;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;

public class SetNodeConversionStrategy_v3_1
extends ProgramNodeConversionStrategyBase<SetNode> {
    public static final String TYPE_ATTRIBUTE = "type";
    private static final String PIN_NODE = "pin";
    private static final String ANALOG_VALUE_NODE = "analogValue";
    private static final String DIGITAL_VALUE_NODE = "digitalValue";
    private static final String EXPRESSION_NODE = "expression";
    private static final String INSTALLATION_VARIABLE_NODE = "installationVariable";
    private final EntityFactory entityFactory;
    private final PersistComponent payloadComponent;
    private final ConversionStrategy tcpComponent;

    @Inject
    public SetNodeConversionStrategy_v3_1(EntityFactory entityFactory, @Named(value="payload-with-cog") @Named(value="payload-with-cog") PersistComponent payloadComponent, @Named(value="tcp-reference") @Named(value="tcp-reference") ConversionStrategy tcpComponent) {
        super(SetNode.class);
        this.entityFactory = entityFactory;
        this.payloadComponent = payloadComponent;
        this.tcpComponent = tcpComponent;
    }

    @Override
    public boolean canUnmarshalFrom(PersistReader reader) {
        return reader.getStringAttribute(TYPE_ATTRIBUTE) != null;
    }

    @Override
    public void writeToAttributes(SetNode node, PersistWriter writer) {
        SetNode.Type type = node.getType();
        writer.addAttribute(TYPE_ATTRIBUTE, type.toString());
        this.writePayload(node, writer);
    }

    @Override
    public void writeToChildNodes(SetNode node, PersistWriter writer) {
        this.tcpComponent.marshal((Object)node.getTcpReference(), writer);
        switch (node.getType()) {
            case ANALOG_OUTPUT_ACTION: {
                this.writeAnalogPinReference(node, writer);
                this.writeAnalogValue(node, writer);
                break;
            }
            case DIGITAL_OUTPUT_ACTION: {
                this.writeDigitalPinReference(node, writer);
                this.writeDigitalValue(node, writer);
                break;
            }
            case EXPRESSION_OUTPUT_ACTION: {
                this.writeDigitalExpressionPinReference(node, writer);
                this.writeExpression(node, writer);
                break;
            }
            case INCREMENT_VARIABLE: {
                this.writeInstallationVariable(node, writer);
                break;
            }
        }
    }

    @Override
    protected SetNode createNode(PersistReader reader) {
        return this.entityFactory.createSetNode();
    }

    @Override
    public void readFromAttributes(SetNode node, PersistReader reader) {
        SetNode.Type type = (SetNode.Type)SetNodeConversionStrategy_v3_0.TYPE_NAMES.getKey((Object)reader.getStringAttribute(TYPE_ATTRIBUTE));
        node.setType(type);
        this.readPayload(node, reader);
    }

    @Override
    public boolean tryReadFromChildNode(SetNode node, PersistReader reader) {
        SetNode.Type type = node.getType();
        String nodeName = reader.getNodeName();
        if (this.tcpComponent.canUnmarshalFrom(reader)) {
            node.setTcpReference((DomainComponent)this.tcpComponent.unmarshal(reader));
        } else if (EqualsUtil.equals((Object)nodeName, (Object)PIN_NODE)) {
            PinReference pinReference = this.readPinReference(reader);
            if (type == SetNode.Type.ANALOG_OUTPUT_ACTION) {
                node.setAnalogPinReference(pinReference);
            } else if (type == SetNode.Type.DIGITAL_OUTPUT_ACTION) {
                node.setDigitalPinReference(pinReference);
            } else if (type == SetNode.Type.EXPRESSION_OUTPUT_ACTION) {
                node.setDigitalExpressionPinReference(pinReference);
            }
        } else if (EqualsUtil.equals((Object)nodeName, (Object)ANALOG_VALUE_NODE)) {
            this.readAnalogValue(node, reader);
        } else if (EqualsUtil.equals((Object)nodeName, (Object)DIGITAL_VALUE_NODE)) {
            this.readDigitalValue(node, reader);
        } else if (EqualsUtil.equals((Object)nodeName, (Object)EXPRESSION_NODE)) {
            this.readExpression(node, reader);
        } else if (EqualsUtil.equals((Object)nodeName, (Object)INSTALLATION_VARIABLE_NODE)) {
            this.readInstallationVariable(node, reader);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Class<? extends SetNode>> getTypeAliases(boolean forMarshalling) {
        HashMap<String, Class<? extends SetNode>> result = new HashMap<String, Class<? extends SetNode>>();
        result.put("SetNode", SetNode.class);
        if (!forMarshalling) {
            result.put("ActionNode", SetNode.class);
        }
        return result;
    }

    protected void writePayload(SetNode node, PersistWriter writer) {
        this.payloadComponent.serialize(node.getPayloadWithCog(), (DataModel)new XmlDataModel(writer));
    }

    protected void readPayload(SetNode node, PersistReader reader) {
        node.setPayloadWithCog(this.payloadComponent.deserializer((DataModel)new XmlDataModel(reader)));
    }

    private void writeAnalogPinReference(SetNode node, PersistWriter writer) {
        this.writePinReference(node.getAnalogPinReference(), writer);
    }

    private void writeDigitalPinReference(SetNode node, PersistWriter writer) {
        this.writePinReference(node.getDigitalPinReference(), writer);
    }

    private void writeDigitalExpressionPinReference(SetNode node, PersistWriter writer) {
        this.writePinReference(node.getDigitalExpressionPinReference(), writer);
    }

    protected void writePinReference(PinReference reference, PersistWriter writer) {
        writer.writeNodeWithValue(PIN_NODE, (Object)reference);
    }

    protected PinReference readPinReference(PersistReader reader) {
        return (PinReference)reader.convertContainedValue(PinReference.class);
    }

    private void writeAnalogValue(SetNode node, PersistWriter writer) {
        writer.writeNodeWithValue(ANALOG_VALUE_NODE, (Object)node.getAnalogValue());
    }

    private void readAnalogValue(SetNode node, PersistReader reader) {
        node.setAnalogValue(reader.getDoubleValue());
    }

    private void writeDigitalValue(SetNode node, PersistWriter writer) {
        writer.writeNodeWithValue(DIGITAL_VALUE_NODE, (Object)node.getDigitalValue());
    }

    private void readDigitalValue(SetNode node, PersistReader reader) {
        node.setDigitalValue(reader.getIntegerValue());
    }

    private void writeExpression(SetNode node, PersistWriter writer) {
        writer.writeNodeWithValue(EXPRESSION_NODE, (Object)node.getExpression());
    }

    private void readExpression(SetNode node, PersistReader reader) {
        node.setExpression((ExpressionBranchNode)reader.convertContainedValue(ExpressionBranchNode.class));
    }

    private void writeInstallationVariable(SetNode node, PersistWriter writer) {
        writer.writeNodeWithValue(INSTALLATION_VARIABLE_NODE, (Object)node.getVariable());
    }

    private void readInstallationVariable(SetNode node, PersistReader reader) {
        node.setVariable((InstallationVariableReference)reader.convertContainedValue(InstallationVariableReference.class));
    }
}

