/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence_pre_v3_2;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.swing.expression.Expression;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.view.variables.InstallationVariableReference;
import com.ur.view.variables.core.ProgramVariable;
import com.ur.view.variables.core.Variable;
import gui.program.EntityFactory;
import gui.program.services.ProgramReferenceService;
import gui.program.services.geom.GeomFeatureReference;
import java.util.HashMap;
import java.util.Map;

public class VariableConversionStrategy_v3_0
extends ConversionStrategyTemplate<Variable> {
    private final EntityFactory entityFactory;
    private final ProgramReferenceService programReferenceService;

    public VariableConversionStrategy_v3_0(EntityFactory entityFactory, ProgramReferenceService programReferenceService) {
        super(Variable.class);
        this.entityFactory = entityFactory;
        this.programReferenceService = programReferenceService;
    }

    public boolean canUnmarshalFrom(PersistReader reader) {
        return reader.getStringAttribute("variableName") == null && reader.getStringAttribute("name") == null && reader.getStringAttribute("featureName") == null;
    }

    public void marshal(Variable variable, PersistWriter writer) {
    }

    public Variable unmarshal(PersistReader reader) {
        String name = null;
        String value = null;
        boolean prefersPersistentValue = false;
        ExpressionBranchNode initExpression = null;
        GeomFeatureReference reference = null;
        ProgramVariable result = this.entityFactory.createVariable();
        while (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            if (EqualsUtil.equals((Object)"name", (Object)reader.getNodeName())) {
                name = reader.getStringValue();
            } else if (EqualsUtil.equals((Object)"value", (Object)reader.getNodeName())) {
                value = reader.getStringValue();
            } else if (EqualsUtil.equals((Object)"prefersPersistentValue", (Object)reader.getNodeName())) {
                prefersPersistentValue = reader.getBooleanValue();
            } else if (EqualsUtil.equals((Object)"initExpression", (Object)reader.getNodeName())) {
                initExpression = ((Expression)reader.convertContainedValue((Object)result, Expression.class)).getExpression();
            } else if (EqualsUtil.equals((Object)"geomFeatureReference", (Object)reader.getNodeName())) {
                reference = (GeomFeatureReference)((Object)reader.convertContainedValue(GeomFeatureReference.class));
            }
            reader.moveToParentNode();
        }
        if (reference != null) {
            return this.programReferenceService.getGeomFeatureVariable(reference.getKey());
        }
        if (value != null) {
            return this.programReferenceService.getInstallationVariableReference(name);
        }
        result.setName(name);
        result.setPrefersPersistentValue(prefersPersistentValue);
        result.setInitExpressionNode(initExpression);
        return result;
    }

    public Map<String, Class<? extends Variable>> getClassAliases(boolean forMarshalling) {
        if (!forMarshalling) {
            HashMap<String, Class<? extends Variable>> aliases = new HashMap<String, Class<? extends Variable>>();
            aliases.put("gui.program.Variable", Variable.class);
            aliases.put("gui.installation.InstallationVariable", InstallationVariableReference.class);
            return aliases;
        }
        return super.getTypeAliases(forMarshalling);
    }
}

