/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence_pre_v3_2;

import com.ur.lang.BijectiveEnumMap;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.swing.expression.Expression;
import gui.program.EntityFactory;
import gui.program.WaitNode;
import gui.program.persistence_pre_v3_2.LegacyProgramNodeBuilder;
import gui.program.services.ProgramReferenceService;
import java.util.Collections;
import java.util.Map;

public class WaitNodeConversionStrategy_v3_0
extends ConversionStrategyTemplate<WaitNode> {
    static final BijectiveEnumMap<WaitNode.Type, String> TYPE_NAMES = new BijectiveEnumMap(WaitNode.Type.class).put((Enum)WaitNode.Type.UNDEFINED, (Object)"UNDEFINED").put((Enum)WaitNode.Type.NO_WAIT, (Object)"NO_WAIT").put((Enum)WaitNode.Type.TIMER_WAIT, (Object)"TIMER_WAIT").put((Enum)WaitNode.Type.DIGITAL_SENSOR_WAIT, (Object)"DIGITAL_SENSOR_WAIT").put((Enum)WaitNode.Type.ANALOG_SENSOR_WAIT, (Object)"ANALOG_SENSOR_WAIT").put((Enum)WaitNode.Type.EXPRESSION_WAIT, (Object)"EXPRESSION_WAIT").seal();
    private final EntityFactory entityFactory;
    private final ProgramReferenceService programReferenceService;
    private final IOService ioService;

    public WaitNodeConversionStrategy_v3_0(EntityFactory entityFactory, ProgramReferenceService programReferenceService, IOService ioService) {
        super(WaitNode.class);
        this.entityFactory = entityFactory;
        this.programReferenceService = programReferenceService;
        this.ioService = ioService;
    }

    public boolean canUnmarshalFrom(PersistReader reader) {
        return reader.getStringAttribute("type") == null;
    }

    public void marshal(WaitNode node, PersistWriter writer) {
    }

    public WaitNode unmarshal(PersistReader reader) {
        return (WaitNode)new WaitNodeBuilder(reader).buildNode();
    }

    public Map<String, Class<? extends WaitNode>> getClassAliases(boolean forMarshalling) {
        if (forMarshalling) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("gui.program.WaitNode", WaitNode.class);
    }

    private class WaitNodeBuilder
    extends LegacyProgramNodeBuilder<WaitNode> {
        private WaitNode.Type type;
        private double waitTime;
        private int selectedDigitalSensor;
        private boolean isConfigurableDigitalSensor;
        private boolean isToolDigitalSensor;
        private PinReference pinReference;
        private int digitalValue;
        private int selectedAnalogSensor;
        private int analogComparison;
        private double analogValue;
        private Expression expression;

        public WaitNodeBuilder(PersistReader reader) {
            super(WaitNode.class, reader);
            this.type = WaitNode.Type.UNDEFINED;
            this.waitTime = 0.01;
            this.selectedDigitalSensor = -1;
            this.isConfigurableDigitalSensor = false;
            this.isToolDigitalSensor = false;
            this.pinReference = null;
            this.digitalValue = 0;
            this.selectedAnalogSensor = -1;
            this.analogComparison = 0;
            this.analogValue = 0.0;
            this.expression = new Expression();
        }

        @Override
        protected WaitNode createNode() {
            return WaitNodeConversionStrategy_v3_0.this.entityFactory.createWaitNode();
        }

        @Override
        public boolean tryReadFromChildNode(WaitNode node, PersistReader reader) {
            if (!EqualsUtil.equals((Object)"gui.program.WaitNode", (Object)reader.getNodeName())) {
                return false;
            }
            if (this.moveToDefaultNode(reader)) {
                while (reader.hasMoreNodes()) {
                    reader.moveToChildNode();
                    String nodeName = reader.getNodeName();
                    if (EqualsUtil.equals((Object)nodeName, (Object)"type")) {
                        this.type = (WaitNode.Type)TYPE_NAMES.getKey((Object)reader.getStringValue());
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"selectedDigitalSensor")) {
                        this.selectedDigitalSensor = reader.getIntegerValue();
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"isConfigurableDigitalSensor")) {
                        this.isConfigurableDigitalSensor = reader.getBooleanValue();
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"isToolDigitalSensor")) {
                        this.isToolDigitalSensor = reader.getBooleanValue();
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"modbusSignalProgramReference")) {
                        this.pinReference = (PinReference)reader.convertContainedValue(PinReference.class);
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"euromapSignal")) {
                        this.pinReference = (PinReference)reader.convertContainedValue(PinReference.class);
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"digitalValue")) {
                        this.digitalValue = reader.getIntegerValue();
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"selectedAnalogSensor")) {
                        this.selectedAnalogSensor = reader.getIntegerValue();
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"analogValue")) {
                        this.analogValue = reader.getDoubleValue();
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"analogComparison")) {
                        this.analogComparison = reader.getIntegerValue();
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"expr")) {
                        this.expression = (Expression)reader.convertContainedValue(Expression.class);
                    } else if (EqualsUtil.equals((Object)nodeName, (Object)"waitTime")) {
                        this.waitTime = reader.getDoubleValue();
                    }
                    reader.moveToParentNode();
                }
                this.moveOutOfDefaultNode(reader);
            }
            node.setType(this.type);
            this.setPinReference(node, this.type);
            node.setDigitalValue(this.digitalValue);
            node.setAnalogValue(this.analogValue);
            node.setAnalogComparison(this.analogComparison);
            if (this.expression != null) {
                node.setExpression(this.expression.getExpression());
            }
            node.setWaitTime(this.waitTime);
            return true;
        }

        private void setPinReference(WaitNode result, WaitNode.Type type) {
            Pin<?> digitalOutput = this.getDigitalInput();
            Pin<?> analogOutput = this.getAnalogInput();
            switch (type) {
                case ANALOG_SENSOR_WAIT: {
                    if (analogOutput == null) break;
                    result.setAnalogPinReference(WaitNodeConversionStrategy_v3_0.this.programReferenceService.getPinReference(analogOutput));
                    break;
                }
                case DIGITAL_SENSOR_WAIT: {
                    if (digitalOutput != null) {
                        result.setDigitalPinReference(WaitNodeConversionStrategy_v3_0.this.programReferenceService.getPinReference(digitalOutput));
                        break;
                    }
                    if (this.pinReference == null) break;
                    result.setDigitalPinReference(this.pinReference);
                    break;
                }
            }
        }

        private Pin<?> getDigitalInput() {
            if (this.selectedDigitalSensor < 0) {
                return null;
            }
            if (this.isConfigurableDigitalSensor) {
                return WaitNodeConversionStrategy_v3_0.this.ioService.getConfigurableDigitalInputPins()[this.selectedDigitalSensor];
            }
            if (this.isToolDigitalSensor) {
                return WaitNodeConversionStrategy_v3_0.this.ioService.getToolDigitalInputPins()[this.selectedDigitalSensor];
            }
            if (this.selectedDigitalSensor < 8) {
                return WaitNodeConversionStrategy_v3_0.this.ioService.getStandardDigitalInputPins()[this.selectedDigitalSensor];
            }
            return WaitNodeConversionStrategy_v3_0.this.ioService.getToolDigitalInputPins()[this.selectedDigitalSensor - 8];
        }

        private Pin<?> getAnalogInput() {
            if (this.selectedAnalogSensor < 0) {
                return null;
            }
            return WaitNodeConversionStrategy_v3_0.this.ioService.getAllAnalogInputPins()[this.selectedAnalogSensor];
        }
    }
}

