/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence_pre_v3_2;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.pin.PinReference;
import com.ur.swing.expression.ExpressionBranchNode;
import gui.program.EntityFactory;
import gui.program.WaitNode;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import gui.program.persistence_pre_v3_2.WaitNodeConversionStrategy_v3_0;
import java.util.Collections;
import java.util.Map;

public class WaitNodeConversionStrategy_v3_1
extends ProgramNodeConversionStrategyBase<WaitNode> {
    public static final String TYPE_ATTRIBUTE = "type";
    private static final String PIN_NODE = "pin";
    private static final String ANALOG_VALUE_NODE = "analogValue";
    private static final String ANALOG_COMPARISON_NODE = "analogComparison";
    private static final String DIGITAL_VALUE_NODE = "digitalValue";
    private static final String EXPRESSION_NODE = "expression";
    private static final String WAIT_TIME_NODE = "waitTime";
    private final EntityFactory entityFactory;

    public WaitNodeConversionStrategy_v3_1(EntityFactory entityFactory) {
        super(WaitNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public boolean canUnmarshalFrom(PersistReader reader) {
        return reader.getStringAttribute(TYPE_ATTRIBUTE) != null;
    }

    @Override
    public void writeToAttributes(WaitNode node, PersistWriter writer) {
        WaitNode.Type type = node.getType();
        writer.addAttribute(TYPE_ATTRIBUTE, type.toString());
    }

    @Override
    public void writeToChildNodes(WaitNode node, PersistWriter writer) {
        WaitNode.Type type = node.getType();
        switch (type) {
            case ANALOG_SENSOR_WAIT: {
                this.writeAnalogPinReference(node, writer);
                this.writeAnalogComparison(node, writer);
                this.writeAnalogValue(node, writer);
                break;
            }
            case DIGITAL_SENSOR_WAIT: {
                this.writeDigitalPinReference(node, writer);
                this.writeDigitalValue(node, writer);
                break;
            }
            case EXPRESSION_WAIT: {
                this.writeExpression(node, writer);
                break;
            }
            case TIMER_WAIT: {
                this.writeWaitTime(node, writer);
                break;
            }
        }
    }

    @Override
    protected WaitNode createNode(PersistReader reader) {
        return this.entityFactory.createWaitNode();
    }

    @Override
    public void readFromAttributes(WaitNode node, PersistReader reader) {
        WaitNode.Type type = (WaitNode.Type)WaitNodeConversionStrategy_v3_0.TYPE_NAMES.getKey((Object)reader.getStringAttribute(TYPE_ATTRIBUTE));
        node.setType(type);
    }

    @Override
    public boolean tryReadFromChildNode(WaitNode node, PersistReader reader) {
        WaitNode.Type type = node.getType();
        String nodeName = reader.getNodeName();
        if (EqualsUtil.equals((Object)nodeName, (Object)PIN_NODE)) {
            if (type == WaitNode.Type.ANALOG_SENSOR_WAIT) {
                node.setAnalogPinReference(this.readPinReference(reader));
            } else if (type == WaitNode.Type.DIGITAL_SENSOR_WAIT) {
                node.setDigitalPinReference(this.readPinReference(reader));
            }
        } else if (EqualsUtil.equals((Object)nodeName, (Object)ANALOG_VALUE_NODE)) {
            this.readAnalogValue(node, reader);
        } else if (EqualsUtil.equals((Object)nodeName, (Object)ANALOG_COMPARISON_NODE)) {
            this.readAnalogComparison(node, reader);
        } else if (EqualsUtil.equals((Object)nodeName, (Object)DIGITAL_VALUE_NODE)) {
            this.readDigitalValue(node, reader);
        } else if (EqualsUtil.equals((Object)nodeName, (Object)EXPRESSION_NODE)) {
            this.readExpression(node, reader);
        } else if (EqualsUtil.equals((Object)nodeName, (Object)WAIT_TIME_NODE)) {
            this.readWaitTime(node, reader);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Class<? extends WaitNode>> getClassAliases(boolean forMarshalling) {
        return Collections.singletonMap("WaitNode", WaitNode.class);
    }

    private void writeAnalogPinReference(WaitNode node, PersistWriter writer) {
        this.writePinReference(node.getAnalogPinReference(), writer);
    }

    private void writeDigitalPinReference(WaitNode node, PersistWriter writer) {
        this.writePinReference(node.getDigitalPinReference(), writer);
    }

    private void writePinReference(PinReference reference, PersistWriter writer) {
        writer.writeNodeWithValue(PIN_NODE, (Object)reference);
    }

    private PinReference readPinReference(PersistReader reader) {
        return (PinReference)reader.convertContainedValue(PinReference.class);
    }

    private void writeAnalogValue(WaitNode node, PersistWriter writer) {
        writer.writeNodeWithValue(ANALOG_VALUE_NODE, (Object)node.getAnalogValue());
    }

    private void readAnalogValue(WaitNode node, PersistReader reader) {
        node.setAnalogValue(reader.getDoubleValue());
    }

    private void writeAnalogComparison(WaitNode node, PersistWriter writer) {
        writer.writeNodeWithValue(ANALOG_COMPARISON_NODE, (Object)node.getAnalogComparison());
    }

    private void readAnalogComparison(WaitNode node, PersistReader reader) {
        node.setAnalogComparison(reader.getIntegerValue());
    }

    private void writeDigitalValue(WaitNode node, PersistWriter writer) {
        writer.writeNodeWithValue(DIGITAL_VALUE_NODE, (Object)node.getDigitalValue());
    }

    private void readDigitalValue(WaitNode node, PersistReader reader) {
        node.setDigitalValue(reader.getIntegerValue());
    }

    private void writeExpression(WaitNode node, PersistWriter writer) {
        writer.writeNodeWithValue(EXPRESSION_NODE, (Object)node.getExpression());
    }

    private void readExpression(WaitNode node, PersistReader reader) {
        node.setExpression((ExpressionBranchNode)reader.convertContainedValue(ExpressionBranchNode.class));
    }

    private void writeWaitTime(WaitNode node, PersistWriter writer) {
        writer.writeNodeWithValue(WAIT_TIME_NODE, (Object)node.getWaitTime());
    }

    private void readWaitTime(WaitNode node, PersistReader reader) {
        node.setWaitTime(reader.getDoubleValue());
    }
}

