/*
 * Decompiled with CFR 0.152.
 */
package gui.program.persistence_pre_v3_2;

import com.ur.lang.BijectiveEnumMap;
import com.ur.lang.EqualsUtil;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.Position;
import com.ur.polyscope.persistence.ConversionStrategyTemplate;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.valueobjects.Time;
import com.ur.view.variables.core.Variable;
import gui.program.EntityFactory;
import gui.program.persistence_pre_v3_2.LegacyProgramNodeBuilder;
import gui.program.position.WaypointNode;
import gui.program.services.ProgramReferenceService;
import java.util.Collections;
import java.util.Map;
import javax.vecmath.Point3d;

public abstract class WaypointNodeConversionStrategy_v3_1
extends ConversionStrategyTemplate<WaypointNode> {
    private static final BijectiveEnumMap<PositionNodeType, String> TYPE_NAMES = new BijectiveEnumMap(PositionNodeType.class).put((Enum)PositionNodeType.UNDEFINED, (Object)"UNDEFINED").put((Enum)PositionNodeType.FIXED, (Object)"FIXED_POSITION").put((Enum)PositionNodeType.RELATIVE, (Object)"RELATIVE_POSITION").put((Enum)PositionNodeType.VARIABLE, (Object)"VARIABLE_POSITION").seal();
    private final EntityFactory entityFactory;
    private final ProgramReferenceService programReferenceService;

    public WaypointNodeConversionStrategy_v3_1(EntityFactory entityFactory, ProgramReferenceService programReferenceService) {
        super(WaypointNode.class);
        this.entityFactory = entityFactory;
        this.programReferenceService = programReferenceService;
    }

    public void marshal(WaypointNode node, PersistWriter writer) {
    }

    public WaypointNode unmarshal(PersistReader reader) {
        return (WaypointNode)new WaypointNodeBuilder(reader).buildNode();
    }

    public Map<String, Class<? extends WaypointNode>> getClassAliases(boolean forMarshalling) {
        if (forMarshalling) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("gui.program.WaypointNode", WaypointNode.class);
    }

    abstract void handleWaypointPoseInFeatureCoordinates(WaypointNode var1, Pose6d var2);

    abstract Position createPosition(JointPositionVector var1, Point3d var2, Point3d var3);

    protected class WaypointNodeBuilder
    extends LegacyProgramNodeBuilder<WaypointNode> {
        protected PositionNodeType positionType;
        private int kinematicFlags;
        private boolean useSharedParameters;
        private boolean specifyNextMotionTime;
        private double nextMotionTime;
        private double jointSpeed;
        private double cartesianSpeed;
        private double jointAcceleration;
        private double cartesianAcceleration;
        private boolean useSharedBlendParameter;
        private boolean stopPoint;
        private double blendRadius;
        private transient JointPositionVector jpv;
        private transient Point3d toolPosition;
        private transient Point3d toolAxisAngle;
        private Position position;
        private Pose6d waypointPoseInFeatureCoordinates;
        protected Pose6d outputFlangePose;
        private String variableName;
        private Variable variable;
        private String name;
        private JointPositionVector relativeFromJointPositionVector;
        private Point3d relativeFromToolPosition;
        private Point3d relativeFromToolAxisAngle;

        public WaypointNodeBuilder(PersistReader reader) {
            super(WaypointNode.class, reader);
            this.positionType = null;
            this.kinematicFlags = -1;
            this.useSharedParameters = true;
            this.specifyNextMotionTime = false;
            this.nextMotionTime = 2.0;
            this.jointSpeed = Double.NaN;
            this.cartesianSpeed = Double.NaN;
            this.jointAcceleration = Double.NaN;
            this.cartesianAcceleration = Double.NaN;
            this.useSharedBlendParameter = true;
            this.stopPoint = true;
            this.blendRadius = Double.NaN;
            this.jpv = null;
            this.toolPosition = null;
            this.toolAxisAngle = null;
            this.position = null;
            this.waypointPoseInFeatureCoordinates = null;
            this.outputFlangePose = null;
            this.variableName = null;
            this.variable = null;
            this.name = null;
            this.relativeFromJointPositionVector = null;
            this.relativeFromToolPosition = null;
            this.relativeFromToolAxisAngle = null;
        }

        @Override
        protected WaypointNode createNode() {
            return WaypointNodeConversionStrategy_v3_1.this.entityFactory.createWaypointNode();
        }

        @Override
        public boolean tryReadFromChildNode(WaypointNode node, PersistReader reader) {
            String nodeName = reader.getNodeName();
            if (!EqualsUtil.equalsOneOf((Object)nodeName, (Object[])new String[]{"gui.program.PositionNode", "gui.program.WaypointNode"})) {
                return false;
            }
            if (EqualsUtil.equals((Object)nodeName, (Object)"gui.program.PositionNode")) {
                if (this.moveToDefaultNode(reader)) {
                    while (reader.hasMoreNodes()) {
                        reader.moveToChildNode();
                        nodeName = reader.getNodeName();
                        if (EqualsUtil.equals((Object)"positionType", (Object)nodeName)) {
                            this.positionType = (PositionNodeType)TYPE_NAMES.getKey((Object)reader.getStringValue());
                        } else if (EqualsUtil.equals((Object)"useSharedParameters", (Object)nodeName)) {
                            this.useSharedParameters = reader.getBooleanValue();
                        } else if (EqualsUtil.equals((Object)"specifyNextMotionTime", (Object)nodeName)) {
                            this.specifyNextMotionTime = reader.getBooleanValue();
                        } else if (EqualsUtil.equals((Object)"nextMotionTime", (Object)nodeName)) {
                            this.nextMotionTime = reader.getDoubleValue();
                        } else if (EqualsUtil.equals((Object)"jointSpeed", (Object)nodeName)) {
                            this.jointSpeed = reader.getDoubleValue();
                        } else if (EqualsUtil.equals((Object)"cartesianSpeed", (Object)nodeName)) {
                            this.cartesianSpeed = reader.getDoubleValue();
                        } else if (EqualsUtil.equals((Object)"jointAcceleration", (Object)nodeName)) {
                            this.jointAcceleration = reader.getDoubleValue();
                        } else if (EqualsUtil.equals((Object)"cartesianAcceleration", (Object)nodeName)) {
                            this.cartesianAcceleration = reader.getDoubleValue();
                        } else if (EqualsUtil.equals((Object)"useSharedBlendParameter", (Object)nodeName)) {
                            this.useSharedBlendParameter = reader.getBooleanValue();
                        } else if (EqualsUtil.equals((Object)"stoppoint", (Object)nodeName)) {
                            this.stopPoint = reader.getBooleanValue();
                        } else if (EqualsUtil.equals((Object)"blendRadius", (Object)nodeName)) {
                            this.blendRadius = reader.getDoubleValue();
                        } else if (EqualsUtil.equals((Object)"jpv", (Object)nodeName)) {
                            this.jpv = (JointPositionVector)reader.convertContainedValue(JointPositionVector.class);
                        } else if (EqualsUtil.equals((Object)"toolPosition", (Object)nodeName)) {
                            this.toolPosition = (Point3d)reader.convertContainedValue(Point3d.class);
                        } else if (EqualsUtil.equals((Object)"toolAxisAngle", (Object)nodeName)) {
                            this.toolAxisAngle = (Point3d)reader.convertContainedValue(Point3d.class);
                        } else if (EqualsUtil.equals((Object)"position", (Object)nodeName)) {
                            this.position = (Position)reader.convertContainedValue(Position.class);
                        } else if (EqualsUtil.equals((Object)"waypointPoseInFeatureCoordinates", (Object)nodeName)) {
                            this.waypointPoseInFeatureCoordinates = (Pose6d)reader.convertContainedValue(Pose6d.class);
                        } else if (EqualsUtil.equals((Object)"outputFlangePose", (Object)nodeName)) {
                            this.outputFlangePose = (Pose6d)reader.convertContainedValue(Pose6d.class);
                        } else if (EqualsUtil.equals((Object)"variableName", (Object)nodeName)) {
                            this.variableName = reader.getStringValue();
                        } else if (EqualsUtil.equals((Object)"variable", (Object)nodeName)) {
                            this.variable = (Variable)reader.convertContainedValue(Variable.class);
                        } else if (EqualsUtil.equals((Object)"kinematicFlags", (Object)nodeName)) {
                            this.kinematicFlags = reader.getIntegerValue();
                        }
                        reader.moveToParentNode();
                    }
                    this.moveOutOfDefaultNode(reader);
                }
            } else if (EqualsUtil.equals((Object)nodeName, (Object)"gui.program.WaypointNode") && this.moveToDefaultNode(reader)) {
                while (reader.hasMoreNodes()) {
                    reader.moveToChildNode();
                    nodeName = reader.getNodeName();
                    if (EqualsUtil.equals((Object)"name", (Object)nodeName)) {
                        this.name = reader.getStringValue();
                    } else if (EqualsUtil.equals((Object)"relativeFromJointPositionVector", (Object)nodeName)) {
                        this.relativeFromJointPositionVector = (JointPositionVector)reader.convertContainedValue(JointPositionVector.class);
                    } else if (EqualsUtil.equals((Object)"relativeFromToolPosition", (Object)nodeName)) {
                        this.relativeFromToolPosition = (Point3d)reader.convertContainedValue(Point3d.class);
                    } else if (EqualsUtil.equals((Object)"relativeFromToolAxisAngle", (Object)nodeName)) {
                        this.relativeFromToolAxisAngle = (Point3d)reader.convertContainedValue(Point3d.class);
                    }
                    reader.moveToParentNode();
                }
                this.moveOutOfDefaultNode(reader);
            }
            return true;
        }

        @Override
        protected void finalizeNode(WaypointNode node) {
            if (this.positionType != null) {
                node.setPositionNodeType(this.positionType);
            }
            if (this.kinematicFlags != -1) {
                node.setKinematicFlags(this.kinematicFlags);
            }
            if (this.name != null) {
                node.setName(this.name);
            }
            node.setUsingOptiMove(false);
            if (this.useSharedParameters) {
                node.setUsingSharedParameters();
            } else {
                if (this.specifyNextMotionTime) {
                    node.setUsingNextMotionTime();
                } else {
                    node.setUsingIndividualParameters();
                }
                if (this.specifyNextMotionTime && this.nextMotionTime != Double.NaN) {
                    node.setNextMotionTime(Time.from((double)this.nextMotionTime, (Time.Unit)Time.Unit.SI));
                } else {
                    if (this.jointSpeed != Double.NaN) {
                        node.setJointSpeed(this.jointSpeed);
                    }
                    if (this.jointAcceleration != Double.NaN) {
                        node.setJointAcceleration(this.jointAcceleration);
                    }
                    if (this.cartesianSpeed != Double.NaN) {
                        node.setCartesianSpeed(this.cartesianSpeed);
                    }
                    if (this.cartesianAcceleration != Double.NaN) {
                        node.setCartesianAcceleration(this.cartesianAcceleration);
                    }
                }
            }
            node.setUseSharedBlendParameter(this.useSharedBlendParameter);
            node.setStopPoint(this.stopPoint);
            if (!(this.useSharedBlendParameter && this.stopPoint || this.blendRadius == Double.NaN)) {
                node.setBlendRadius(this.blendRadius);
            }
            if (this.position != null && this.jpv != null) {
                this.position = WaypointNodeConversionStrategy_v3_1.this.createPosition(this.jpv, this.toolPosition, this.toolAxisAngle);
                this.jpv = null;
                this.toolAxisAngle = null;
                this.toolPosition = null;
            }
            switch (this.positionType) {
                case UNDEFINED: {
                    break;
                }
                case RELATIVE: {
                    if (this.relativeFromJointPositionVector != null) {
                        node.setRelativeFromPosition(WaypointNodeConversionStrategy_v3_1.this.createPosition(this.relativeFromJointPositionVector, this.relativeFromToolPosition, this.relativeFromToolAxisAngle));
                    }
                }
                case FIXED: {
                    if (this.position != null) {
                        node.setPositionReference(this.position);
                    }
                    if (this.waypointPoseInFeatureCoordinates == null) break;
                    WaypointNodeConversionStrategy_v3_1.this.handleWaypointPoseInFeatureCoordinates(node, this.waypointPoseInFeatureCoordinates);
                    break;
                }
                case VARIABLE: {
                    if (this.variable != null) {
                        node.setInternalVariable(this.variable);
                    }
                    if (this.variableName == null) break;
                    node.setInternalVariable(WaypointNodeConversionStrategy_v3_1.this.programReferenceService.getInstallationVariableReference(this.variableName));
                }
            }
        }
    }
}

