/*
 * Decompiled with CFR 0.152.
 */
package gui.program.position;

import com.ur.polyscope.robot.configuration.optimove.OptiMoveConfigurationSettings;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Percentage;
import com.ur.polyscope.valueobjects.Speed;
import gui.program.position.MotionConfigurationFactory;
import gui.program.position.MotionParameters;
import javax.inject.Provider;

public class IndividualMotionParameters
implements MotionParameters {
    private final MotionSpace cartesian;
    private final MotionSpace joint;
    private final OptiMoveConfigurationSettings optiMoveConfigurationSettings;
    private Provider<Boolean> isCartesianMotion;

    public IndividualMotionParameters(MotionSpace joint, MotionSpace cartesian, OptiMoveConfigurationSettings optiMoveConfigurationSettings) {
        this(joint, cartesian, optiMoveConfigurationSettings, (Provider<Boolean>)((Provider)() -> false));
    }

    private IndividualMotionParameters(MotionSpace joint, MotionSpace cartesian, OptiMoveConfigurationSettings optiMoveConfigurationSettings, Provider<Boolean> isCartesianMotion) {
        this.joint = joint;
        this.cartesian = cartesian;
        this.optiMoveConfigurationSettings = optiMoveConfigurationSettings;
        this.isCartesianMotion = isCartesianMotion;
    }

    IndividualMotionParameters(IndividualMotionParameters motion, Provider<Boolean> isCartesianMotion) {
        this(new MotionSpace(motion.joint.speed, motion.joint.acceleration), new MotionSpace(motion.cartesian.speed, motion.cartesian.acceleration), motion.optiMoveConfigurationSettings, isCartesianMotion);
    }

    void setIsCartesianMotion(Provider<Boolean> isCartesianMotion) {
        this.isCartesianMotion = isCartesianMotion;
    }

    @Override
    public boolean isSharedParameters() {
        return false;
    }

    @Override
    public boolean isNextMotionTime() {
        return false;
    }

    @Override
    public boolean isOptiMove() {
        return false;
    }

    @Override
    public Percentage getSpeedPercentage() {
        return Percentage.from((double)this.optiMoveConfigurationSettings.getSpeedPercentageDefault());
    }

    @Override
    public Percentage getAccelerationPercentage() {
        return Percentage.from((double)this.optiMoveConfigurationSettings.getAccelerationPercentageDefault());
    }

    @Override
    public Speed getSpeed() {
        return Speed.from((double)((Boolean)this.isCartesianMotion.get() != false ? this.getCartesianSpeed() : this.getJointSpeed()), (Speed.Unit)Speed.Unit.SI);
    }

    public void setSpeed(Speed speed) {
        if (((Boolean)this.isCartesianMotion.get()).booleanValue()) {
            this.setCartesianSpeed(speed.getIn(Speed.Unit.SI));
        } else {
            this.setJointSpeed(speed.getIn(Speed.Unit.SI));
        }
    }

    @Override
    public double getJointSpeed() {
        return this.joint.speed;
    }

    public void setJointSpeed(double jointSpeed) {
        this.joint.speed = jointSpeed;
    }

    @Override
    public double getCartesianSpeed() {
        return this.cartesian.speed;
    }

    public void setCartesianSpeed(double cartesianSpeed) {
        this.cartesian.speed = cartesianSpeed;
    }

    @Override
    public Acceleration getAcceleration() {
        return Acceleration.from((double)((Boolean)this.isCartesianMotion.get() != false ? this.getCartesianAcceleration() : this.getJointAcceleration()), (Acceleration.Unit)Acceleration.Unit.SI);
    }

    @Override
    public double getJointAcceleration() {
        return this.joint.acceleration;
    }

    public void setJointAcceleration(double jointAcceleration) {
        this.joint.acceleration = jointAcceleration;
    }

    @Override
    public double getCartesianAcceleration() {
        return this.cartesian.acceleration;
    }

    public void setCartesianAcceleration(double cartesianAcceleration) {
        this.cartesian.acceleration = cartesianAcceleration;
    }

    public void setAcceleration(Acceleration acceleration) {
        if (((Boolean)this.isCartesianMotion.get()).booleanValue()) {
            this.setCartesianAcceleration(acceleration.getIn(Acceleration.Unit.SI));
        } else {
            this.setJointAcceleration(acceleration.getIn(Acceleration.Unit.SI));
        }
    }

    @Override
    public String generateParameters() {
        return ", a=" + this.getAcceleration().getIn(Acceleration.Unit.SI) + ", v=" + this.getSpeed().getIn(Speed.Unit.SI);
    }

    @Override
    public MotionConfigurationFactory.MotionConfiguration getMotionConfiguration() {
        if (((Boolean)this.isCartesianMotion.get()).booleanValue()) {
            return new MotionConfigurationFactory.ToolConfiguration();
        }
        return new MotionConfigurationFactory.JointConfiguration();
    }

    public static class MotionSpace {
        public double speed;
        public double acceleration;

        public MotionSpace(double speed, double acceleration) {
            this.speed = speed;
            this.acceleration = acceleration;
        }
    }
}

