/*
 * Decompiled with CFR 0.152.
 */
package gui.program.position;

import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Percentage;
import com.ur.polyscope.valueobjects.Speed;
import gui.program.position.MotionConfigurationFactory;
import gui.program.position.MotionParameters;

class IndividualOptiMoveMotionParameters
implements MotionParameters {
    private final MotionParameters fallbackMotionParameters;
    private Percentage speedPercentage;
    private Percentage accelerationPercentage;

    IndividualOptiMoveMotionParameters(MotionParameters fallbackMotionParameters) {
        this.speedPercentage = fallbackMotionParameters.getSpeedPercentage();
        this.accelerationPercentage = fallbackMotionParameters.getAccelerationPercentage();
        this.fallbackMotionParameters = fallbackMotionParameters;
    }

    IndividualOptiMoveMotionParameters(IndividualOptiMoveMotionParameters toClone, MotionParameters fallbackMotionParameters) {
        this.speedPercentage = toClone.speedPercentage;
        this.accelerationPercentage = toClone.accelerationPercentage;
        this.fallbackMotionParameters = fallbackMotionParameters;
    }

    @Override
    public boolean isSharedParameters() {
        return false;
    }

    @Override
    public boolean isNextMotionTime() {
        return false;
    }

    @Override
    public boolean isOptiMove() {
        return true;
    }

    public void setSpeedPercentage(Percentage speed) {
        this.speedPercentage = speed;
    }

    public void setAccelerationPercentage(Percentage acceleration) {
        this.accelerationPercentage = acceleration;
    }

    @Override
    public Percentage getSpeedPercentage() {
        return this.speedPercentage;
    }

    @Override
    public Percentage getAccelerationPercentage() {
        return this.accelerationPercentage;
    }

    @Override
    public Speed getSpeed() {
        return this.fallbackMotionParameters.getSpeed();
    }

    @Override
    public double getJointSpeed() {
        return this.fallbackMotionParameters.getJointSpeed();
    }

    @Override
    public double getCartesianSpeed() {
        return this.fallbackMotionParameters.getCartesianSpeed();
    }

    @Override
    public Acceleration getAcceleration() {
        return this.fallbackMotionParameters.getAcceleration();
    }

    @Override
    public double getJointAcceleration() {
        return this.fallbackMotionParameters.getJointAcceleration();
    }

    @Override
    public double getCartesianAcceleration() {
        return this.fallbackMotionParameters.getCartesianAcceleration();
    }

    @Override
    public String generateParameters() {
        return ", a=" + this.accelerationPercentage.getValue() + ", v=" + this.speedPercentage.getValue();
    }

    @Override
    public MotionConfigurationFactory.MotionConfiguration getMotionConfiguration() {
        return new MotionConfigurationFactory.OptiMoveConfiguration();
    }
}

