/*
 * Decompiled with CFR 0.152.
 */
package gui.program.position;

import com.ur.lang.EqualsUtil;
import com.ur.monitor.RobotState;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.Position;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.view.hmc.HMC;
import java.io.Serializable;
import javax.inject.Inject;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class LegacyPosition
extends Position
implements Serializable {
    private JointPositionVector jpv = new JointPositionVector();
    private Point3d toolPosition = new Point3d();
    private Point3d toolAxisAngle = new Point3d();
    private Pose6d outputFlangePose = null;

    @Inject
    public LegacyPosition() {
    }

    public LegacyPosition(JointPositionVector jointPositionVector, Point3d toolPosition, Point3d toolAxisAngle) {
        this.set(jointPositionVector, toolPosition, toolAxisAngle);
    }

    public LegacyPosition(JointPositionVector jointPositionVector, Pose6d tool) {
        this.set(jointPositionVector, new Point3d((Tuple3d)tool.getPos()), new Point3d((Tuple3d)tool.getRot()));
    }

    public void resetOutputFlangePose() {
        this.outputFlangePose = null;
    }

    public void setOutputFlangePose(Pose6d outputFlangePose) {
        this.outputFlangePose = outputFlangePose;
    }

    public Pose6d getOutputFlangePose() {
        if (this.outputFlangePose == null) {
            HMC hmc = new HMC();
            if (this.getJointPositionVector() != null && !this.getJointPositionVector().isUndefined()) {
                this.outputFlangePose = hmc.getTCPPose(this.getJointPositionVector());
            }
            if (this.outputFlangePose == null) {
                return null;
            }
            this.outputFlangePose = Pose6dTransformUtils.getPoseWithModifiedOffset((Pose6d)this.outputFlangePose, (Pose6d)RobotState.getLatestRobotState().tcpOffset, (Pose6d)new Pose6d());
        }
        return new Pose6d(this.outputFlangePose);
    }

    public boolean isUndefined() {
        if (this.jpv == null) {
            return true;
        }
        return this.jpv.isUndefined();
    }

    public void set(LegacyPosition position) {
        this.set(position.jpv, position.toolPosition, position.toolAxisAngle);
    }

    public void set(JointPositionVector jointPositionVector, Point3d toolPosition, Point3d toolAxisAngle) {
        this.jpv.set(jointPositionVector);
        this.toolPosition.x = toolPosition.x;
        this.toolPosition.y = toolPosition.y;
        this.toolPosition.z = toolPosition.z;
        this.toolAxisAngle.x = toolAxisAngle.x;
        this.toolAxisAngle.y = toolAxisAngle.y;
        this.toolAxisAngle.z = toolAxisAngle.z;
        this.notifyListeners();
    }

    public JointPositionVector getJointPositionVector() {
        if (this.jpv == null) {
            this.jpv = new JointPositionVector();
        }
        return this.jpv;
    }

    public Point3d getToolPosition() {
        return this.toolPosition;
    }

    public Point3d getToolAxisAngle() {
        return this.toolAxisAngle;
    }

    public LegacyPosition clone() {
        LegacyPosition newPos = new LegacyPosition();
        newPos.jpv = new JointPositionVector(this.jpv);
        newPos.toolPosition = new Point3d(this.toolPosition);
        newPos.toolAxisAngle = new Point3d(this.toolAxisAngle);
        return newPos;
    }

    public boolean equals(Object o) {
        if (o instanceof LegacyPosition) {
            LegacyPosition other = (LegacyPosition)o;
            boolean result = true;
            result &= EqualsUtil.equals((Object)this.jpv, (Object)other.jpv);
            result &= EqualsUtil.equals((Object)this.toolPosition, (Object)other.toolPosition);
            return result &= EqualsUtil.equals((Object)this.toolAxisAngle, (Object)other.toolAxisAngle);
        }
        return false;
    }

    public int hashCode() {
        int result = 23;
        result = 31 * result + (this.jpv == null ? 0 : this.jpv.hashCode());
        result = 31 * result + (this.toolPosition == null ? 0 : this.toolPosition.hashCode());
        result = 31 * result + (this.toolAxisAngle == null ? 0 : this.toolAxisAngle.hashCode());
        return result;
    }
}

