/*
 * Decompiled with CFR 0.152.
 */
package gui.program.position;

import com.ur.lang.EqualsUtil;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.Position;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import javax.inject.Inject;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class MeasuredPosition
extends Position {
    private JointPositionVector jpv = new JointPositionVector();
    private Transform3D tcpOffset = new Transform3D();
    private KinematicsCalibration calibration;
    private KinematicsCalibration originRobotCalibration;

    @Inject
    public MeasuredPosition(@Source(value=KinematicsCalibration.class) Recipe<KinematicsCalibration> calibrationRecipe) {
        this.calibration = (KinematicsCalibration)calibrationRecipe.lastProvider().get();
        this.originRobotCalibration = (KinematicsCalibration)calibrationRecipe.lastProvider().get();
    }

    public MeasuredPosition(JointPositionVector jointPositionVector, KinematicsCalibration calibration) {
        Transform3D newTcpOffset = new Transform3D();
        this.originRobotCalibration = calibration;
        this.set(jointPositionVector, newTcpOffset, calibration);
    }

    public MeasuredPosition(JointPositionVector jointPositionVector, Transform3D tcpOffset, KinematicsCalibration calibration) {
        this.originRobotCalibration = calibration;
        this.set(jointPositionVector, tcpOffset, calibration);
    }

    public void removeTcpOffset() {
        Transform3D transform3D = new Transform3D();
        if (!transform3D.equals(this.tcpOffset)) {
            this.tcpOffset = transform3D;
            this.notifyListeners();
        }
    }

    public Pose6d getOutputFlangePose() {
        if (this.calibration != null) {
            Transform3D baseToOutputFlange = this.calibration.getBaseToEnd(this.jpv);
            return Pose6dTransformUtils.getPose6dEquivalentOfTransform3D((Transform3D)baseToOutputFlange);
        }
        return new Pose6d(Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    public Pose6d getOuputFlangePoseUsingOriginCalibration() {
        if (this.originRobotCalibration != null) {
            Transform3D baseToOutputFlange = this.originRobotCalibration.getBaseToEnd(this.jpv);
            return Pose6dTransformUtils.getPose6dEquivalentOfTransform3D((Transform3D)baseToOutputFlange);
        }
        return new Pose6d(Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    public boolean isUndefined() {
        return this.jpv == null || this.jpv.isUndefined();
    }

    public void set(MeasuredPosition position) {
        this.set(position.jpv, position.tcpOffset, position.calibration);
    }

    private void set(JointPositionVector jpv, Transform3D tcpOffset, KinematicsCalibration calibration) {
        this.jpv = new JointPositionVector(jpv);
        this.tcpOffset = tcpOffset;
        this.calibration = calibration;
        this.notifyListeners();
    }

    public KinematicsCalibration getCalibration() {
        return this.calibration;
    }

    public void setCalibration(KinematicsCalibration calibration) {
        this.calibration = calibration;
    }

    public Pose6d getTCPOffset() {
        return Pose6dTransformUtils.getPose6dEquivalentOfTransform3D((Transform3D)this.tcpOffset);
    }

    public JointPositionVector getJointPositionVector() {
        if (this.jpv == null) {
            this.jpv = new JointPositionVector();
        }
        return this.jpv;
    }

    public Point3d getToolPosition() {
        if (this.calibration == null) {
            return new Point3d();
        }
        Transform3D baseToTool = this.calibration.getBaseToEnd(this.jpv);
        baseToTool.mul(this.tcpOffset);
        return new Point3d((Tuple3d)Pose6dTransformUtils.getPos((Transform3D)baseToTool));
    }

    public Point3d getToolAxisAngle() {
        if (this.calibration == null) {
            return new Point3d();
        }
        Transform3D baseToTool = this.calibration.getBaseToEnd(this.jpv);
        baseToTool.mul(this.tcpOffset);
        return new Point3d((Tuple3d)Pose6dTransformUtils.getRot((Transform3D)baseToTool));
    }

    public MeasuredPosition clone() {
        MeasuredPosition newPos = this.calibration == null ? new MeasuredPosition(this.jpv.clone(), new Transform3D(this.tcpOffset), null) : new MeasuredPosition(this.jpv.clone(), new Transform3D(this.tcpOffset), this.calibration.clone());
        return newPos;
    }

    public boolean equals(Object o) {
        if (o instanceof MeasuredPosition) {
            MeasuredPosition other = (MeasuredPosition)((Object)o);
            boolean result = EqualsUtil.equals((Object)this.jpv, (Object)other.jpv);
            result &= EqualsUtil.equals((Object)this.tcpOffset, (Object)other.tcpOffset);
            return result &= EqualsUtil.equals((Object)this.calibration, (Object)other.calibration);
        }
        return false;
    }

    public int hashCode() {
        int result = 23;
        result = 31 * result + (this.jpv == null ? 0 : this.jpv.hashCode());
        result = 31 * result + (this.tcpOffset == null ? 0 : this.tcpOffset.hashCode());
        result = 31 * result + (this.calibration == null ? 0 : this.calibration.hashCode());
        return result;
    }

    public String toString() {
        return "MeasuredPosition: {tcpOffset: " + this.tcpOffset + ", calibration: " + this.calibration + "}";
    }
}

