/*
 * Decompiled with CFR 0.152.
 */
package gui.program.position;

import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.util.logging.Log;
import gui.program.position.MeasuredPosition;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class MeasuredPositionFactory {
    public static MeasuredPosition createMeasuredPosition(JointPositionVector jointPositions, Point3d toolPosition, Point3d toolAxisAngle, KinematicsCalibration kinematicsCalibration) {
        Transform3D tcpOffset;
        if (jointPositions.isUndefined()) {
            tcpOffset = new Transform3D();
        } else {
            Transform3D baseToTcpPose = Pose6dTransformUtils.getTransform3D((Pose6d)new Pose6d((Tuple3d)toolPosition, (Tuple3d)toolAxisAngle));
            Transform3D baseToOutputFlange = kinematicsCalibration.getBaseToEnd(jointPositions);
            try {
                tcpOffset = new Transform3D(baseToOutputFlange);
                tcpOffset.invert();
                tcpOffset.mul(baseToTcpPose);
            }
            catch (Exception e) {
                Log.error((String)"Inversion of baseToOutputFlange transform failed in TCP computation", (Throwable)e);
                tcpOffset = new Transform3D();
            }
        }
        return new MeasuredPosition(jointPositions, tcpOffset, kinematicsCalibration);
    }
}

