/*
 * Decompiled with CFR 0.152.
 */
package gui.program.position;

import com.ur.lang.EqualsUtil;
import com.ur.lang.naming.NamingService;
import com.ur.lang.react.Recipe;
import com.ur.monitor.RobotState;
import com.ur.monitor.Source;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.Position;
import com.ur.move.PositionReference;
import com.ur.move.poseeditor.PoseRequest;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.program.nodes.move.PositionType;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.robot.configuration.optimove.OptiMoveConfigurationProvider;
import com.ur.polyscope.robot.configuration.optimove.OptiMoveConfigurationSettings;
import com.ur.polyscope.robot.configuration.tool.ToolConfigurationSettings;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.util.logging.Log;
import com.ur.view.variables.domain.VariableLookupService;
import gui.geom.ToolView;
import gui.program.MotionDefiningNode;
import gui.program.position.IndividualMotionParameters;
import gui.program.position.MeasuredPosition;
import gui.program.position.MeasuredPositionFactory;
import gui.program.position.MeasuredWaypointScriptGeneration;
import gui.program.position.WaypointNode;
import gui.tools.localization.TranslationLookup;
import javax.inject.Inject;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class MeasuredWaypointNode
extends WaypointNode {
    private static final ThreadLocal<MeasuredWaypointNode> featureTransformOwner = new ThreadLocal();
    private final Recipe<KinematicsCalibration> calibrationRecipe;
    private MeasuredPosition fromPosition;
    private Transform3D baseToFeatureTransform;

    @Inject
    public MeasuredWaypointNode(TranslationLookup lookup, JointConfigurationSettings jointSettings, VariableLookupService variableLookupService, @Source(value=KinematicsCalibration.class) Recipe<KinematicsCalibration> calibrationRecipe, ToolConfigurationSettings toolSettings, OptiMoveConfigurationProvider optiMoveConfigurationProvider, NamingService namingService) {
        this(lookup, variableLookupService, new IndividualMotionParameters(new IndividualMotionParameters.MotionSpace(jointSettings.getVJointDefault(), jointSettings.getAJointDefault()), new IndividualMotionParameters.MotionSpace(toolSettings.getVToolDefault(), toolSettings.getAToolDefault()), (OptiMoveConfigurationSettings)optiMoveConfigurationProvider.getOptiMoveConfigurationSettings().orElseThrow(IllegalStateException::new)), calibrationRecipe, namingService);
    }

    public MeasuredWaypointNode(TranslationLookup translationLookup, VariableLookupService variableLookupService, IndividualMotionParameters parameters, @Source(value=KinematicsCalibration.class) Recipe<KinematicsCalibration> calibrationRecipe, NamingService namingService) {
        super(translationLookup, parameters, variableLookupService, namingService);
        this.calibrationRecipe = calibrationRecipe;
    }

    public static void setFeatureTransformOwner(MeasuredWaypointNode waypoint) {
        featureTransformOwner.set(waypoint);
    }

    public Transform3D getBaseToFeatureTransform() {
        return this.baseToFeatureTransform;
    }

    public void setBaseToFeatureTransform(Transform3D baseToFeatureTransform) {
        this.baseToFeatureTransform = baseToFeatureTransform;
    }

    @Override
    protected MeasuredWaypointScriptGeneration getScriptGenerator() {
        return new MeasuredWaypointScriptGeneration(this);
    }

    @Override
    public Position getRelativeFromPosition() {
        return this.fromPosition;
    }

    @Override
    public void setRelativeFromPosition(Position position) {
        this.fromPosition = (MeasuredPosition)position;
    }

    @Override
    public void setToPosition(Position pos) {
        MeasuredPosition position = (MeasuredPosition)pos;
        MeasuredPosition currentPosition = (MeasuredPosition)this.getPositionReference();
        if (this.isPositionAndFeatureDifferent(currentPosition, position)) {
            currentPosition.set(position);
            this.textHasChanged();
        }
    }

    @Override
    public void clonePositionReferences() {
        this.setPositionReference(this.getPositionReference().clone());
        if (this.getRelativeFromPosition() != null) {
            this.setRelativeFromPosition(this.getRelativeFromPosition().clone());
        }
    }

    @Override
    public double getDistanceBetweenPoints() {
        JointPositionVector relativeFromJointPositionVector = this.getRelativeFromJointPositionVector();
        if (relativeFromJointPositionVector == null || relativeFromJointPositionVector.isUndefined() || this.isUndefined()) {
            return 0.0;
        }
        return this.getRelativeFromToolPosition().distance(this.getToolPosition());
    }

    @Override
    public double getAngleBetweenPoints() {
        if (this.toolAxisAngleIsUndefined()) {
            return 0.0;
        }
        Point3d p3d = new Point3d(this.getToolAxisAngle());
        p3d.sub((Tuple3d)this.getRelativeFromToolAxisAngle());
        return p3d.distance(new Point3d());
    }

    @Override
    public JointPositionVector getRelativeFromJointPositionVector() {
        if (this.fromPosition != null) {
            return this.fromPosition.getJointPositionVector();
        }
        return new JointPositionVector();
    }

    @Override
    public Point3d getRelativeFromToolPosition() {
        if (this.fromPosition == null) {
            return new Point3d();
        }
        return this.fromPosition.getToolPosition();
    }

    @Override
    public Point3d getRelativeFromToolAxisAngle() {
        if (this.fromPosition == null) {
            return new Point3d();
        }
        return this.fromPosition.getToolAxisAngle();
    }

    @Override
    public boolean isLinkedTo(PositionReference positionReference) {
        boolean result;
        boolean bl = result = this.getPositionReference() == positionReference.getPositionReference();
        if (positionReference instanceof MeasuredWaypointNode) {
            MeasuredWaypointNode other = (MeasuredWaypointNode)positionReference;
            result &= this.hasSameFromPosition(other.fromPosition);
            result &= this.hasSameBaseToFeatureTransform(other);
        }
        return result;
    }

    private boolean hasSameFromPosition(MeasuredPosition other) {
        if (this.fromPosition == null || other == null) {
            return this.fromPosition == null && other == null;
        }
        return this.fromPosition.equals((Object)other);
    }

    private boolean hasSameBaseToFeatureTransform(MeasuredWaypointNode other) {
        if (this.baseToFeatureTransform == null || other.baseToFeatureTransform == null) {
            return this.baseToFeatureTransform == null && other.baseToFeatureTransform == null;
        }
        return this.baseToFeatureTransform.equals(other.baseToFeatureTransform);
    }

    @Override
    public void setPositionReferences(PositionReference positionReference) {
        this.setPositionReference(positionReference.getPositionReference());
        if (positionReference instanceof MeasuredWaypointNode) {
            MeasuredWaypointNode other = (MeasuredWaypointNode)positionReference;
            this.fromPosition = other.fromPosition;
            this.baseToFeatureTransform = other.baseToFeatureTransform;
            this.setGettingFromPosition(other.isGettingFromPosition());
        }
    }

    @Override
    protected Position createPosition(JointPositionVector jointPositionVector, Point3d toolPosition, Point3d toolAxisAngle) {
        return MeasuredPositionFactory.createMeasuredPosition(jointPositionVector, toolPosition, toolAxisAngle, (KinematicsCalibration)this.calibrationRecipe.lastProvider().get());
    }

    @Override
    protected MeasuredPosition createPosition() {
        return new MeasuredPosition(this.calibrationRecipe);
    }

    @Override
    void positionUpdated(Position newPosition, Position oldPosition) {
        if (this.isPositionAndFeatureDifferent((MeasuredPosition)newPosition, (MeasuredPosition)oldPosition)) {
            this.positionHasChanged();
        }
    }

    private boolean isPositionAndFeatureDifferent(MeasuredPosition p1, MeasuredPosition p2) {
        MotionDefiningNode motionDefiningNode = this.getMotionDefiningNode();
        if (motionDefiningNode != null && !motionDefiningNode.featureTransformEquals(this.baseToFeatureTransform)) {
            return true;
        }
        return !EqualsUtil.equals((Object)((Object)p1), (Object)((Object)p2));
    }

    public void setPositionFrom(RobotState robotState) {
        MotionDefiningNode motionDefiningNode = this.getMotionDefiningNode();
        if (this.isMotionDefiningNodeIgnoringTcp(motionDefiningNode)) {
            this.setPosition(new MeasuredPosition(robotState.targetJointPosition, (KinematicsCalibration)this.calibrationRecipe.lastProvider().get()));
        } else {
            this.setPosition(new MeasuredPosition(robotState.targetJointPosition, Pose6dTransformUtils.getTransform3D((Pose6d)robotState.tcpOffset), (KinematicsCalibration)this.calibrationRecipe.lastProvider().get()));
        }
    }

    public void setPositionFrom(PoseRequest poseRequest) {
        try {
            MeasuredWaypointNode.setFeatureTransformOwner(this);
            this.internalSetPositionFrom(poseRequest);
        }
        finally {
            MeasuredWaypointNode.setFeatureTransformOwner(null);
        }
    }

    private void internalSetPositionFrom(PoseRequest poseRequest) {
        MotionDefiningNode motionDefiningNode = this.getMotionDefiningNode();
        if (this.isMotionDefiningNodeIgnoringTcp(motionDefiningNode)) {
            MeasuredPosition p = new MeasuredPosition(poseRequest.getTargetJointPosition(), (KinematicsCalibration)this.calibrationRecipe.lastProvider().get());
            this.setPositionReference(p);
        } else {
            Pose6d targetToolPose = poseRequest.getTargetToolPose();
            this.setPosition(poseRequest.getTargetJointPosition(), new Point3d(targetToolPose.getX(), targetToolPose.getY(), targetToolPose.getZ()), new Point3d(targetToolPose.getRX(), targetToolPose.getRY(), targetToolPose.getRZ()));
        }
    }

    @Override
    public JointPositionVector getActualJointPositionVector() {
        Position position = this.getPositionReference();
        if (position == null) {
            return new JointPositionVector();
        }
        return this.getActualJointPositionVector(position);
    }

    public JointPositionVector getActualFromJointPositionVector() {
        Position relativeFromPosition = this.getRelativeFromPosition();
        if (relativeFromPosition == null) {
            return new JointPositionVector();
        }
        return this.getActualJointPositionVector(relativeFromPosition);
    }

    private JointPositionVector getActualJointPositionVector(Position p) {
        if (this.useFixedJointAngles()) {
            return p.getJointPositionVector();
        }
        this.updateLastCalculatedJointPosition(p);
        return this.lastCalculatedJointPosition != null ? this.lastCalculatedJointPosition : new JointPositionVector();
    }

    @Override
    public Pose6d getActualToolPose() {
        if (!this.useFixedJointAngles()) {
            return this.applyRelativeFeatureTransformToToolPose(new Pose6d((Tuple3d)this.getToolPosition(), (Tuple3d)this.getToolAxisAngle()));
        }
        Pose6d flange = ((MeasuredPosition)this.getPositionReference()).getOuputFlangePoseUsingOriginCalibration();
        if (flange == null) {
            return null;
        }
        Pose6d tcpOffset = RobotState.getLatestRobotState().tcpOffset;
        return Pose6dTransformUtils.getTransformed((Pose6d)tcpOffset, (Transform3D)Pose6dTransformUtils.getTransform3D((Pose6d)flange));
    }

    private void updateLastCalculatedJointPosition(Position p) {
        MotionDefiningNode motionDefiningNode = this.getMotionDefiningNode();
        Pose6d targetToolPose = this.applyRelativeFeatureTransformToToolPose(new Pose6d((Tuple3d)p.getToolPosition(), (Tuple3d)p.getToolAxisAngle()));
        Pose6d controllerTCPOffset = RobotState.getLatestRobotState().tcpOffset;
        Pose6d targetTCPOffset = this.getTargetTcpOffset(motionDefiningNode, controllerTCPOffset);
        this.updateLastCalculatedJointPosition(targetToolPose, controllerTCPOffset, targetTCPOffset);
    }

    private Pose6d getTargetTcpOffset(MotionDefiningNode motionDefiningNode, Pose6d controllerTCPOffset) {
        if (this.isMotionDefiningNodeIgnoringTcp(motionDefiningNode)) {
            return new Pose6d();
        }
        if (this.isTcpConfigured(motionDefiningNode)) {
            return new Pose6d(motionDefiningNode.getTcpReference().dereference().getOffsetPose().asArray());
        }
        return controllerTCPOffset;
    }

    private boolean isMotionDefiningNodeIgnoringTcp(MotionDefiningNode motionDefiningNode) {
        return motionDefiningNode != null && motionDefiningNode.isIgnoreTCP();
    }

    private boolean isTcpConfigured(MotionDefiningNode motionDefiningNode) {
        return motionDefiningNode != null && motionDefiningNode.getTcpReference() != null && motionDefiningNode.getTcpReference().dereference() != null;
    }

    @Override
    public void recalculatePoseInFeatureSpace() {
        if (!this.containsType(MotionDefiningNode.class) || this.doesNotHaveDereferencedGeomFeature() || this.isUndefined()) {
            return;
        }
        MeasuredWaypointNode transformOwner = featureTransformOwner.get();
        if (transformOwner != null && transformOwner != this) {
            transformOwner.recalculatePoseInFeatureSpace();
            this.baseToFeatureTransform = transformOwner.getBaseToFeatureTransform();
            return;
        }
        this.baseToFeatureTransform = this.getMotionDefiningNode().getDereferencedGeomFeature().getTransform();
    }

    @Override
    public Pose6d getWaypointPoseInFeatureCoordinates() {
        Pose6d poseInBase = new Pose6d((Tuple3d)this.getToolPosition(), (Tuple3d)this.getToolAxisAngle());
        Transform3D tFeatureTool = this.getWaypointInFeatureCoordinates(poseInBase);
        return Pose6dTransformUtils.getPose6dEquivalentOfTransform3D((Transform3D)tFeatureTool);
    }

    private Transform3D getWaypointInFeatureCoordinates(Pose6d poseInBase) {
        Transform3D tBaseTool = Pose6dTransformUtils.getTransform3D((Pose6d)poseInBase);
        if (this.baseToFeatureTransform == null) {
            return tBaseTool;
        }
        Transform3D tFeatureTool = new Transform3D();
        Transform3D tFeatureBase = new Transform3D();
        tFeatureBase.invert(this.baseToFeatureTransform);
        tFeatureTool.mul(tFeatureBase, tBaseTool);
        return tFeatureTool;
    }

    @Override
    public boolean isInvalidWaypoint() {
        switch (this.getPositionNodeType()) {
            case VARIABLE: {
                return this.isVariableUndefined();
            }
            case RELATIVE: {
                return this.fromPosition == null || this.fromPosition.isUndefined() || this.getJointPositionVector().isUndefined();
            }
            case FIXED: {
                return this.getJointPositionVector() == null || this.getJointPositionVector().isUndefined();
            }
            case UNDEFINED: {
                return true;
            }
        }
        Log.error((String)("WaypointNode.isUndefined() Error: Could not handle type = " + this.getPositionNodeType()));
        return true;
    }

    public Point3d getActualToolPosition() {
        if (!this.useFixedJointAngles()) {
            Pose6d pose6d = this.applyRelativeFeatureTransformToToolPose(new Pose6d((Tuple3d)this.getToolPosition(), (Tuple3d)this.getToolAxisAngle()));
            return new Point3d((Tuple3d)pose6d.getPos());
        }
        Pose6d flange = ((MeasuredPosition)this.getPositionReference()).getOuputFlangePoseUsingOriginCalibration();
        if (flange == null) {
            return null;
        }
        Pose6d tcpOffset = RobotState.getLatestRobotState().tcpOffset;
        return new Point3d((Tuple3d)Pose6dTransformUtils.getTransformed((Pose6d)tcpOffset, (Transform3D)Pose6dTransformUtils.getTransform3D((Pose6d)flange)).getPos());
    }

    boolean hasFeatureVariableSelected() {
        MotionDefiningNode motionDefiningNode = this.getMotionDefiningNode();
        return motionDefiningNode != null && motionDefiningNode.selectedFeatureIsVariable();
    }

    boolean useFeatureForVariableWaypoint() {
        MotionDefiningNode motionDefiningNode = this.getMotionDefiningNode();
        return motionDefiningNode != null && (motionDefiningNode.selectedFeatureIsVariable() || motionDefiningNode.getFeatureVariable().getName().equals("Joint_6_name"));
    }

    boolean useFixedJointAngles() {
        return this.useFixedJointAngles(this.getMotionDefiningNode());
    }

    boolean useFixedJointAngles(MotionDefiningNode motionDefiningNode) {
        return motionDefiningNode != null && motionDefiningNode.getPositionType() == PositionType.JOINT_ANGLES;
    }

    private boolean doesNotHaveDereferencedGeomFeature() {
        MotionDefiningNode motionDefiningNode = this.getMotionDefiningNode();
        return motionDefiningNode == null || !motionDefiningNode.hasDereferencedGeomFeature();
    }

    private Pose6d applyRelativeFeatureTransformToToolPose(Pose6d baseToTool) {
        if (this.useBaseAsFeature()) {
            return baseToTool;
        }
        GeomFeature geomFeature = this.getMotionDefiningNode().getDereferencedGeomFeature();
        return this.transformPose(baseToTool, geomFeature);
    }

    protected boolean useBaseAsFeature() {
        return this.isUndefined() || !this.containsType(MotionDefiningNode.class) || this.doesNotHaveDereferencedGeomFeature() || this.toolFeatureUsedWithFixedWaypoint();
    }

    private boolean toolFeatureUsedWithFixedWaypoint() {
        if (this.containsType(MotionDefiningNode.class)) {
            MotionDefiningNode motionDefiningNode = this.getMotionDefiningNode();
            GeomFeature geomFeature = motionDefiningNode.getDereferencedGeomFeature();
            return this.toolFeatureUsedWithFixedWaypoint(motionDefiningNode, geomFeature);
        }
        return false;
    }

    boolean toolFeatureUsedWithFixedWaypoint(MotionDefiningNode motionDefiningNode, GeomFeature geomFeature) {
        boolean isWaypointFixed;
        boolean isMoveJ = motionDefiningNode.isJointMove();
        boolean isToolFeature = geomFeature instanceof ToolView;
        boolean isUseJointAngles = this.useFixedJointAngles(motionDefiningNode);
        boolean bl = isWaypointFixed = this.getPositionNodeType() == PositionNodeType.FIXED;
        return isMoveJ && isToolFeature && !isUseJointAngles && isWaypointFixed;
    }

    protected Pose6d transformPose(Pose6d baseToTool, GeomFeature geomFeature) {
        Transform3D tBaseNewFeature = geomFeature.getTransform();
        Transform3D tFeatureTool = this.getWaypointInFeatureCoordinates(baseToTool);
        Transform3D tFeatureTransformedBaseToTool = new Transform3D();
        tFeatureTransformedBaseToTool.mul(tBaseNewFeature, tFeatureTool);
        return Pose6dTransformUtils.getPose6dEquivalentOfTransform3D((Transform3D)tFeatureTransformedBaseToTool);
    }

    private boolean toolAxisAngleIsUndefined() {
        Point3d toolAxisAngle = this.getToolAxisAngle();
        return toolAxisAngle == null || Double.isNaN(toolAxisAngle.x) || Double.isNaN(toolAxisAngle.y) || Double.isNaN(toolAxisAngle.z);
    }

    @Override
    public ScriptWriter generatePreambleScript(ScriptWriter writer) {
        return this.getScriptGenerator().generatePreambleScript(writer);
    }
}

