/*
 * Decompiled with CFR 0.152.
 */
package gui.program.position;

import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.internaltcp.domain.TCPReference;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.scriptconverter.ScriptConverter;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.util.logging.Log;
import com.ur.view.variables.core.Variable;
import gui.program.MotionDefiningNode;
import gui.program.position.MeasuredWaypointNode;
import gui.program.position.WaypointScriptGeneration;
import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class MeasuredWaypointScriptGeneration
extends WaypointScriptGeneration {
    private static final Pose6d ZERO_POSE_6D = new Pose6d();
    public static final String POSE_VARIABLE_POSTFIX = "_p";
    public static final String JOINTPOSITION_VARIABLE_POSTFIX = "_q";
    public static final String POSE_VARIABLE_RELATIVE_FROM_POSTFIX = "_from_p";
    public static final String POSE_VARIABLE_RELATIVE_TO_POSTFIX = "_to_p";
    private static final Map<String, String> POSE_VARIABLE_NAME_CACHE = new HashMap<String, String>();
    private static final Map<String, String> Q_NEAR_VARIABLE_NAME_CACHE = new HashMap<String, String>();
    private static final Map<String, String> POSE_VARIABLE_RELATIVE_FROM_NAME_CACHE = new HashMap<String, String>();
    private static final Map<String, String> POSE_VARIABLE_RELATIVE_TO_NAME_CACHE = new HashMap<String, String>();
    public static final String UNDEFINED_POSE = "--WaypointNode_undefined_pose--";
    private MeasuredWaypointNode waypointNode;

    MeasuredWaypointScriptGeneration(MeasuredWaypointNode waypointNode) {
        super(waypointNode);
        this.waypointNode = waypointNode;
    }

    @Override
    protected void setTCP(ScriptWriter writer, MotionDefiningNode motionDefiningNode) {
        TCPReference tcpReference = null;
        boolean useJointAngles = false;
        if (motionDefiningNode != null) {
            tcpReference = motionDefiningNode.getTcpReference();
            useJointAngles = this.waypointNode.useFixedJointAngles();
        }
        if (tcpReference != null && tcpReference.dereference() != null && !useJointAngles) {
            writer.set_tcp(new Pose6d(tcpReference.dereference().getOffsetPose().asArray()));
        }
    }

    @Override
    protected String generateJointMoveScript(boolean useBlend) {
        if (this.waypointNode.useFixedJointAngles()) {
            return this.generateJointAngleScriptCode();
        }
        String position = this.generatePoseScriptCode();
        if (this.waypointNode.getPositionNodeType() == PositionNodeType.FIXED) {
            position = "get_inverse_kin(" + position + ", qnear=" + this.getQnearVariableName() + ")";
        }
        return position;
    }

    @Override
    protected String generateLinearCartesianPositionScript() {
        return this.generatePoseScriptCode();
    }

    private String getFeatureScript() {
        Variable variable;
        MotionDefiningNode motionDefiningNode = this.waypointNode.getMotionDefiningNode();
        String featureStr = ZERO_POSE_6D.toString();
        if (motionDefiningNode != null && (variable = motionDefiningNode.getFeatureVariable()) != null) {
            featureStr = MeasuredWaypointScriptGeneration.generateFeatureCode(variable, motionDefiningNode);
        }
        return featureStr;
    }

    private static String generateFeatureCode(Variable variable, MotionDefiningNode motionDefiningNode) {
        String featureName = variable.getName();
        if ("Joint_0_name".equals(featureName)) {
            return ZERO_POSE_6D.toString();
        }
        if ("Joint_6_name".equals(featureName)) {
            if (motionDefiningNode.isIgnoreTCP()) {
                return "get_forward_kin(tcp=" + ZERO_POSE_6D + ")";
            }
            return "get_forward_kin()";
        }
        return variable.getScriptName();
    }

    private boolean ignoreTcp() {
        MotionDefiningNode motionDefiningNode = this.waypointNode.getMotionDefiningNode();
        return this.waypointNode.getPositionNodeType() != PositionNodeType.RELATIVE && motionDefiningNode != null && motionDefiningNode.isIgnoreTCP();
    }

    private void generateRelativeWaypointScriptCode(StringBuilder s) {
        Point3d posFrom = this.waypointNode.getRelativeFromToolPosition();
        Point3d rotFrom = this.waypointNode.getRelativeFromToolAxisAngle();
        Point3d posTo = this.waypointNode.getToolPosition();
        Point3d rotTo = this.waypointNode.getToolAxisAngle();
        if (posFrom != null && rotFrom != null && posTo != null && rotTo != null) {
            s.append("pose_add(get_target_tcp_pose(), ");
            s.append("pose_sub(");
            s.append(this.getPoseVariableRelativeToName());
            s.append(", ");
            s.append(this.getPoseVariableRelativeFromName());
            s.append("))");
        } else {
            Log.error((String)"Relative position parameter is null!");
            s.append(UNDEFINED_POSE);
        }
    }

    private String generateJointAngleScriptCode() {
        StringBuilder s = new StringBuilder();
        switch (this.waypointNode.getPositionNodeType()) {
            case RELATIVE: {
                this.generateRelativeWaypointScriptCode(s);
                break;
            }
            case VARIABLE: {
                if (this.waypointNode.getInternalVariable() != null) {
                    String variableName = this.waypointNode.getInternalVariable().getScriptName();
                    s.append(variableName);
                    break;
                }
                Log.error((String)"Tried to generate position script for variable waypoint but variable is null");
                s.append("-- Error: null variable --");
                break;
            }
            case FIXED: {
                s.append(this.getQnearVariableName());
                break;
            }
            case UNDEFINED: {
                Log.error((String)"Could not generate script code for undefined waypoint type!");
                s.append(UNDEFINED_POSE);
                break;
            }
            default: {
                Log.error((String)"Unsupported waypoint type!");
                s.append(UNDEFINED_POSE);
            }
        }
        return s.toString();
    }

    @Override
    public String generatePoseScriptCode() {
        StringBuilder s = new StringBuilder();
        if (this.ignoreTcp()) {
            s.append("pose_trans(");
            this.generatePoseScriptByWaypointType(s);
            s.append(", get_tcp_offset())");
        } else {
            this.generatePoseScriptByWaypointType(s);
        }
        return s.toString();
    }

    private void generatePoseScriptByWaypointType(StringBuilder s) {
        switch (this.waypointNode.getPositionNodeType()) {
            case RELATIVE: {
                this.generateRelativeWaypointScriptCode(s);
                break;
            }
            case VARIABLE: {
                if (this.waypointNode.getInternalVariable() != null) {
                    String variableName = this.waypointNode.getInternalVariable().getScriptName();
                    if (this.waypointNode.useFeatureForVariableWaypoint()) {
                        String featureScript = this.getFeatureScript();
                        this.appendPoseTransformation(s, featureScript, variableName);
                        break;
                    }
                    s.append(variableName);
                    break;
                }
                Log.error((String)"Tried to generate position script for variable waypoint but variable is null");
                s.append("-- Error: null variable --");
                break;
            }
            case FIXED: {
                if (this.waypointNode.hasFeatureVariableSelected() || this.hasBaseFeatureWithTransform()) {
                    String featurePose = this.getFeatureScript();
                    Transform3D featureToBaseTransform = new Transform3D();
                    Transform3D b2f = this.waypointNode.getBaseToFeatureTransform() == null ? new Transform3D() : this.waypointNode.getBaseToFeatureTransform();
                    featureToBaseTransform.invert(b2f);
                    Pose6d pose6d = Pose6dTransformUtils.getPose6dEquivalentOfTransform3D((Transform3D)featureToBaseTransform);
                    String featureInverse = this.generatePose((Tuple3d)pose6d.getPos(), (Tuple3d)pose6d.getRot());
                    String featureToTCP = "pose_trans(" + featureInverse + ", " + this.getPoseVariableName() + ")";
                    this.appendPoseTransformation(s, featurePose, featureToTCP);
                    break;
                }
                s.append(this.getPoseVariableName());
                break;
            }
            case UNDEFINED: {
                Log.error((String)"Could not generate script code for undefined waypoint type!");
                s.append(UNDEFINED_POSE);
                break;
            }
            default: {
                Log.error((String)"Unsupported waypoint type!");
                s.append(UNDEFINED_POSE);
            }
        }
    }

    private boolean hasBaseFeatureWithTransform() {
        String featureName;
        Variable variable;
        MotionDefiningNode motionDefiningNode = this.waypointNode.getMotionDefiningNode();
        if (motionDefiningNode != null && (variable = motionDefiningNode.getFeatureVariable()) != null && !(featureName = variable.getName()).equals("Joint_0_name")) {
            return false;
        }
        return this.waypointNode.getBaseToFeatureTransform() != null && !this.waypointNode.getBaseToFeatureTransform().equals(new Transform3D());
    }

    public ScriptWriter generatePreambleScript(ScriptWriter writer) {
        if (this.waypointNode.getPositionNodeType() == PositionNodeType.FIXED) {
            writer.globalVariable(this.getPoseVariableName(), this.generatePose((Tuple3d)this.waypointNode.getToolPosition(), (Tuple3d)this.waypointNode.getToolAxisAngle()));
            writer.globalVariable(this.getQnearVariableName(), this.waypointNode.getJointPositionVector().toString());
        } else if (this.waypointNode.getPositionNodeType() == PositionNodeType.RELATIVE) {
            writer.globalVariable(this.getPoseVariableRelativeFromName(), this.generatePose((Tuple3d)this.waypointNode.getRelativeFromToolPosition(), (Tuple3d)this.waypointNode.getRelativeFromToolAxisAngle()));
            writer.globalVariable(this.getPoseVariableRelativeToName(), this.generatePose((Tuple3d)this.waypointNode.getToolPosition(), (Tuple3d)this.waypointNode.getToolAxisAngle()));
        }
        return writer;
    }

    private String getPoseVariableName() {
        return MeasuredWaypointScriptGeneration.getPoseVariableName(this.waypointNode.getName());
    }

    private String getQnearVariableName() {
        return MeasuredWaypointScriptGeneration.getQnearVariableName(this.waypointNode.getName());
    }

    private String getPoseVariableRelativeFromName() {
        return MeasuredWaypointScriptGeneration.getPoseVariableRelativeFromName(this.waypointNode.getName());
    }

    private String getPoseVariableRelativeToName() {
        return MeasuredWaypointScriptGeneration.getPoseVariableRelativeToName(this.waypointNode.getName());
    }

    public static String getPoseVariableName(String waypointName) {
        return MeasuredWaypointScriptGeneration.getCachedVariableName(waypointName, POSE_VARIABLE_NAME_CACHE, POSE_VARIABLE_POSTFIX);
    }

    public static String getQnearVariableName(String waypointName) {
        return MeasuredWaypointScriptGeneration.getCachedVariableName(waypointName, Q_NEAR_VARIABLE_NAME_CACHE, JOINTPOSITION_VARIABLE_POSTFIX);
    }

    public static String getPoseVariableRelativeFromName(String waypointName) {
        return MeasuredWaypointScriptGeneration.getCachedVariableName(waypointName, POSE_VARIABLE_RELATIVE_FROM_NAME_CACHE, POSE_VARIABLE_RELATIVE_FROM_POSTFIX);
    }

    public static String getPoseVariableRelativeToName(String waypointName) {
        return MeasuredWaypointScriptGeneration.getCachedVariableName(waypointName, POSE_VARIABLE_RELATIVE_TO_NAME_CACHE, POSE_VARIABLE_RELATIVE_TO_POSTFIX);
    }

    private static String getCachedVariableName(String waypointName, Map<String, String> cache, String postFix) {
        if (!cache.containsKey(waypointName)) {
            String result = ScriptConverter.toScriptCode((String)(String.valueOf(waypointName) + postFix), (boolean)false);
            cache.put(waypointName, result);
            return result;
        }
        return cache.get(waypointName);
    }
}

