/*
 * Decompiled with CFR 0.152.
 */
package gui.program.position;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.program.nodes.waypoint.motion.JointMotion;
import com.ur.polyscope.program.nodes.waypoint.motion.Motion;
import com.ur.polyscope.program.nodes.waypoint.motion.OptiMoveMotion;
import com.ur.polyscope.program.nodes.waypoint.motion.SharedMotion;
import com.ur.polyscope.program.nodes.waypoint.motion.TimeMotion;
import com.ur.polyscope.program.nodes.waypoint.motion.ToolMotion;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.polyscope.valueobjects.Time;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.IncompatibleMotionParameters;
import gui.program.MotionDefiningNode;
import gui.program.position.WaypointNode;
import java.util.HashMap;
import java.util.Map;

public final class MotionConfigurationFactory {
    private static final Map<Class<? extends Motion>, MotionConfiguration> apiToInternal = new HashMap<Class<? extends Motion>, MotionConfiguration>();

    static {
        apiToInternal.put(SharedMotion.class, new SharedConfiguration());
        apiToInternal.put(ToolMotion.class, new ToolConfiguration());
        apiToInternal.put(JointMotion.class, new JointConfiguration());
        apiToInternal.put(TimeMotion.class, new TimeConfiguration());
        apiToInternal.put(OptiMoveMotion.class, new OptiMoveConfiguration());
    }

    private MotionConfigurationFactory() {
    }

    static MotionConfiguration convertMotionTypeFromApiToInternal(Motion motion) {
        if (!apiToInternal.containsKey(motion.getClass())) {
            throw new IllegalArgumentException("Not supported motion type:" + motion);
        }
        return apiToInternal.get(motion.getClass());
    }

    static MotionConfiguration getWaypointMotionType(WaypointNode waypointNode, MotionDefiningNode moveNode) {
        if (moveNode == null && !waypointNode.isUsingSharedParameters()) {
            return new ToolConfiguration();
        }
        return waypointNode.getMotionParameters().getMotionConfiguration();
    }

    private static void throwIncompatibleMotion(MotionDefiningNode.MotionType motionType, String type) {
        throw new IncompatibleMotionParameters("Motion " + (Object)((Object)motionType) + " incompatible with " + type);
    }

    private static void isValidMotionType(MotionDefiningNode.MotionType motionType, String motionConfiguration) {
        if (!EqualsUtil.equalsOneOf((Object)((Object)motionType), (Object[])new MotionDefiningNode.MotionType[]{MotionDefiningNode.MotionType.JOINT_MOVE, MotionDefiningNode.MotionType.LINEAR_MOVE, MotionDefiningNode.MotionType.PROCESS_MOVE})) {
            MotionConfigurationFactory.throwIncompatibleMotion(motionType, motionConfiguration);
        }
    }

    static class JointConfiguration
    implements MotionConfiguration {
        JointConfiguration() {
        }

        @Override
        public void isCompatibleMotion(MotionDefiningNode.MotionType motionType) {
            if (motionType == MotionDefiningNode.MotionType.JOINT_MOVE) {
                return;
            }
            MotionConfigurationFactory.isValidMotionType(motionType, this.getType());
            MotionConfigurationFactory.throwIncompatibleMotion(motionType, this.getType());
        }

        @Override
        public String getType() {
            return "JOINT_MOTION";
        }

        @Override
        public Motion createMotion(WaypointNode waypointNode) {
            return new JointMotion(waypointNode.getSpeed().getIn(Speed.Unit.SI), waypointNode.getAcceleration().getIn(Acceleration.Unit.SI));
        }

        @Override
        public void handleMotion(Motion motion, WaypointNode waypointNode) {
            JointMotion jointMotion = (JointMotion)motion;
            waypointNode.setJointSpeed(jointMotion.getJointSpeed());
            waypointNode.setJointAcceleration(jointMotion.getJointAcceleration());
            waypointNode.setUsingIndividualParameters();
            waypointNode.setUsingOptiMove(false);
        }
    }

    static interface MotionConfiguration {
        public void isCompatibleMotion(MotionDefiningNode.MotionType var1);

        public String getType();

        public Motion createMotion(WaypointNode var1);

        public void handleMotion(Motion var1, WaypointNode var2);
    }

    static class OptiMoveConfiguration
    implements MotionConfiguration {
        OptiMoveConfiguration() {
        }

        @Override
        public void isCompatibleMotion(MotionDefiningNode.MotionType motionType) {
            if (motionType == MotionDefiningNode.MotionType.PROCESS_MOVE) {
                MotionConfigurationFactory.throwIncompatibleMotion(MotionDefiningNode.MotionType.PROCESS_MOVE, this.getType());
            }
            MotionConfigurationFactory.isValidMotionType(motionType, this.getType());
        }

        @Override
        public String getType() {
            return "OPTI_MOVE_MOTION";
        }

        @Override
        public Motion createMotion(WaypointNode waypointNode) {
            return new OptiMoveMotion(waypointNode.getOptiMoveSpeed(), waypointNode.getOptiMoveAcceleration());
        }

        @Override
        public void handleMotion(Motion motion, WaypointNode waypointNode) {
            OptiMoveMotion optiMoveMotion = (OptiMoveMotion)motion;
            waypointNode.setOptiMoveSpeed(optiMoveMotion.getSpeedPercentage());
            waypointNode.setOptiMoveAcceleration(optiMoveMotion.getAccelerationPercentage());
            waypointNode.setUsingIndividualParameters();
            waypointNode.setUsingOptiMove(true);
        }
    }

    static class SharedConfiguration
    implements MotionConfiguration {
        SharedConfiguration() {
        }

        @Override
        public void isCompatibleMotion(MotionDefiningNode.MotionType motionType) {
            MotionConfigurationFactory.isValidMotionType(motionType, this.getType());
        }

        @Override
        public String getType() {
            return "SHARED_MOTION";
        }

        @Override
        public Motion createMotion(WaypointNode waypointNode) {
            return new SharedMotion();
        }

        @Override
        public void handleMotion(Motion motion, WaypointNode waypointNode) {
            waypointNode.setUsingSharedParameters();
        }
    }

    static class TimeConfiguration
    implements MotionConfiguration {
        TimeConfiguration() {
        }

        @Override
        public void isCompatibleMotion(MotionDefiningNode.MotionType motionType) {
            if (motionType == MotionDefiningNode.MotionType.PROCESS_MOVE) {
                MotionConfigurationFactory.throwIncompatibleMotion(MotionDefiningNode.MotionType.PROCESS_MOVE, this.getType());
            }
            MotionConfigurationFactory.isValidMotionType(motionType, this.getType());
        }

        @Override
        public String getType() {
            return "TIME_MOTION";
        }

        @Override
        public Motion createMotion(WaypointNode waypointNode) {
            return new TimeMotion(waypointNode.getNextMotionTime().getIn(Time.Unit.SI));
        }

        @Override
        public void handleMotion(Motion motion, WaypointNode waypointNode) {
            TimeMotion timeMotion = (TimeMotion)motion;
            waypointNode.setUsingNextMotionTime();
            waypointNode.setNextMotionTime(Time.from((double)timeMotion.getTime(), (Time.Unit)Time.Unit.SI));
        }
    }

    static class ToolConfiguration
    implements MotionConfiguration {
        ToolConfiguration() {
        }

        @Override
        public void isCompatibleMotion(MotionDefiningNode.MotionType motionType) {
            MotionConfigurationFactory.isValidMotionType(motionType, this.getType());
            if (motionType == MotionDefiningNode.MotionType.JOINT_MOVE) {
                MotionConfigurationFactory.throwIncompatibleMotion(MotionDefiningNode.MotionType.JOINT_MOVE, this.getType());
            }
        }

        @Override
        public String getType() {
            return "TOOL_MOTION";
        }

        @Override
        public Motion createMotion(WaypointNode waypointNode) {
            return new ToolMotion(waypointNode.getSpeed().getIn(Speed.Unit.SI), waypointNode.getAcceleration().getIn(Acceleration.Unit.SI));
        }

        @Override
        public void handleMotion(Motion motion, WaypointNode waypointNode) {
            ToolMotion toolMotion = (ToolMotion)motion;
            waypointNode.setCartesianSpeed(toolMotion.getToolSpeed());
            waypointNode.setCartesianAcceleration(toolMotion.getToolAcceleration());
            waypointNode.setUsingIndividualParameters();
            waypointNode.setUsingOptiMove(false);
        }
    }
}

