/*
 * Decompiled with CFR 0.152.
 */
package gui.program.position;

import com.ur.polyscope.program.nodes.move.PositionNodeType;
import gui.program.Motion;
import gui.program.MotionDefiningNode;
import gui.program.position.PositionNode;
import gui.program.services.MotionData;
import java.util.Set;
import javax.inject.Inject;

public class PositionBlend {
    private double blendRadius = 0.05;
    private boolean useSharedBlendParameter = true;
    private PositionNode positionNode;
    private final MotionData motionData;

    @Inject
    public PositionBlend(MotionData motionData) {
        this.motionData = motionData;
    }

    public PositionBlend(PositionBlend positionBlend) {
        this(positionBlend.motionData);
        this.blendRadius = positionBlend.blendRadius;
        this.useSharedBlendParameter = positionBlend.useSharedBlendParameter;
        this.positionNode = positionBlend.positionNode;
    }

    void setPositionNode(PositionNode positionNode) {
        this.positionNode = positionNode;
    }

    private Set<Motion> getPreviousMotions() {
        return this.motionData.getPreviousMotions(this.positionNode);
    }

    private Set<Motion> getNextMotions() {
        return this.motionData.getNextMotions(this.positionNode);
    }

    boolean isUseSharedBlendParameter() {
        return this.useSharedBlendParameter;
    }

    void setUseSharedBlendParameter(boolean useSharedBlendParameter) {
        if (this.useSharedBlendParameter != useSharedBlendParameter) {
            this.useSharedBlendParameter = useSharedBlendParameter;
            this.setBlendRadiusToMaximumAllowed();
        }
    }

    double getBlend() {
        return this.blendRadius;
    }

    void setBlend(double b) {
        this.blendRadius = b;
    }

    void setBlendRadiusToMaximumAllowed() {
        if (this.useSharedBlendParameter) {
            return;
        }
        double maxBlendRadius = this.findMaxBlendRadius();
        if (!this.allowAnyBlendToPosition(this.positionNode) && maxBlendRadius < this.blendRadius) {
            if ((maxBlendRadius = (double)((int)(maxBlendRadius * 1000.0)) / 1000.0) - 0.001 > 0.0) {
                this.positionNode.setBlendRadius(maxBlendRadius - 0.001);
            } else {
                this.positionNode.setBlendRadius(0.0);
            }
        }
    }

    public double getBlendRadius() {
        MotionDefiningNode motionDefiningNode = this.positionNode.getMotionDefiningNode();
        if (motionDefiningNode != null && motionDefiningNode.isProcessMove()) {
            for (PositionNode node : this.positionNode.getNextPositionNodes(PositionNode.class)) {
                if (!node.getMotionDefiningNode().isNotProcessMove()) continue;
                return 0.0;
            }
            if (this.isUseSharedBlendParameter()) {
                return motionDefiningNode.getSharedProcessMoveBlendRadius();
            }
            return this.blendRadius;
        }
        if (motionDefiningNode != null && this.positionNode.isStopPoint()) {
            return 0.0;
        }
        return this.blendRadius;
    }

    double findMaxBlendRadius() {
        double maxBlendRadius = Double.MAX_VALUE;
        Set<Motion> previousMotions = this.getPreviousMotions();
        for (Motion m : previousMotions) {
            PositionNode p;
            if (m.getFromPositionNode().toString().equalsIgnoreCase(m.getToPositionNode().toString()) || m.isUndefined() || this.allowAnyBlendToPosition(p = m.getFromPositionNode())) continue;
            maxBlendRadius = Math.min(m.length() - p.getBlendRadius(), maxBlendRadius);
        }
        Set<Motion> nextMotions = this.getNextMotions();
        for (Motion m : nextMotions) {
            PositionNode p;
            if (m.getFromPositionNode().toString().equalsIgnoreCase(m.getToPositionNode().toString()) || m.isUndefined() || this.allowAnyBlendToPosition(p = m.getToPositionNode())) continue;
            maxBlendRadius = Math.min(m.length() - p.getBlendRadius(), maxBlendRadius);
        }
        return maxBlendRadius;
    }

    private boolean allowAnyBlendToPosition(PositionNode p) {
        return p.getPositionNodeType() == PositionNodeType.VARIABLE || p.getPositionNodeType() == PositionNodeType.RELATIVE;
    }

    boolean isBlendRadiusValid() {
        return this.blendRadiusIsAllRight(this.blendRadius);
    }

    boolean blendRadiusIsAllRight(double radius) {
        Set<Motion> previousMotions = this.getPreviousMotions();
        for (Motion m : previousMotions) {
            PositionNode p;
            if (m.isUndefined() || !((p = m.getFromPositionNode()).getBlendRadius() + radius > m.length())) continue;
            return false;
        }
        Set<Motion> nextMotions = this.getNextMotions();
        for (Motion m : nextMotions) {
            PositionNode p;
            if (m.isUndefined() || !((p = m.getToPositionNode()).getBlendRadius() + radius > m.length())) continue;
            return false;
        }
        return true;
    }

    void updateBlends() {
        Set<Motion> nextMotions;
        Set<Motion> previousMotions;
        if (!this.positionNode.isStopPoint() && !this.isBlendRadiusValid()) {
            this.setBlendRadiusToMaximumAllowed();
        }
        if ((previousMotions = this.getPreviousMotions()) != null) {
            for (Motion m : previousMotions) {
                PositionNode p;
                if (m.isUndefined() || (p = m.getFromPositionNode()).isBlendRadiusValid() || p.isStopPoint()) continue;
                p.setBlendRadiusToMaximumAllowed();
            }
        }
        if ((nextMotions = this.getNextMotions()) != null) {
            for (Motion m : nextMotions) {
                PositionNode p;
                if (m.isUndefined() || (p = m.getToPositionNode()).isBlendRadiusValid() || p.isStopPoint()) continue;
                p.setBlendRadiusToMaximumAllowed();
            }
        }
    }
}

