/*
 * Decompiled with CFR 0.152.
 */
package gui.program.position;

import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Percentage;
import com.ur.polyscope.valueobjects.Speed;
import gui.program.MotionDefiningNode;
import gui.program.position.MotionConfigurationFactory;
import gui.program.position.MotionParameters;
import javax.inject.Provider;

class SharedMotionParameters
implements MotionParameters {
    private final Provider<MotionDefiningNode> motionDefiningNodeProvider;
    private final MotionParameters fallbackMotionParameters;

    SharedMotionParameters(Provider<MotionDefiningNode> motionDefiningNodeProvider, MotionParameters fallbackMotionParameters) {
        this.motionDefiningNodeProvider = motionDefiningNodeProvider;
        this.fallbackMotionParameters = fallbackMotionParameters;
    }

    @Override
    public boolean isSharedParameters() {
        return true;
    }

    @Override
    public boolean isNextMotionTime() {
        return false;
    }

    @Override
    public boolean isOptiMove() {
        if (this.motionDefiningNodeProvider.get() == null) {
            return false;
        }
        return ((MotionDefiningNode)this.motionDefiningNodeProvider.get()).isUsingOptiMove();
    }

    @Override
    public Percentage getSpeedPercentage() {
        if (this.motionDefiningNodeProvider.get() == null) {
            return this.fallbackMotionParameters.getSpeedPercentage();
        }
        return ((MotionDefiningNode)this.motionDefiningNodeProvider.get()).getOptiMoveSpeed();
    }

    @Override
    public Percentage getAccelerationPercentage() {
        if (this.motionDefiningNodeProvider.get() == null) {
            return this.fallbackMotionParameters.getAccelerationPercentage();
        }
        return ((MotionDefiningNode)this.motionDefiningNodeProvider.get()).getOptiMoveAcceleration();
    }

    @Override
    public Speed getSpeed() {
        if (this.motionDefiningNodeProvider.get() == null) {
            return this.fallbackMotionParameters.getSpeed();
        }
        return ((MotionDefiningNode)this.motionDefiningNodeProvider.get()).getSpeed();
    }

    @Override
    public double getJointSpeed() {
        if (this.motionDefiningNodeProvider.get() == null) {
            return this.fallbackMotionParameters.getJointSpeed();
        }
        return ((MotionDefiningNode)this.motionDefiningNodeProvider.get()).getJointSpeed();
    }

    @Override
    public double getCartesianSpeed() {
        if (this.motionDefiningNodeProvider.get() == null) {
            return this.fallbackMotionParameters.getCartesianSpeed();
        }
        return ((MotionDefiningNode)this.motionDefiningNodeProvider.get()).getCartesianSpeed();
    }

    @Override
    public Acceleration getAcceleration() {
        if (this.motionDefiningNodeProvider.get() == null) {
            return this.fallbackMotionParameters.getAcceleration();
        }
        return ((MotionDefiningNode)this.motionDefiningNodeProvider.get()).getAcceleration();
    }

    @Override
    public double getJointAcceleration() {
        if (this.motionDefiningNodeProvider.get() == null) {
            return this.fallbackMotionParameters.getJointAcceleration();
        }
        return ((MotionDefiningNode)this.motionDefiningNodeProvider.get()).getJointAcceleration();
    }

    @Override
    public double getCartesianAcceleration() {
        if (this.motionDefiningNodeProvider.get() == null) {
            return this.fallbackMotionParameters.getCartesianAcceleration();
        }
        return ((MotionDefiningNode)this.motionDefiningNodeProvider.get()).getCartesianAcceleration();
    }

    @Override
    public String generateParameters() {
        if (this.isOptiMove()) {
            return this.generateOptiMoveParameters();
        }
        return ", a=" + this.getAcceleration().getIn(Acceleration.Unit.SI) + ", v=" + this.getSpeed().getIn(Speed.Unit.SI);
    }

    private String generateOptiMoveParameters() {
        return ", a=" + this.getAccelerationPercentage().getValue() + ", v=" + this.getSpeedPercentage().getValue();
    }

    @Override
    public MotionConfigurationFactory.MotionConfiguration getMotionConfiguration() {
        return new MotionConfigurationFactory.SharedConfiguration();
    }
}

