/*
 * Decompiled with CFR 0.152.
 */
package gui.program.position;

import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Percentage;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.polyscope.valueobjects.Time;
import gui.program.position.MotionConfigurationFactory;
import gui.program.position.MotionParameters;
import javax.inject.Provider;

class TimeMotionParameters
implements MotionParameters {
    private static final Time DEFAULT_MOTION_TIME = Time.from((double)2.0, (Time.Unit)Time.Unit.SI);
    private final MotionParameters fallbackMotionParameters;
    private final Provider<Boolean> isProcessMove;
    private Time nextMotionTime = DEFAULT_MOTION_TIME;

    TimeMotionParameters(TimeMotionParameters timeParameters, MotionParameters fallbackMotionParameters, Provider<Boolean> isProcessMove) {
        this(fallbackMotionParameters, isProcessMove);
        this.nextMotionTime = timeParameters.getNextMotionTime();
    }

    TimeMotionParameters(MotionParameters fallbackMotionParameters, Provider<Boolean> isProcessMove) {
        this.fallbackMotionParameters = fallbackMotionParameters;
        this.isProcessMove = isProcessMove;
    }

    @Override
    public boolean isSharedParameters() {
        return false;
    }

    @Override
    public boolean isNextMotionTime() {
        return true;
    }

    @Override
    public boolean isOptiMove() {
        return false;
    }

    @Override
    public Percentage getSpeedPercentage() {
        return this.fallbackMotionParameters.getSpeedPercentage();
    }

    @Override
    public Percentage getAccelerationPercentage() {
        return this.fallbackMotionParameters.getAccelerationPercentage();
    }

    @Override
    public Speed getSpeed() {
        return this.fallbackMotionParameters.getSpeed();
    }

    @Override
    public double getJointSpeed() {
        return this.fallbackMotionParameters.getJointSpeed();
    }

    @Override
    public double getCartesianSpeed() {
        return this.fallbackMotionParameters.getCartesianSpeed();
    }

    @Override
    public Acceleration getAcceleration() {
        return this.fallbackMotionParameters.getAcceleration();
    }

    @Override
    public double getJointAcceleration() {
        return this.fallbackMotionParameters.getJointAcceleration();
    }

    @Override
    public double getCartesianAcceleration() {
        return this.fallbackMotionParameters.getCartesianAcceleration();
    }

    public Time getNextMotionTime() {
        return this.nextMotionTime;
    }

    public void setNextMotionTime(Time nextMotionTime) {
        this.nextMotionTime = nextMotionTime == null ? DEFAULT_MOTION_TIME : nextMotionTime;
    }

    @Override
    public String generateParameters() {
        if (this.getNextMotionTime().getIn(Time.Unit.SI) > 0.0 && !((Boolean)this.isProcessMove.get()).booleanValue()) {
            return ", t=" + this.nextMotionTime.getIn(Time.Unit.SI);
        }
        return this.fallbackMotionParameters.generateParameters();
    }

    @Override
    public MotionConfigurationFactory.MotionConfiguration getMotionConfiguration() {
        if (((Boolean)this.isProcessMove.get()).booleanValue()) {
            return new MotionConfigurationFactory.SharedConfiguration();
        }
        return new MotionConfigurationFactory.TimeConfiguration();
    }
}

