/*
 * Decompiled with CFR 0.152.
 */
package gui.program.position;

import com.ur.lang.EqualsUtil;
import com.ur.lang.naming.NameChange;
import com.ur.lang.naming.NameChangeAspect;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.Position;
import com.ur.move.PositionReference;
import com.ur.polyscope.internaltcp.domain.TCPReference;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramNodeVisitor;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.program.nodes.waypoint.FixedWaypointNode;
import com.ur.polyscope.program.nodes.waypoint.RelativeWaypointNode;
import com.ur.polyscope.program.nodes.waypoint.VariableWaypointNode;
import com.ur.polyscope.program.nodes.waypoint.blend.Blend;
import com.ur.polyscope.program.nodes.waypoint.blend.NoBlend;
import com.ur.polyscope.program.nodes.waypoint.blend.RadiusBlend;
import com.ur.polyscope.program.nodes.waypoint.blend.SharedBlend;
import com.ur.polyscope.program.nodes.waypoint.motion.Motion;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChange;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChangeAspect;
import com.ur.polyscope.program.undoredo.ProgramNodeChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.program.variables.Variable;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.tcp.TCP;
import com.ur.polyscope.valueobjects.value.JointConfiguration;
import com.ur.polyscope.valueobjects.value.ToolPosition;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.view.hmc.HMC;
import com.ur.view.polyscope.interception.UpdateReservedNameAspect;
import com.ur.view.program.CommandPanel;
import com.ur.view.variables.InstallationVariableReference;
import com.ur.view.variables.domain.VariableLookupService;
import gui.commandpanels.PositionCard;
import gui.commandpanels.WaypointCard;
import gui.installation.RobotInstallationLookupService;
import gui.installation.services.LookupServiceFacade;
import gui.polyscope.setup.treenodes.geom.SetupFeatureContainerNode;
import gui.program.AnchoredSequenceNode;
import gui.program.CircleMoveNode;
import gui.program.MotionDefiningNode;
import gui.program.PatternNode;
import gui.program.UpdateReservedName;
import gui.program.position.IndividualMotionParameters;
import gui.program.position.MotionConfigurationFactory;
import gui.program.position.PositionNode;
import gui.program.position.WaypointNode$AjcClosure1;
import gui.program.position.WaypointNode$AjcClosure11;
import gui.program.position.WaypointNode$AjcClosure13;
import gui.program.position.WaypointNode$AjcClosure15;
import gui.program.position.WaypointNode$AjcClosure17;
import gui.program.position.WaypointNode$AjcClosure3;
import gui.program.position.WaypointNode$AjcClosure5;
import gui.program.position.WaypointNode$AjcClosure7;
import gui.program.position.WaypointNode$AjcClosure9;
import gui.program.position.WaypointScriptGeneration;
import gui.tools.LanguagePack;
import gui.tools.localization.TranslationLookup;
import javax.swing.tree.TreeNode;
import javax.vecmath.Point3d;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public abstract class WaypointNode
extends PositionNode
implements FixedWaypointNode,
RelativeWaypointNode,
VariableWaypointNode {
    private static final long serialVersionUID = 50L;
    public static final String VARIABLE_NAME = "Variable";
    public static final String DEFAULT_NAME;
    private Motion urcapApiDefinedMotion;
    private final NamingService namingService;
    private final transient TranslationLookup lookup;
    private String name;
    private String oldName;
    private BlendType configuredBlend;
    private transient boolean gettingFromPosition;
    private transient Pose6d lastTargetPose;
    private transient Pose6d lastTargetTCPOffset;
    private transient Pose6d lastControllerTCPOffset;
    protected PositionNodeType positionType = PositionNodeType.FIXED;
    transient JointPositionVector lastCalculatedJointPosition;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        WaypointNode.ajc$preClinit();
        DEFAULT_NAME = LanguagePack.getDefaultWaypointName();
    }

    WaypointNode(TranslationLookup lookup, IndividualMotionParameters motion, VariableLookupService variableLookupService, NamingService namingService) {
        super(motion, variableLookupService);
        this.namingService = namingService;
        this.name = DEFAULT_NAME;
        this.setNodeTypeName(this.name);
        this.lookup = lookup;
        this.oldName = DEFAULT_NAME;
    }

    protected abstract WaypointScriptGeneration getScriptGenerator();

    public String getOwnName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public AbstractProgramNode.BreakpointType getBreakPointType() {
        return AbstractProgramNode.BreakpointType.breakAfter;
    }

    @CompoundProgramChange
    public void setName(String newName) {
        String string = newName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        WaypointNode$AjcClosure1 waypointNode$AjcClosure1 = new WaypointNode$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(waypointNode$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @NameChange
    @ProgramNodeChange
    public void setNameInCompoundChange(String newName) {
        String string = newName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        WaypointNode$AjcClosure5 waypointNode$AjcClosure5 = new WaypointNode$AjcClosure5(objectArray);
        try {
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(waypointNode$AjcClosure5.linkStackClosureAndJoinPoint(69648));
            waypointNode$AjcClosure5.unlink();
        }
        catch (Throwable throwable) {
            waypointNode$AjcClosure5.unlink();
            throw throwable;
        }
    }

    public void accept(ProgramNodeVisitor visitor) {
        visitor.visit((com.ur.polyscope.program.nodes.waypoint.WaypointNode)this);
    }

    public String getNameInCompoundChange() {
        return this.getName();
    }

    public abstract Position getRelativeFromPosition();

    public abstract void setRelativeFromPosition(Position var1);

    public abstract void setToPosition(Position var1);

    public void setRelativeFromPosition(JointPositionVector jointPositionVector, Point3d toolPosition, Point3d toolAxisAngle) {
        this.setRelativeFromPosition(this.createPosition(jointPositionVector, toolPosition, toolAxisAngle));
    }

    @CompoundProgramChange
    public void unLink(String newName) {
        String string = newName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        WaypointNode$AjcClosure7 waypointNode$AjcClosure7 = new WaypointNode$AjcClosure7(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(waypointNode$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @UpdateReservedName
    @ProgramNodeChange
    public void setPosition(Position position) {
        Position position2 = position;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)position2);
        Object[] objectArray = new Object[]{this, position2, joinPoint};
        WaypointNode$AjcClosure11 waypointNode$AjcClosure11 = new WaypointNode$AjcClosure11(objectArray);
        try {
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(waypointNode$AjcClosure11.linkStackClosureAndJoinPoint(69648));
            waypointNode$AjcClosure11.unlink();
        }
        catch (Throwable throwable) {
            waypointNode$AjcClosure11.unlink();
            throw throwable;
        }
    }

    @Override
    public WaypointNode clone() {
        return (WaypointNode)super.clone();
    }

    public abstract void clonePositionReferences();

    public abstract double getDistanceBetweenPoints();

    public abstract double getAngleBetweenPoints();

    public Class<? extends CommandPanel<WaypointNode>> getCardClass() {
        return this.getMotionDefiningNode() instanceof PatternNode ? PositionCard.class : WaypointCard.class;
    }

    public boolean sameAs(NamedEntity entityToCompareTo) {
        if (this == entityToCompareTo) {
            return false;
        }
        if (!EqualsUtil.equals((Object)this.name, (Object)entityToCompareTo.getName())) {
            return false;
        }
        if (entityToCompareTo instanceof com.ur.view.variables.core.Variable) {
            return this.isSameVariable(entityToCompareTo);
        }
        if (entityToCompareTo instanceof GeomFeature) {
            return this.isSameGeomFeature(entityToCompareTo);
        }
        if (entityToCompareTo instanceof WaypointNode) {
            return this.isSameWaypointNode((WaypointNode)entityToCompareTo);
        }
        return false;
    }

    private boolean isSameVariable(NamedEntity entityToCompareTo) {
        return this.getPositionNodeType() == PositionNodeType.VARIABLE && this.getInternalVariable().sameAs(entityToCompareTo);
    }

    private boolean isSameGeomFeature(NamedEntity entityToCompareTo) {
        return this.getPositionNodeType() == PositionNodeType.VARIABLE && this.getInternalVariable().sameAs(entityToCompareTo);
    }

    private boolean isSameWaypointNode(WaypointNode entityToCompareTo) {
        if (!this.isUndefined() && !entityToCompareTo.isUndefined()) {
            return this.getScriptGenerator().generatePoseScriptCode().equals(entityToCompareTo.generatePoseScriptCode());
        }
        return this.isUndefined() && entityToCompareTo.isUndefined() && this.getName().equals(entityToCompareTo.getName());
    }

    @CompoundProgramChange
    public void linkTo(PositionReference positionReferenceToCopyValuesFrom) {
        PositionReference positionReference = positionReferenceToCopyValuesFrom;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)positionReference);
        Object[] objectArray = new Object[]{this, positionReference, joinPoint};
        WaypointNode$AjcClosure13 waypointNode$AjcClosure13 = new WaypointNode$AjcClosure13(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(waypointNode$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    public abstract JointPositionVector getRelativeFromJointPositionVector();

    public final boolean isGettingFromPosition() {
        return this.gettingFromPosition;
    }

    public final void setGettingFromPosition(boolean gettingFromPosition) {
        this.gettingFromPosition = gettingFromPosition;
    }

    public abstract Point3d getRelativeFromToolPosition();

    public abstract Point3d getRelativeFromToolAxisAngle();

    public boolean isLinkable() {
        return EqualsUtil.equalsOneOf((Object)this.getPositionNodeType(), (Object[])new PositionNodeType[]{PositionNodeType.RELATIVE, PositionNodeType.FIXED});
    }

    public PositionNodeType getPositionNodeType() {
        return this.positionType;
    }

    @ProgramEntitiesChange
    @ProgramNodeChange
    public void setPositionNodeType(PositionNodeType newPositionType) {
        PositionNodeType positionNodeType = newPositionType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)positionNodeType);
        Object[] objectArray = new Object[]{this, positionNodeType, joinPoint};
        WaypointNode$AjcClosure17 waypointNode$AjcClosure17 = new WaypointNode$AjcClosure17(objectArray);
        try {
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(waypointNode$AjcClosure17.linkStackClosureAndJoinPoint(69648));
            waypointNode$AjcClosure17.unlink();
        }
        catch (Throwable throwable) {
            waypointNode$AjcClosure17.unlink();
            throw throwable;
        }
    }

    private void handlePositionNodeTypeChange(PositionNodeType oldType, PositionNodeType newPositionType) {
        if (newPositionType == PositionNodeType.VARIABLE) {
            this.handleNewPositionTypeChange();
        } else if (oldType == PositionNodeType.VARIABLE) {
            this.handleOldPositionTypeChange();
        }
    }

    private void handleNewPositionTypeChange() {
        this.oldName = this.name;
        this.namingService.deregisterNamedEntity((NamedEntity)this);
        this.name = VARIABLE_NAME;
    }

    private void handleOldPositionTypeChange() {
        this.name = this.namingService.makeUniqueName(WaypointNode.class, this.oldName);
    }

    @Override
    public com.ur.view.variables.core.Variable getInternalVariable() {
        if (this.positionType == PositionNodeType.VARIABLE) {
            return super.getInternalVariable();
        }
        return null;
    }

    public GeomFeature getGeomFeature() {
        if (this.getMotionDefiningNode() == null) {
            RobotInstallationLookupService lookupService = LookupServiceFacade.get(RobotInstallationLookupService.class);
            return ((SetupFeatureContainerNode)lookupService.getComponent(SetupFeatureContainerNode.class)).getBaseViewFeature();
        }
        return this.getMotionDefiningNode().getDereferencedGeomFeature();
    }

    boolean isVariableUndefined() {
        if (this.getInternalVariable() == null) {
            return true;
        }
        if (this.getInternalVariable() instanceof InstallationVariableReference) {
            return !((InstallationVariableReference)this.getInternalVariable()).isPoseOrJointVector();
        }
        return this.getInternalVariable().isUndefined();
    }

    int hashCodeOf(Object instance) {
        return instance == null ? 0 : instance.hashCode();
    }

    public abstract boolean isLinkedTo(PositionReference var1);

    public abstract void setPositionReferences(PositionReference var1);

    public void setConfiguredBlend(BlendType blendType) {
        this.configuredBlend = blendType;
    }

    public BlendType getConfiguredBlendType() {
        return this.configuredBlend != null ? this.configuredBlend : this.getBlendType();
    }

    public BlendType getBlendType() {
        return this.getBlendType(this.getMotionDefiningNode());
    }

    private BlendType getBlendType(MotionDefiningNode moveNode) {
        return this.isProcessMoveNode(moveNode) ? this.determineBlendTypeForProcessMove() : this.determineBlendTypeForNonProcessMove();
    }

    private boolean isProcessMoveNode(MotionDefiningNode moveNode) {
        return moveNode != null && moveNode.isProcessMove();
    }

    private BlendType determineBlendTypeForProcessMove() {
        if (this.isUseSharedBlendParameter()) {
            return BlendType.SHARED_BLEND;
        }
        return BlendType.BLEND_WITH_RADIUS;
    }

    private BlendType determineBlendTypeForNonProcessMove() {
        return this.isStopPoint() ? BlendType.NO_BLEND : BlendType.BLEND_WITH_RADIUS;
    }

    public boolean isInvalidWaypoint() {
        return false;
    }

    @Override
    public boolean isUndefined() {
        if (super.isUndefined()) {
            return true;
        }
        return this.isInvalidWaypoint();
    }

    @Override
    public ScriptWriter generateMoveCommand(ScriptWriter writer, boolean useBlend, boolean visualizationScript) {
        if (this.isUndefined()) {
            return writer;
        }
        return this.getScriptGenerator().waypointNodeToScript(writer, useBlend, visualizationScript);
    }

    public String generatePoseScriptCode() {
        return this.getScriptGenerator().generatePoseScriptCode();
    }

    public ScriptWriter generateFixedWaypointCode(ScriptWriter writer, String poseVarName, AnchoredSequenceNode parent) {
        return this.getScriptGenerator().generateFixedWaypointCode(writer, parent, poseVarName);
    }

    void updateLastCalculatedJointPosition(Pose6d targetToolPose, Pose6d controllerTCPOffset, Pose6d targetTCPOffset) {
        if (this.hasControllerTcpOffsetChanged(controllerTCPOffset) || this.hasTargetTcpChanged(targetTCPOffset) || this.hasTargetToolPoseChanged(targetToolPose)) {
            this.lastTargetPose = new Pose6d(targetToolPose);
            this.lastTargetTCPOffset = new Pose6d(targetTCPOffset);
            this.lastControllerTCPOffset = new Pose6d(controllerTCPOffset);
            Pose6d targetToolPoseForControllerTCPOffset = Pose6dTransformUtils.getPoseWithModifiedOffset((Pose6d)targetToolPose, (Pose6d)targetTCPOffset, (Pose6d)controllerTCPOffset);
            if (!WaypointNode.poseIsUndefined(targetToolPoseForControllerTCPOffset)) {
                this.lastCalculatedJointPosition = new HMC().getInverseKinematics(targetToolPoseForControllerTCPOffset, this.getJointPositionVector());
            }
        }
    }

    private boolean hasTargetToolPoseChanged(Pose6d targetToolPose) {
        return !EqualsUtil.equals((Object)this.lastTargetPose, (Object)targetToolPose);
    }

    private boolean hasTargetTcpChanged(Pose6d targetTCPOffset) {
        return !EqualsUtil.equals((Object)this.lastTargetTCPOffset, (Object)targetTCPOffset);
    }

    private boolean hasControllerTcpOffsetChanged(Pose6d controllerTCPOffset) {
        return !EqualsUtil.equals((Object)this.lastControllerTCPOffset, (Object)controllerTCPOffset);
    }

    public String toString() {
        if (this.getPositionNodeType() == PositionNodeType.VARIABLE) {
            com.ur.view.variables.core.Variable v = this.getInternalVariable();
            return v == null ? this.lookup.getText(VARIABLE_NAME) : v.toString();
        }
        return this.getName();
    }

    @Override
    public boolean equivalentTo(PositionNode other) {
        if (other instanceof WaypointNode) {
            WaypointNode otherWaypoint = (WaypointNode)other;
            return EqualsUtil.equals((Object)this.getRelativeFromJointPositionVector(), (Object)otherWaypoint.getRelativeFromJointPositionVector()) && EqualsUtil.equals((Object)this.getPositionNodeType(), (Object)otherWaypoint.getPositionNodeType()) && EqualsUtil.equals((Object)this.getInternalVariable(), (Object)otherWaypoint.getInternalVariable()) && EqualsUtil.equals((Object)this.getName(), (Object)otherWaypoint.getName());
        }
        return false;
    }

    private static boolean poseIsUndefined(Pose6d pose) {
        return Double.isNaN(pose.getX()) || Double.isNaN(pose.getY()) || Double.isNaN(pose.getZ()) || Double.isNaN(pose.getRX()) || Double.isNaN(pose.getRY()) || Double.isNaN(pose.getRZ());
    }

    public Class<? extends com.ur.polyscope.program.nodes.waypoint.WaypointNode> getType() {
        Class<FixedWaypointNode> type;
        PositionNodeType positionNodeType = this.getPositionNodeType();
        switch (positionNodeType) {
            case FIXED: {
                type = FixedWaypointNode.class;
                break;
            }
            case RELATIVE: {
                type = RelativeWaypointNode.class;
                break;
            }
            case VARIABLE: {
                type = VariableWaypointNode.class;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported node type: " + positionNodeType);
            }
        }
        return type;
    }

    public <T extends com.ur.polyscope.program.nodes.waypoint.WaypointNode> T convertTo(Class<T> clazz) {
        if (clazz != this.getType()) {
            if (clazz == FixedWaypointNode.class) {
                this.setPositionNodeType(PositionNodeType.FIXED);
            } else if (clazz == RelativeWaypointNode.class) {
                this.setPositionNodeType(PositionNodeType.RELATIVE);
            } else if (clazz == VariableWaypointNode.class) {
                this.setPositionNodeType(PositionNodeType.VARIABLE);
            } else {
                throw new IllegalArgumentException("Unsupported node type:" + clazz);
            }
        }
        return (T)((com.ur.polyscope.program.nodes.waypoint.WaypointNode)clazz.cast(this));
    }

    public com.ur.polyscope.valueobjects.value.Position getPosition() {
        Position p = this.getPositionReference();
        return WaypointNode.convertPositionFromInternalToApi(p);
    }

    public void setPosition(com.ur.polyscope.valueobjects.value.Position position) {
        if (position == null) {
            this.setPosition(new JointPositionVector(), new Point3d(), new Point3d());
        } else {
            JointConfiguration jointConfiguration = position.getJointConfiguration();
            JointPositionVector jointPositionVector = new JointPositionVector(jointConfiguration.asArray());
            ToolPosition tp = position.getToolPosition();
            Point3d toolPosition = new Point3d(tp.getPositionX(), tp.getPositionY(), tp.getPositionZ());
            Point3d toolAxisAngle = new Point3d(tp.getRotationX(), tp.getRotationY(), tp.getRotationZ());
            this.setPosition(jointPositionVector, toolPosition, toolAxisAngle);
        }
    }

    public ToolPosition getTCPOffset() {
        TCPReference tcpReference = this.getTCPReference();
        if (tcpReference != null && tcpReference.dereference() != null) {
            TCP tcp = tcpReference.dereference();
            return tcp.getOffsetPose();
        }
        return new ToolPosition(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public com.ur.polyscope.valueobjects.value.Position getFromPosition() {
        Position p = this.getRelativeFromPosition();
        return WaypointNode.convertPositionFromInternalToApi(p);
    }

    public void setFromPosition(com.ur.polyscope.valueobjects.value.Position position) {
        Position p = this.convertPositionFromApiToInternal(position);
        this.setRelativeFromPosition(p);
    }

    public com.ur.polyscope.valueobjects.value.Position getToPosition() {
        return this.getPosition();
    }

    public void setToPosition(com.ur.polyscope.valueobjects.value.Position position) {
        this.setPosition(position);
    }

    public Motion getMotion() {
        if (this.getMotionDefiningNode() == null && this.urcapApiDefinedMotion != null) {
            return this.urcapApiDefinedMotion;
        }
        MotionConfigurationFactory.MotionConfiguration waypointMotionType = MotionConfigurationFactory.getWaypointMotionType(this, this.getMotionDefiningNode());
        return waypointMotionType.createMotion(this);
    }

    public void setMotion(Motion motion) {
        this.urcapApiDefinedMotion = motion;
        MotionConfigurationFactory.MotionConfiguration waypointConfiguration = MotionConfigurationFactory.convertMotionTypeFromApiToInternal(motion);
        this.isCompatibleMotion(waypointConfiguration, this.getMotionDefiningNode());
        waypointConfiguration.handleMotion(motion, this);
    }

    public void isCompatibleBlend(MotionDefiningNode moveNode) {
        BlendType blendType = this.adjustBlendType(this.getConfiguredBlendType(), moveNode);
        WaypointNode.checkBlendCompatibility(blendType, moveNode);
    }

    private void isCompatibleMotion(MotionConfigurationFactory.MotionConfiguration configuration, MotionDefiningNode moveNode) {
        if (moveNode == null) {
            return;
        }
        configuration.isCompatibleMotion(moveNode.getMotionType());
    }

    public void isCompatibleMotion(MotionDefiningNode moveNode) {
        if (this.getMotionDefiningNode() == null && this.urcapApiDefinedMotion == null) {
            return;
        }
        if (this.getMotionDefiningNode() == null) {
            MotionConfigurationFactory.MotionConfiguration motionConfiguration = MotionConfigurationFactory.convertMotionTypeFromApiToInternal(this.urcapApiDefinedMotion);
            motionConfiguration.isCompatibleMotion(moveNode.getMotionType());
            return;
        }
        MotionConfigurationFactory.MotionConfiguration motionConfiguration = MotionConfigurationFactory.getWaypointMotionType(this, this.getMotionDefiningNode());
        motionConfiguration.isCompatibleMotion(moveNode.getMotionType());
    }

    public Blend getBlend() {
        switch (this.getBlendType()) {
            case NO_BLEND: {
                return new NoBlend();
            }
            case SHARED_BLEND: {
                return new SharedBlend();
            }
            case BLEND_WITH_RADIUS: {
                return new RadiusBlend(this.getBlendRadius());
            }
        }
        throw new IllegalStateException("Can't get blend, cause of unsupported blend type:" + (Object)((Object)this.getBlendType()));
    }

    public void setBlend(Blend blend) {
        BlendType blendType = this.convertBlendTypeFromApiToInternal(blend);
        MotionDefiningNode motionDefiningNode = this.getMotionDefiningNode();
        blendType = this.adjustBlendType(blendType, motionDefiningNode);
        WaypointNode.checkBlendCompatibility(blendType, motionDefiningNode);
        this.setConfiguredBlend(blendType);
        switch (blendType) {
            case NO_BLEND: {
                this.setStopPoint(true);
                break;
            }
            case SHARED_BLEND: {
                this.setUseSharedBlendParameter(true);
                break;
            }
            case BLEND_WITH_RADIUS: {
                this.setStopPoint(false);
                this.setUseSharedBlendParameter(false);
                this.setBlendRadius(((RadiusBlend)blend).getRadius());
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't set blend cause : Not supported blend type:" + blend);
            }
        }
    }

    private BlendType convertBlendTypeFromApiToInternal(Blend blend) {
        BlendType type;
        if (blend instanceof NoBlend) {
            type = BlendType.NO_BLEND;
        } else if (blend instanceof SharedBlend) {
            type = BlendType.SHARED_BLEND;
        } else if (blend instanceof RadiusBlend) {
            type = BlendType.BLEND_WITH_RADIUS;
        } else {
            throw new IllegalArgumentException("Not supported blend type:" + blend);
        }
        return type;
    }

    private BlendType adjustBlendType(BlendType blendType, MotionDefiningNode motionDefiningNode) {
        if (motionDefiningNode == null) {
            return blendType;
        }
        BlendType newBlendType = blendType;
        MotionDefiningNode.MotionType motionType = motionDefiningNode.getMotionType();
        switch (motionType) {
            case JOINT_MOVE: 
            case LINEAR_MOVE: {
                if (!EqualsUtil.equalsOneOf((Object)((Object)blendType), (Object[])new BlendType[]{BlendType.SHARED_BLEND})) break;
                newBlendType = BlendType.NO_BLEND;
                break;
            }
            case PROCESS_MOVE: {
                if (!EqualsUtil.equalsOneOf((Object)((Object)blendType), (Object[])new BlendType[]{BlendType.NO_BLEND})) break;
                newBlendType = BlendType.SHARED_BLEND;
            }
        }
        return newBlendType;
    }

    private static void checkBlendCompatibility(BlendType blendType, MotionDefiningNode motionDefiningNode) {
        if (motionDefiningNode == null) {
            return;
        }
        MotionDefiningNode.MotionType motionType = motionDefiningNode.getMotionType();
        switch (motionType) {
            case JOINT_MOVE: 
            case LINEAR_MOVE: {
                if (EqualsUtil.equalsOneOf((Object)((Object)blendType), (Object[])new BlendType[]{BlendType.NO_BLEND, BlendType.BLEND_WITH_RADIUS})) break;
                throw new IllegalArgumentException("Move node " + (Object)((Object)motionType) + " incompatible with " + (Object)((Object)blendType));
            }
            case PROCESS_MOVE: {
                if (EqualsUtil.equalsOneOf((Object)((Object)blendType), (Object[])new BlendType[]{BlendType.SHARED_BLEND, BlendType.BLEND_WITH_RADIUS})) break;
                throw new IllegalArgumentException("Move node " + (Object)((Object)motionType) + " incompatible with " + (Object)((Object)blendType));
            }
            default: {
                throw new IllegalArgumentException("Unsupported motion " + (Object)((Object)motionType));
            }
        }
    }

    public Variable getVariable() {
        return this.getInternalVariable();
    }

    public void setVariable(Variable variable) {
        this.setInternalVariable((com.ur.view.variables.core.Variable)variable);
    }

    private static com.ur.polyscope.valueobjects.value.Position convertPositionFromInternalToApi(Position p) {
        Point3d tp = p.getToolPosition();
        Point3d aa = p.getToolAxisAngle();
        ToolPosition toolPosition = new ToolPosition(tp.getX(), tp.getY(), tp.getZ(), aa.getX(), aa.getY(), aa.getZ());
        JointPositionVector jpv = p.getJointPositionVector();
        JointConfiguration jointConfiguration = new JointConfiguration(jpv.getJoint(0), jpv.getJoint(1), jpv.getJoint(2), jpv.getJoint(3), jpv.getJoint(4), jpv.getJoint(5));
        return new com.ur.polyscope.valueobjects.value.Position(toolPosition, jointConfiguration);
    }

    private Position convertPositionFromApiToInternal(com.ur.polyscope.valueobjects.value.Position position) {
        JointConfiguration jc = position.getJointConfiguration();
        JointPositionVector jpv = new JointPositionVector(jc.getBase(), jc.getShoulder(), jc.getElbow(), jc.getWrist1(), jc.getWrist2(), jc.getWrist3());
        ToolPosition tp = position.getToolPosition();
        Point3d toolPosition = new Point3d(tp.getPositionX(), tp.getPositionY(), tp.getPositionZ());
        Point3d toolAxisAngle = new Point3d(tp.getRotationX(), tp.getRotationY(), tp.getRotationZ());
        return this.createPosition(jpv, toolPosition, toolAxisAngle);
    }

    public boolean isViaPointInCircleMove() {
        TreeNode p = this.getParent();
        return p instanceof CircleMoveNode && p.getChildAt(0) == this;
    }

    public boolean canPauseOnNode() {
        return super.canPauseOnNode() && !this.isViaPointInCircleMove();
    }

    static final /* synthetic */ void setName_aroundBody0(WaypointNode ajc$this, String newName, JoinPoint joinPoint) {
        ajc$this.setNameInCompoundChange(newName);
    }

    static final /* synthetic */ void setNameInCompoundChange_aroundBody2(WaypointNode ajc$this, String newName, JoinPoint joinPoint) {
        if (ajc$this.getPositionNodeType() != PositionNodeType.VARIABLE) {
            ajc$this.name = newName;
            ajc$this.textHasChanged();
        }
    }

    static final /* synthetic */ void setNameInCompoundChange_aroundBody4(WaypointNode waypointNode, String string, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{waypointNode, string, joinPoint};
        WaypointNode$AjcClosure3 waypointNode$AjcClosure3 = new WaypointNode$AjcClosure3(objectArray);
        try {
            NameChangeAspect.aspectOf().aroundAnnotatedMethod(waypointNode$AjcClosure3.linkStackClosureAndJoinPoint(69648));
            waypointNode$AjcClosure3.unlink();
        }
        catch (Throwable throwable) {
            waypointNode$AjcClosure3.unlink();
            throw throwable;
        }
    }

    static final /* synthetic */ void unLink_aroundBody6(WaypointNode ajc$this, String newName, JoinPoint joinPoint) {
        ajc$this.clonePositionReferences();
        ajc$this.setName(newName);
    }

    static final /* synthetic */ void setPosition_aroundBody8(WaypointNode ajc$this, Position position, JoinPoint joinPoint) {
        if (ajc$this.gettingFromPosition) {
            ajc$this.setRelativeFromPosition(position);
            ajc$this.gettingFromPosition = false;
        } else {
            ajc$this.setToPosition(position);
        }
    }

    static final /* synthetic */ void setPosition_aroundBody10(WaypointNode waypointNode, Position position, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{waypointNode, position, joinPoint};
        WaypointNode$AjcClosure9 waypointNode$AjcClosure9 = new WaypointNode$AjcClosure9(objectArray);
        try {
            UpdateReservedNameAspect.aspectOf().aroundAnnotatedMethod(waypointNode$AjcClosure9.linkStackClosureAndJoinPoint(69648));
            waypointNode$AjcClosure9.unlink();
        }
        catch (Throwable throwable) {
            waypointNode$AjcClosure9.unlink();
            throw throwable;
        }
    }

    static final /* synthetic */ void linkTo_aroundBody12(WaypointNode ajc$this, PositionReference positionReferenceToCopyValuesFrom, JoinPoint joinPoint) {
        ajc$this.setPositionReferences(positionReferenceToCopyValuesFrom);
    }

    static final /* synthetic */ void setPositionNodeType_aroundBody14(WaypointNode ajc$this, PositionNodeType newPositionType, JoinPoint joinPoint) {
        if (ajc$this.getPositionNodeType() == newPositionType) {
            return;
        }
        ajc$this.handlePositionNodeTypeChange(ajc$this.getPositionNodeType(), newPositionType);
        ajc$this.positionType = newPositionType;
        ajc$this.namingService.registerNamedEntity((NamedEntity)ajc$this);
        ajc$this.textHasChanged();
    }

    static final /* synthetic */ void setPositionNodeType_aroundBody16(WaypointNode waypointNode, PositionNodeType positionNodeType, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{waypointNode, positionNodeType, joinPoint};
        WaypointNode$AjcClosure15 waypointNode$AjcClosure15 = new WaypointNode$AjcClosure15(objectArray);
        try {
            ProgramEntitiesChangeAspect.aspectOf().aroundAnnotatedMethod(waypointNode$AjcClosure15.linkStackClosureAndJoinPoint(69648));
            waypointNode$AjcClosure15.unlink();
        }
        catch (Throwable throwable) {
            waypointNode$AjcClosure15.unlink();
            throw throwable;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WaypointNode.java", WaypointNode.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setName", "gui.program.position.WaypointNode", "java.lang.String", "newName", "", "void"), 110);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setNameInCompoundChange", "gui.program.position.WaypointNode", "java.lang.String", "newName", "", "void"), 116);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unLink", "gui.program.position.WaypointNode", "java.lang.String", "newName", "", "void"), 148);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPosition", "gui.program.position.WaypointNode", "com.ur.move.Position", "position", "", "void"), 156);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "linkTo", "gui.program.position.WaypointNode", "com.ur.move.PositionReference", "positionReferenceToCopyValuesFrom", "", "void"), 220);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPositionNodeType", "gui.program.position.WaypointNode", "com.ur.polyscope.program.nodes.move.PositionNodeType", "newPositionType", "", "void"), 250);
    }

    private static enum BlendType {
        SHARED_BLEND,
        NO_BLEND,
        BLEND_WITH_RADIUS;

    }
}

