/*
 * Decompiled with CFR 0.152.
 */
package gui.program.position;

import com.ur.lang.DecimalFormatFactory;
import com.ur.monitor.model.JointPositionVector;
import com.ur.polyscope.scriptwriter.ControllerInterfaceProgramNode;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.util.logging.Log;
import gui.program.AnchoredSequenceNode;
import gui.program.CircleMoveNode;
import gui.program.MotionDefiningNode;
import gui.program.position.WaypointNode;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Objects;
import javax.swing.tree.TreeNode;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public abstract class WaypointScriptGeneration {
    private static final DecimalFormat df = DecimalFormatFactory.createHalfEvenDecimalFormatWithLocale((String)"#.000000000000", (Locale)Locale.ENGLISH);
    private static final String ERROR_GENERATING_CIRCLE_MOVE = "ERROR!";
    private final WaypointNode waypointNode;

    public WaypointScriptGeneration(WaypointNode waypointNode) {
        this.waypointNode = waypointNode;
    }

    public ScriptWriter waypointNodeToScript(ScriptWriter writer, boolean useBlend, boolean visualizationScript) {
        MotionDefiningNode motionDefiningNode = this.waypointNode.getMotionDefiningNode();
        if (!visualizationScript) {
            this.setTCP(writer, motionDefiningNode);
        }
        MotionDefiningNode.MotionType motionType = motionDefiningNode == null ? MotionDefiningNode.MotionType.JOINT_MOVE : motionDefiningNode.getMotionType();
        switch (motionType) {
            case JOINT_MOVE: {
                writer.appendLine(this.generateJointMove(useBlend, visualizationScript));
                break;
            }
            case LINEAR_MOVE: {
                writer.appendLine(this.generateLinearCartesianMove(useBlend, visualizationScript));
                break;
            }
            case PROCESS_MOVE: {
                writer.appendLine(this.generateProcessMove(visualizationScript));
                break;
            }
            default: {
                Log.error((String)"MotionType unknown");
                writer.appendLine("MOTION TYPE ERROR");
            }
        }
        return writer;
    }

    protected abstract void setTCP(ScriptWriter var1, MotionDefiningNode var2);

    protected String generatePose(Tuple3d pos, Tuple3d rot) {
        return "p[" + df.format(pos.x) + ", " + df.format(pos.y) + ", " + df.format(pos.z) + ", " + df.format(rot.x) + ", " + df.format(rot.y) + ", " + df.format(rot.z) + "]";
    }

    private String getMoveLScriptCommand(WaypointNode waypointNode) {
        if (waypointNode.isUsingOptiMove() && !waypointNode.isUsingNextMotionTime()) {
            return "optimovel";
        }
        return "movel";
    }

    private String getMoveJScriptCommand(WaypointNode waypointNode) {
        if (waypointNode.isUsingOptiMove() && !waypointNode.isUsingNextMotionTime()) {
            return "optimovej";
        }
        return "movej";
    }

    private String generateLinearCartesianMove(boolean useBlend, boolean visualizationScript) {
        String position;
        if (visualizationScript) {
            JointPositionVector jointPositionVector = this.waypointNode.getActualJointPositionVector();
            position = jointPositionVector.toString();
        } else {
            position = this.generateLinearCartesianPositionScript();
        }
        String moveType = this.getMoveLScriptCommand(this.waypointNode);
        if (!this.waypointNode.isStopPoint() && useBlend && this.waypointNode.getBlendRadius() > 0.0) {
            return String.valueOf(moveType) + "(" + position + this.waypointNode.generateMotionParametersCode() + ", r=" + this.waypointNode.getBlendRadius() + ")";
        }
        return String.valueOf(moveType) + "(" + position + this.waypointNode.generateMotionParametersCode() + ")";
    }

    protected abstract String generateLinearCartesianPositionScript();

    private String generateJointMove(boolean useBlend, boolean visualizationScript) {
        String position;
        if (visualizationScript) {
            JointPositionVector jointPositionVector = this.waypointNode.getActualJointPositionVector();
            position = jointPositionVector.toString();
        } else {
            position = this.generateJointMoveScript(useBlend);
        }
        String moveType = this.getMoveJScriptCommand(this.waypointNode);
        if (!this.waypointNode.isStopPoint() && useBlend && this.waypointNode.getBlendRadius() > 0.0) {
            return String.valueOf(moveType) + "(" + position + this.waypointNode.generateMotionParametersCode() + ", r=" + this.waypointNode.getBlendRadius() + ")";
        }
        return String.valueOf(moveType) + "(" + position + this.waypointNode.generateMotionParametersCode() + ")";
    }

    protected abstract String generateJointMoveScript(boolean var1);

    private String generateProcessMove(boolean visualizationScript) {
        String position;
        boolean isCircleMove = this.waypointNode.getParent() instanceof CircleMoveNode;
        if (isCircleMove && this.waypointNode.isCircleDefiningNode()) {
            return "";
        }
        if (visualizationScript) {
            Point3d posTo = this.waypointNode.getToolPosition();
            Point3d rotTo = this.waypointNode.getToolAxisAngle();
            position = this.generatePose((Tuple3d)posTo, (Tuple3d)rotTo);
        } else {
            position = this.generatePoseScriptCode();
        }
        if (isCircleMove) {
            return String.valueOf(this.generateCircleMove(visualizationScript)) + position + this.waypointNode.generateMotionParametersCode() + ", r=" + this.waypointNode.getBlendRadius() + this.generateCircleMoveOrientationMode() + ")";
        }
        return "movep(" + position + this.waypointNode.generateMotionParametersCode() + ", r=" + this.waypointNode.getBlendRadius() + ")";
    }

    private String generateCircleMoveOrientationMode() {
        CircleMoveNode parent = (CircleMoveNode)((Object)this.waypointNode.getParent());
        if (Objects.requireNonNull(parent.getOrientationMode()) == CircleMoveNode.OrientationMode.FIXED) {
            return ", mode=1";
        }
        return "";
    }

    private String generateCircleMove(boolean visualizationScript) {
        TreeNode parent = this.waypointNode.getParent();
        if (!(parent instanceof CircleMoveNode)) {
            Log.error((String)"Parent node is not CircleMoveNode!");
            return ERROR_GENERATING_CIRCLE_MOVE;
        }
        if (parent.getChildCount() != 2) {
            Log.error((String)"Parent node does not have two children!");
            return ERROR_GENERATING_CIRCLE_MOVE;
        }
        if (!(parent.getChildAt(0) instanceof WaypointNode)) {
            Log.error((String)"First child of parent is not a WaypointNode!");
            return ERROR_GENERATING_CIRCLE_MOVE;
        }
        if (((WaypointNode)((Object)parent.getChildAt(0))).isUndefined()) {
            Log.error((String)"First child of parent is undefined!");
            return ERROR_GENERATING_CIRCLE_MOVE;
        }
        if (parent.getChildAt(1) != this.waypointNode) {
            Log.error((String)"Was about to construct a movec command but this PositionNode is not the second child of a CircleMoveNode!");
            return ERROR_GENERATING_CIRCLE_MOVE;
        }
        WaypointNode circleDefiningNode = (WaypointNode)((Object)parent.getChildAt(0));
        String pose = visualizationScript ? this.generatePose((Tuple3d)circleDefiningNode.getToolPosition(), (Tuple3d)circleDefiningNode.getToolAxisAngle()) : circleDefiningNode.generatePoseScriptCode();
        return "movec(" + pose + ", ";
    }

    protected void appendPoseTransformation(StringBuilder s, String featurePose, String pose) {
        s.append("pose_trans(");
        s.append(featurePose);
        s.append(", ");
        s.append(pose);
        s.append(")");
    }

    public ScriptWriter generateFixedWaypointCode(ScriptWriter writer, AnchoredSequenceNode parent, String poseVarName) {
        this.waypointNode.scriptBegin(writer);
        writer.writeProgramLabel((ControllerInterfaceProgramNode)this.waypointNode);
        String spd = "" + this.waypointNode.getSpeed().getIn(Speed.Unit.SI);
        String acc = "" + this.waypointNode.getAcceleration().getIn(Acceleration.Unit.SI);
        if (this.waypointNode == parent.getAnchorWaypointNode()) {
            if (!this.waypointNode.isStopPoint() && this.waypointNode.getBlendRadius() > 0.0) {
                writer.movel(poseVarName, acc, spd, "" + this.waypointNode.getBlendRadius());
            } else {
                writer.movel(poseVarName, acc, spd);
            }
        } else {
            String anchoredWaypointPose = parent.getAnchorWaypointNode().generatePoseScriptCode();
            String fixedWaypointPose = this.generatePoseScriptCode();
            String poseTransVarName = "pose_trans(" + poseVarName + ", pose_trans(pose_inv(" + anchoredWaypointPose + ")," + fixedWaypointPose + "))";
            if (!this.waypointNode.isStopPoint() && this.waypointNode.getBlendRadius() > 0.0) {
                writer.movel(poseTransVarName, acc, spd, "" + this.waypointNode.getBlendRadius());
            } else {
                writer.movel(poseTransVarName, acc, spd);
            }
        }
        this.waypointNode.scriptEnd(writer);
        return writer;
    }

    public abstract String generatePoseScriptCode();
}

