/*
 * Decompiled with CFR 0.152.
 */
package gui.program.preamble;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import gui.program.direction.MoveDirectionNode;
import gui.program.preamble.ProgramNodePreambleScriptGenerator;

public class MoveDirectionNodePreambleScriptGenerator
implements ProgramNodePreambleScriptGenerator<MoveDirectionNode> {
    @Override
    public boolean canGenerate(AbstractProgramNode node) {
        return node instanceof MoveDirectionNode;
    }

    @Override
    public ScriptWriter setup(ScriptWriter writer) {
        MoveDirectionNodePreambleScriptGenerator.generatePreambleScript(writer);
        return writer;
    }

    @Override
    public ScriptWriter generatePreambleScript(ScriptWriter writer, MoveDirectionNode node) {
        return writer;
    }

    @Override
    public ScriptWriter cleanup(ScriptWriter writer) {
        return writer;
    }

    public static ScriptWriter generatePreambleScript(ScriptWriter writer) {
        writer.defineFunctionWithParameters("calculate_point_to_move_towards", new String[]{"feature", "direction", "position_distance"});
        writer.localVariable("posDir", "[direction[0], direction[1], direction[2]]");
        writer.ifCondition("norm(posDir) < 1e-6");
        writer.writeScript("return get_target_waypoint()");
        writer.end();
        writer.localVariable("direction_vector_normalized", "normalize(posDir)");
        writer.localVariable("displacement_pose", "p[direction_vector_normalized[0] * position_distance,direction_vector_normalized[1] * position_distance,direction_vector_normalized[2] * position_distance,0,0,0]");
        writer.localVariable("wanted_displacement_in_base_frame", "pose_sub(pose_trans(feature, displacement_pose), feature)");
        writer.writeScript("return pose_add(get_target_waypoint(), wanted_displacement_in_base_frame)");
        writer.end();
        return writer;
    }
}

