/*
 * Decompiled with CFR 0.152.
 */
package gui.program.services;

import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.installation.domain.UnderwayInstallationProvider;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.scriptconverter.ScriptConverter;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.reference.Reference;
import com.ur.swing.expression.Expression;
import com.ur.swing.expression.ExpressionNode;
import com.ur.view.domain.program.expression.ExpressionGeomFeatureNode;
import com.ur.view.variables.ReferenceToInstallation;
import com.ur.view.variables.core.Variable;
import gui.program.position.WaypointNode;
import gui.program.services.ProgramReferenceService;
import gui.program.services.VarNamingStrategy;
import gui.program.services.geom.GeomFeatureReferenceBase;

@ReferenceToInstallation
public class GeomFeatureVariable
extends GeomFeatureReferenceBase
implements Variable,
Reference<String, GeomFeature> {
    private final transient ProgramReferenceService programReferenceService;
    private final VarNamingStrategy varNamingStrategy;
    private transient Expression initExpression;

    public GeomFeatureVariable(String referencedName, NamingService namingService, ProgramReferenceService programReferenceService, VarNamingStrategy varNamingStrategy, UnderwayInstallationProvider underwayInstallationProvider) {
        super(referencedName, namingService, underwayInstallationProvider);
        this.programReferenceService = programReferenceService;
        this.varNamingStrategy = varNamingStrategy;
    }

    public String getName() {
        GeomFeature feature = this.dereference();
        if (feature != null) {
            return feature.getName();
        }
        return this.getKey();
    }

    public void setName(String newName) {
        GeomFeature feature = this.dereference();
        if (feature != null) {
            feature.setName(newName);
        }
    }

    public boolean sameAs(NamedEntity entityToCompareTo) {
        if (this == entityToCompareTo) {
            return true;
        }
        if (!this.getName().equals(entityToCompareTo.getName())) {
            return false;
        }
        if (entityToCompareTo instanceof WaypointNode) {
            WaypointNode wn = (WaypointNode)entityToCompareTo;
            if (wn.getPositionNodeType() == PositionNodeType.VARIABLE && this.sameAs(wn.getInternalVariable())) {
                return true;
            }
        } else {
            if (entityToCompareTo instanceof GeomFeature) {
                GeomFeature feature = (GeomFeature)entityToCompareTo;
                return feature == this.dereference();
            }
            if (entityToCompareTo instanceof GeomFeatureVariable) {
                GeomFeatureVariable otherVar = (GeomFeatureVariable)entityToCompareTo;
                if (this.getKey().equals(otherVar.getKey())) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String getScriptName() {
        return ScriptConverter.toScriptCode((String)super.toString(), (boolean)false);
    }

    @Override
    public boolean prefersPersistentValue() {
        return false;
    }

    @Override
    public void setPrefersPersistentValue(boolean persistencePreference) {
    }

    @Override
    public boolean hasExpression() {
        return true;
    }

    @Override
    public Expression getExpression() {
        if (this.initExpression == null) {
            this.initExpression = new Expression();
            ExpressionGeomFeatureNode expressionFeature = new ExpressionGeomFeatureNode();
            expressionFeature.initialSetFeatureReference(this.programReferenceService.getGeomFeatureReference(this.getKey()));
            this.initExpression.getExpression().insertElementAt((ExpressionNode)expressionFeature, 0);
        }
        return this.initExpression;
    }

    @Override
    public boolean isUndefined() {
        boolean result = true;
        GeomFeature geomFeature = this.dereference();
        if (geomFeature != null) {
            result = !geomFeature.isVariable();
        }
        return result;
    }

    @Override
    public boolean isFavourite() {
        return false;
    }

    @Override
    public void setIsFavourite(boolean isFavourite) {
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public void setDescription(String description) {
    }

    @Override
    public String toString() {
        return this.varNamingStrategy.getFeatureName(super.toString());
    }

    public String getDisplayName() {
        return this.getName();
    }

    public boolean isRegistered() {
        return !this.isUndefined();
    }
}

