/*
 * Decompiled with CFR 0.152.
 */
package gui.program.services;

import com.ur.polyscope.visualizer.programvisualization.VisualizerMotionData;
import com.ur.polyscope.visualizer.programvisualization.VisualizerPositionNode;
import com.ur.util.CollectionUtils;
import com.ur.util.logging.Log;
import gui.program.Blend;
import gui.program.Motion;
import gui.program.MotionDefiningNode;
import gui.program.ProgramRootNode;
import gui.program.position.PositionNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Singleton;

@Singleton
public class MotionData
implements VisualizerMotionData {
    private Map<MotionDefiningNode, List<Motion>> motionsMap = new HashMap<MotionDefiningNode, List<Motion>>();
    private Map<PositionNode, List<Motion>> nextMotion = new HashMap<PositionNode, List<Motion>>();
    private Map<PositionNode, List<Motion>> prevMotion = new HashMap<PositionNode, List<Motion>>();
    private Map<PositionNode, List<Blend>> blends = new HashMap<PositionNode, List<Blend>>();

    public Set<Motion> getPreviousMotions(VisualizerPositionNode visualizerPositionNode) {
        List<Motion> motions = this.prevMotion.get(visualizerPositionNode);
        if (motions != null) {
            return new HashSet<Motion>(motions);
        }
        return new HashSet<Motion>();
    }

    public Set<Motion> getNextMotions(VisualizerPositionNode visualizerPositionNode) {
        List<Motion> motions = this.nextMotion.get(visualizerPositionNode);
        if (motions != null) {
            return new HashSet<Motion>(motions);
        }
        return new HashSet<Motion>();
    }

    public Set<Blend> getBlends(VisualizerPositionNode visualizerPositionNode) {
        List<Blend> blends = this.blends.get(visualizerPositionNode);
        if (blends != null) {
            return new HashSet<Blend>(blends);
        }
        return new HashSet<Blend>();
    }

    public Set<Motion> getMotions(com.ur.polyscope.program.nodes.MotionDefiningNode motionDefiningNode) {
        List<Motion> motions = this.motionsMap.get(motionDefiningNode);
        if (motions != null) {
            return new HashSet<Motion>(motions);
        }
        return new HashSet<Motion>();
    }

    private List<PositionNode> getPreorderedMotionDefiningNodes(ProgramRootNode programRootNode) {
        return CollectionUtils.filter((Enumeration)programRootNode.preorderEnumeration(), PositionNode.class);
    }

    public void updateMotion(ProgramRootNode programRootNode) {
        this.clear();
        for (PositionNode each : this.getPreorderedMotionDefiningNodes(programRootNode)) {
            try {
                this.setMotions(each);
            }
            catch (Exception e) {
                Log.error((String)"", (Throwable)e);
            }
        }
    }

    private void clear() {
        this.nextMotion.clear();
        this.prevMotion.clear();
        this.blends.clear();
        this.motionsMap.clear();
    }

    private void setMotions(PositionNode p) {
        Set nextPosNodes = p.getNextPositionNodes(PositionNode.class);
        for (PositionNode each : nextPosNodes) {
            if (p.equals(each)) continue;
            Motion motion = this.createMotion(p, each);
            motion.updatePathData(this);
            this.blendToPreviousMotion(motion);
            this.blendToNextMotion(motion);
        }
    }

    private void blendToPreviousMotion(Motion nextMotion) {
        PositionNode fromPositionNode = nextMotion.getFromPositionNode();
        if (fromPositionNode.hasBlendRadius() && !fromPositionNode.isStopPoint()) {
            for (Motion each : this.getPreviousMotions(fromPositionNode)) {
                Blend newBlend = new Blend(each, nextMotion);
                newBlend.updateBlendPathData(this);
                this.addBlend(fromPositionNode, newBlend);
            }
        }
    }

    private void addBlend(PositionNode positionNode, Blend blend) {
        List<Blend> bl = this.blends.get(positionNode);
        if (bl == null) {
            bl = new ArrayList<Blend>();
        }
        bl.add(blend);
        this.blends.put(positionNode, bl);
    }

    private void blendToNextMotion(Motion m) {
        PositionNode toPositionNode = m.getToPositionNode();
        if (toPositionNode.hasBlendRadius() && !toPositionNode.isStopPoint()) {
            for (Motion nm : this.getNextMotions(toPositionNode)) {
                Blend b = new Blend(m, nm);
                b.updateBlendPathData(this);
                this.addBlend(toPositionNode, b);
            }
        }
    }

    private Motion createMotion(PositionNode from, PositionNode to) {
        Motion m = new Motion(from, to);
        this.putMotionDefiningNode(m);
        this.putNextMotion(from, m);
        this.putPrevMotion(to, m);
        return m;
    }

    private void putMotionDefiningNode(Motion m) {
        MotionDefiningNode motionDefiningNode = m.getMotionDefiningNode();
        List<Motion> motions = this.motionsMap.get(motionDefiningNode);
        if (motions == null) {
            motions = new ArrayList<Motion>();
            motions.add(m);
            this.motionsMap.put(motionDefiningNode, motions);
        } else {
            motions.add(m);
        }
    }

    private void putNextMotion(PositionNode pos, Motion m) {
        List<Motion> motions = this.nextMotion.get(pos);
        if (motions == null) {
            motions = new CopyOnWriteArrayList<Motion>();
            motions.add(m);
            this.nextMotion.put(pos, motions);
        } else {
            motions.add(m);
        }
    }

    private void putPrevMotion(PositionNode pos, Motion m) {
        List<Motion> motions = this.prevMotion.get(pos);
        if (motions == null) {
            motions = new CopyOnWriteArrayList<Motion>();
            motions.add(m);
            this.prevMotion.put(pos, motions);
        } else {
            motions.add(m);
        }
    }
}

