/*
 * Decompiled with CFR 0.152.
 */
package gui.program.services;

import com.ur.lang.Defense;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.program.ProgramLoadingContext;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.util.event.EventManager;
import com.ur.util.logging.Log;
import com.ur.view.hmc.HMC;
import gui.installation.services.ProgramLookupService;
import gui.program.ProgramRootNode;
import gui.program.services.MotionDataWorker;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class MotionDataUpdateService {
    private final BlockingQueue<ProgramRootNode> inboxSlotOfOne = new LinkedBlockingQueue<ProgramRootNode>(1);
    private final AtomicBoolean canUpdateMotionData = new AtomicBoolean(true);

    @Inject
    public MotionDataUpdateService(EventManager eventManager, final ProgramLoadingContext programLoadingContext, final ProgramLookupService programLookupService, final MotionDataWorker motionDataWorker) {
        eventManager.addStrongListener(InstallationStateListener.class, (Object)new InstallationStateListener.Template(){

            public void installationModified() {
                HMC.clearHMC();
                ProgramRootNode program = programLookupService.getProgramRootNode();
                if (program != null) {
                    MotionDataUpdateService.this.requestUpdate(program);
                    HMC.clearHMC();
                    MotionDataUpdateService.this.requestUpdate(program);
                }
            }
        });
        eventManager.addStrongListener(ProgramEventListener.class, (Object)new ProgramEventListener.Template(){

            public void onPreNewProgram() {
                if (programLoadingContext.isLoading()) {
                    MotionDataUpdateService.this.canUpdateMotionData.set(false);
                } else {
                    MotionDataUpdateService.this.canUpdateMotionData.set(true);
                }
            }

            public void onPostPostNewProgram(com.ur.polyscope.program.ProgramRootNode programRootNode) {
                MotionDataUpdateService.this.canUpdateMotionData.set(true);
                MotionDataUpdateService.this.requestUpdate((ProgramRootNode)programRootNode);
            }
        });
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            ProgramRootNode toUpdate = (ProgramRootNode)MotionDataUpdateService.this.inboxSlotOfOne.take();
                            motionDataWorker.work(toUpdate);
                        }
                    }
                    catch (Exception e) {
                        Log.error((String)"MotionDataUpdateService work!", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        });
        thread.setPriority(1);
        thread.setDaemon(true);
        thread.setName("MotionDataUpdate - Service");
        thread.start();
    }

    public void requestUpdate(ProgramRootNode programRootNodeToUpdate) {
        Defense.notNull((Object)programRootNodeToUpdate);
        if (this.canUpdateMotionData.get()) {
            this.inboxSlotOfOne.offer(programRootNodeToUpdate);
        }
    }
}

