/*
 * Decompiled with CFR 0.152.
 */
package gui.program.services;

import com.ur.lang.Defense;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.util.CollectionUtils;
import com.ur.util.event.EventManager;
import com.ur.util.event.NotificationStrategy;
import gui.polyscope.BlendChangeListener;
import gui.program.ProgramRootNode;
import gui.program.services.MotionData;
import java.util.Enumeration;
import java.util.List;
import javax.inject.Inject;

public class MotionDataWorker {
    private final EventManager eventManager;
    private final MotionData motionData;

    @Inject
    MotionDataWorker(EventManager eventManager, MotionData motionData) {
        this.eventManager = eventManager;
        this.motionData = motionData;
    }

    public void work(ProgramRootNode toUpdate) {
        Defense.notNull((Object)toUpdate);
        this.clearExecutionFlowGraph(toUpdate);
        this.setExecutionFlowGraph(toUpdate);
        this.updateMotions(toUpdate);
        this.updateBlends();
    }

    private void setExecutionFlowGraph(ProgramRootNode programRootNode) {
        for (AbstractProgramNode each : this.getPreorderedProgramNodes(programRootNode)) {
            each.setExecutionFlowGraph();
        }
    }

    private void clearExecutionFlowGraph(ProgramRootNode programRootNode) {
        for (AbstractProgramNode each : this.getPreorderedProgramNodes(programRootNode)) {
            each.clearExecutionFlowGraph();
        }
    }

    private void updateBlends() {
        this.eventManager.fireEvent(BlendChangeListener.class, (NotificationStrategy)new NotificationStrategy<BlendChangeListener>(){

            public void notify(BlendChangeListener blendChangeListener) {
                blendChangeListener.updateBlends();
            }
        });
    }

    private void updateMotions(ProgramRootNode programRootNode) {
        this.motionData.updateMotion(programRootNode);
    }

    private List<AbstractProgramNode> getPreorderedProgramNodes(ProgramRootNode programRootNode) {
        return CollectionUtils.filter((Enumeration)programRootNode.preorderEnumeration(), AbstractProgramNode.class);
    }
}

