/*
 * Decompiled with CFR 0.152.
 */
package gui.program.services;

import com.ur.polyscope.internaltcp.domain.TCPReference;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.program.Program;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.tcp.TCP;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.reference.Reference;
import com.ur.reference.ReferenceHandlingStrategy;
import com.ur.reference.ReferenceOwner;
import com.ur.reference.ReferenceServiceImpl;
import com.ur.util.event.EventNotificationService;
import com.ur.view.variables.InstallationVariableReference;
import com.ur.view.variables.core.InstallationVariable;
import gui.installation.services.ProgramLookupService;
import gui.polyscope.program.ProgramTreeChangeObserver;
import gui.program.ProgramRootNode;
import gui.program.services.GeomFeatureVariable;
import gui.program.services.ProgramReferenceService;
import gui.program.services.geom.GeomFeatureReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Program
public class ProgramReferenceServiceImpl
extends ReferenceServiceImpl
implements ProgramReferenceService,
ProgramTreeChangeObserver {
    private final ProgramLookupService programLookupService;

    @Inject
    public ProgramReferenceServiceImpl(ProgramLookupService programLookupService) {
        this.programLookupService = programLookupService;
        EventNotificationService.register((Object)this, ProgramEventListener.class, (Object)((Object)new UpdateReferencesOnProgramEvent()));
        EventNotificationService.register((Object)this, ProgramTreeChangeObserver.class, (Object)this);
    }

    @Override
    public GeomFeatureReference getGeomFeatureReference(String featureName) {
        return (GeomFeatureReference)this.getReference(GeomFeatureReference.class, featureName);
    }

    @Override
    public GeomFeatureReference getGeomFeatureReference(GeomFeature feature) {
        return (GeomFeatureReference)this.getReferenceTo(GeomFeatureReference.class, feature);
    }

    @Override
    public GeomFeatureVariable getGeomFeatureVariable(String featureName) {
        return (GeomFeatureVariable)this.getReference(GeomFeatureVariable.class, featureName);
    }

    @Override
    public GeomFeatureVariable getGeomFeatureVariable(GeomFeature feature) {
        return (GeomFeatureVariable)this.getReferenceTo(GeomFeatureVariable.class, feature);
    }

    @Override
    public InstallationVariableReference getInstallationVariableReference(String installationVariableName) {
        return (InstallationVariableReference)this.getReference(InstallationVariableReference.class, installationVariableName);
    }

    @Override
    public InstallationVariableReference getInstallationVariableReference(InstallationVariable installationVariable) {
        return (InstallationVariableReference)this.getReferenceTo(InstallationVariableReference.class, installationVariable);
    }

    @Override
    public PinReference getPinReference(String forName) {
        return (PinReference)this.getReference(PinReference.class, forName);
    }

    @Override
    public PinReference getPinReference(Pin<?> pin) {
        return (PinReference)this.getStrategy(PinReference.class).getReferenceTo(pin);
    }

    @Override
    public TCPReference getTCPReference(String tcpName) {
        return (TCPReference)this.getReference(TCPReference.class, tcpName);
    }

    @Override
    public TCPReference getTCPReference(TCP tcp) {
        return (TCPReference)this.getReferenceTo(TCPReference.class, tcp);
    }

    protected Collection<Object> getReferences(ReferenceOwner owner) {
        ArrayList result = new ArrayList();
        return owner.getReferenceEntities(result);
    }

    public <K, T, R extends Reference<K, T>> ReferenceHandlingStrategy<K, T, R> getStrategyFor(Class<R> referencedType) {
        return super.getStrategy(referencedType);
    }

    @Override
    public void handleProgramTreeEvent(ProgramTreeChangeObserver.ProgramTreeEvent event) {
        switch (event.type) {
            case NODE_INSERTED: {
                Enumeration descendants = event.node.preorderEnumeration();
                while (descendants.hasMoreElements()) {
                    Object each = descendants.nextElement();
                    if (!(each instanceof AbstractProgramNode)) continue;
                    AbstractProgramNode node = (AbstractProgramNode)each;
                    ArrayList collection = new ArrayList();
                    this.setOwnedReferences((ReferenceOwner)node, node.getReferenceEntities(collection));
                }
                break;
            }
            case NODE_REMOVED: {
                if (!event.node.isUnregisterProgramReferencesOnDelete()) break;
                Enumeration descendants = event.node.preorderEnumeration();
                while (descendants.hasMoreElements()) {
                    Object each = descendants.nextElement();
                    if (!(each instanceof AbstractProgramNode)) continue;
                    this.setOwnedReferences((ReferenceOwner)((AbstractProgramNode)each), Collections.emptyList());
                }
                break;
            }
        }
    }

    private class UpdateReferencesOnProgramEvent
    extends ProgramEventListener.Template {
        private UpdateReferencesOnProgramEvent() {
        }

        public void onPreNewProgram() {
            ProgramReferenceServiceImpl.this.clear();
        }

        public void onPostNewProgram() {
            this.setOwnedReferences();
        }

        public void onLoadProgramFailed() {
            this.setOwnedReferences();
        }

        private void setOwnedReferences() {
            ProgramRootNode rootNode = ProgramReferenceServiceImpl.this.programLookupService.getProgramRootNode();
            if (rootNode != null) {
                Enumeration nodes = rootNode.depthFirstEnumeration();
                while (nodes.hasMoreElements()) {
                    Object element = nodes.nextElement();
                    if (!(element instanceof AbstractProgramNode)) continue;
                    AbstractProgramNode node = (AbstractProgramNode)element;
                    ArrayList collection = new ArrayList();
                    ProgramReferenceServiceImpl.this.setOwnedReferences((ReferenceOwner)node, node.getReferenceEntities(collection));
                }
            }
        }

        public void onPreNewInstallation() {
            ProgramReferenceServiceImpl.this.allReferencesChanged();
        }
    }
}

