/*
 * Decompiled with CFR 0.152.
 */
package gui.program.services;

import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.reference.Reference;
import com.ur.reference.ReferenceHandlingStrategyImpl;
import com.ur.reference.ReferenceOwner;
import com.ur.util.event.EventNotificationService;
import com.ur.view.variables.core.ProgramVariable;
import gui.program.EntityFactory;
import gui.program.ProgramVariableObserver;
import java.util.Collection;
import javax.inject.Inject;

public class ProgramVariableHandlingStrategy
extends ReferenceHandlingStrategyImpl<String, ProgramVariable, ProgramVariable> {
    private final NamingService namingService;
    private final EntityFactory entityFactory;

    @Inject
    public ProgramVariableHandlingStrategy(NamingService namingService, EntityFactory entityFactory) {
        this.namingService = namingService;
        this.entityFactory = entityFactory;
        EventNotificationService.register((Object)((Object)this), ProgramVariableObserver.class, (Object)new ProgramVariableOwnerUpdater());
    }

    protected ProgramVariable createReference(String key) {
        return this.entityFactory.createVariable(key);
    }

    protected String getKeyFor(ProgramVariable target) {
        return target.getKey();
    }

    protected void referenceAdded(ProgramVariable variable) {
        this.namingService.registerNamedEntity((NamedEntity)variable);
    }

    protected void referenceRemoved(ProgramVariable variable) {
        this.namingService.deregisterNamedEntity((NamedEntity)variable);
    }

    public void keyChange(String oldKey, String newKey) {
        ProgramVariable referenceToMove = (ProgramVariable)this.references.get(oldKey);
        if (referenceToMove != null) {
            this.references.remove(oldKey);
            this.references.put(newKey, referenceToMove);
            Collection owners = (Collection)this.ownerMap.remove(oldKey);
            this.ownerMap.put(newKey, owners);
            if (owners != null) {
                for (ReferenceOwner each : owners) {
                    each.referenceStateChanged((Reference)referenceToMove);
                }
            }
        }
    }

    private class ProgramVariableOwnerUpdater
    implements ProgramVariableObserver {
        private ProgramVariableOwnerUpdater() {
        }

        public void nameChanged(ProgramVariable entity, String oldName, String newName) {
            ProgramVariableHandlingStrategy.this.keyChange(oldName, newName);
        }
    }
}

