/*
 * Decompiled with CFR 0.152.
 */
package gui.program.services.geom;

import com.ur.polyscope.geomfeature.FeatureInternal;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.geomfeature.SpatialFeatureReference;
import com.ur.polyscope.geomfeature.owner.FeatureReferenceOwnerManager;
import gui.program.services.geom.FeaturePermanentReferenceOwner;
import gui.program.services.geom.GeomFeatureReference;
import gui.program.services.geom.GeomFeatureReferenceHandlingStrategy;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class FeatureReferenceOwnerManagerImpl
implements FeatureReferenceOwnerManager {
    private final Provider<GeomFeatureReferenceHandlingStrategy> referenceHandlingStrategyProvider;

    @Inject
    public FeatureReferenceOwnerManagerImpl(Provider<GeomFeatureReferenceHandlingStrategy> referenceHandlingStrategyProvider) {
        this.referenceHandlingStrategyProvider = referenceHandlingStrategyProvider;
    }

    public <T extends SpatialFeature> void registerReferenceOwner(FeatureInternal<T> owner, SpatialFeatureReference<T> reference) {
        if (!(reference instanceof GeomFeatureReference)) {
            return;
        }
        GeomFeatureReferenceHandlingStrategy strategy = (GeomFeatureReferenceHandlingStrategy)this.referenceHandlingStrategyProvider.get();
        strategy.removeInvalidReferences();
        FeaturePermanentReferenceOwner<T> permOwner = new FeaturePermanentReferenceOwner<T>(owner, reference.getKey());
        ArrayList<GeomFeatureReference> arrayList = new ArrayList<GeomFeatureReference>();
        arrayList.add((GeomFeatureReference)reference);
        strategy.setOwnedReferences(permOwner, arrayList);
    }
}

