/*
 * Decompiled with CFR 0.152.
 */
package gui.program.services.geom;

import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.geomfeature.BaseSpatialFeature;
import com.ur.polyscope.geomfeature.FeatureCallback;
import com.ur.polyscope.geomfeature.FeatureService;
import com.ur.polyscope.geomfeature.FinalizableFeature;
import com.ur.polyscope.geomfeature.PoseSpatialFeature;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.geomfeature.SpatialFeatureReference;
import com.ur.polyscope.geomfeature.ToolSpatialFeature;
import com.ur.polyscope.installation.InstallationModifier;
import com.ur.polyscope.installation.urcap.contributor.ContributorInfo;
import com.ur.polyscope.valueobjects.value.ToolPosition;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import gui.geom.GeomFeatureFactory;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNodeContributed;
import gui.polyscope.setup.treenodes.geom.SetupFeatureContainerNode;
import gui.program.services.DelayedCreation;
import gui.program.services.ProgramReferenceService;
import gui.program.services.geom.SetupFeatureContainerNodeProvider;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class FeatureServiceImpl
extends DelayedCreation
implements FeatureService {
    private ProgramReferenceService programReferenceService;
    private SetupFeatureContainerNodeProvider containerNodeProvider;
    private Provider<NamingService> namingServiceProvider;
    private GeomFeatureFactory geomFeatureFactory;
    private final InstallationModifier installationModifier;
    private final ArrayList<DelayedFeature> delayedFeatures = new ArrayList();
    private boolean isFeatureRemoveAndUpdateAllowed;

    @Inject
    public FeatureServiceImpl(ProgramReferenceService programReferenceService, SetupFeatureContainerNodeProvider containerNodeProvider, Provider<NamingService> namingServiceProvider, GeomFeatureFactory geomFeatureFactory, InstallationModifier installationModifier) {
        this.programReferenceService = programReferenceService;
        this.containerNodeProvider = containerNodeProvider;
        this.namingServiceProvider = namingServiceProvider;
        this.geomFeatureFactory = geomFeatureFactory;
        this.installationModifier = installationModifier;
    }

    public SpatialFeatureReference getFeatureVariable(SpatialFeature spatialFeature) {
        return this.programReferenceService.getGeomFeatureVariable((GeomFeature)spatialFeature);
    }

    public SpatialFeatureReference getFeatureReference(SpatialFeature spatialFeature) {
        return this.programReferenceService.getGeomFeatureReference((GeomFeature)spatialFeature);
    }

    public Collection<SpatialFeature> getAllSpatialFeatures() {
        return new ArrayList<GeomFeature>(this.getSetupFeatureContainerNode().getAllGeomNodes());
    }

    private SetupFeatureContainerNode getSetupFeatureContainerNode() {
        return this.containerNodeProvider.getContainer();
    }

    public BaseSpatialFeature getBaseSpatialFeature() {
        return this.getSetupFeatureContainerNode().getBaseViewFeature();
    }

    public ToolSpatialFeature getToolSpatialFeature() {
        return this.getSetupFeatureContainerNode().getToolViewFeature();
    }

    public SpatialFeatureReference getFeatureByName(String name) {
        Object feature = this.getSetupFeatureContainerNode().getFeatureByName(name);
        return feature != null ? this.getFeatureReference((SpatialFeature)feature) : null;
    }

    public SpatialFeatureReference getFeatureByContributionInfo(ContributorInfo contributorInfo) {
        for (SpatialFeature sf : this.getAllSpatialFeatures()) {
            ContributorInfo info;
            if (!(sf instanceof GeomPoseNodeContributed) || !(info = ((GeomPoseNodeContributed)sf).getContributorInfo()).getOwnerId().equals(contributorInfo.getOwnerId()) || !info.getId().equals(contributorInfo.getId())) continue;
            return this.getFeatureReference(sf);
        }
        return null;
    }

    public SpatialFeature getDelayedFeatureByContributionInfo(ContributorInfo contributorInfo) {
        for (DelayedFeature delayedFeature : this.delayedFeatures) {
            ContributorInfo info = delayedFeature.getContributorInfo();
            if (!info.getOwnerId().equals(contributorInfo.getOwnerId()) || !info.getId().equals(contributorInfo.getId())) continue;
            return delayedFeature;
        }
        return null;
    }

    public SpatialFeature createFeature(String suggestedName, ToolPosition pose, ContributorInfo contributorInfo) {
        if (!this.isDelayed()) {
            return this.addRealFeature(suggestedName, pose, contributorInfo);
        }
        DelayedFeature delayedFeature = new DelayedFeature(suggestedName, pose, contributorInfo);
        this.delayedFeatures.add(delayedFeature);
        return delayedFeature;
    }

    public boolean isFeatureRemoveAndUpdateAllowed() {
        return this.isFeatureRemoveAndUpdateAllowed;
    }

    public void setFeatureRemoveAndUpdateAllowed(boolean allowed) {
        this.isFeatureRemoveAndUpdateAllowed = allowed;
    }

    public void deregisterFeature(SpatialFeature feature) {
        if (feature instanceof GeomPoseNodeContributed) {
            GeomPoseNodeContributed contributePoseNode = (GeomPoseNodeContributed)feature;
            ((NamingService)this.namingServiceProvider.get()).deregisterNamedEntity((NamedEntity)contributePoseNode);
            this.getSetupFeatureContainerNode().removeGeomFeature((GeomFeature)contributePoseNode);
        }
    }

    public void removeDelayedFeature(SpatialFeature delayedFeature) {
        this.delayedFeatures.remove(delayedFeature);
        this.installationModifier.makeDirty();
    }

    @Override
    protected void startDelayCreation() {
        this.delayedFeatures.clear();
    }

    @Override
    protected void stopDelayCreation() {
        this.processDelayedFeatures();
    }

    @Override
    protected void delayCreationFailed() {
        this.delayedFeatures.clear();
    }

    private void processDelayedFeatures() {
        for (DelayedFeature delayedFeature : this.delayedFeatures) {
            GeomPoseNode geomPoseNode = this.addRealFeature(delayedFeature.suggestedName, delayedFeature.pose, delayedFeature.info);
            delayedFeature.getFinalizeCallback().onFinalize((SpatialFeature)geomPoseNode);
            this.installationModifier.makeDirty();
        }
        this.delayedFeatures.clear();
    }

    private GeomPoseNode addRealFeature(String suggestedName, ToolPosition pose, ContributorInfo contributorInfo) {
        String uniqueName = ((NamingService)this.namingServiceProvider.get()).makeUniqueName(GeomPoseNode.class, suggestedName);
        GeomPoseNode geomPoseNode = this.geomFeatureFactory.createPoseNode(uniqueName, pose, null, contributorInfo);
        geomPoseNode.setShowAxes(true);
        boolean b = this.getSetupFeatureContainerNode().insertGeomNode(geomPoseNode);
        return b ? geomPoseNode : null;
    }

    public boolean isContributed(SpatialFeature spatialFeature) {
        return spatialFeature instanceof GeomPoseNodeContributed;
    }

    private static class DelayedFeature
    implements PoseSpatialFeature,
    FinalizableFeature {
        private final String suggestedName;
        private ToolPosition pose;
        private final ContributorInfo info;
        private FeatureCallback callback;

        public DelayedFeature(String suggestedName, ToolPosition pose, ContributorInfo info) {
            this.suggestedName = suggestedName;
            this.pose = pose;
            this.info = info;
        }

        public void setFinalizeCallback(FeatureCallback callback) {
            this.callback = callback;
        }

        public FeatureCallback getFinalizeCallback() {
            return this.callback;
        }

        public boolean isVariable() {
            return true;
        }

        public boolean isJoggableEnabled() {
            return true;
        }

        public String getName() {
            return this.suggestedName;
        }

        public boolean isDefined() {
            return true;
        }

        public ToolPosition getSpatialPose() {
            return this.pose;
        }

        public boolean isFirstLevelFeature() {
            return true;
        }

        public ContributorInfo getContributorInfo() {
            return this.info;
        }

        public void setSpatialPose(ToolPosition pose) {
            this.pose = pose;
        }
    }
}

