/*
 * Decompiled with CFR 0.152.
 */
package gui.program.services.geom;

import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.geomfeature.SpatialFeatureReference;
import com.ur.polyscope.installation.domain.UnderwayInstallationProvider;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.reference.NameReference;
import com.ur.util.logging.Log;
import gui.polyscope.setup.treenodes.geom.SetupFeatureContainerNode;
import gui.tools.LanguagePack;
import java.util.List;

public abstract class GeomFeatureReferenceBase
extends NameReference<GeomFeature>
implements SpatialFeatureReference {
    private final transient NamingService namingService;
    private UnderwayInstallationProvider underwayInstallationProvider;

    public GeomFeatureReferenceBase(String referencedName, NamingService namingService, UnderwayInstallationProvider underwayInstallationProvider) {
        super(referencedName);
        this.namingService = namingService;
        this.underwayInstallationProvider = underwayInstallationProvider;
    }

    public GeomFeature dereference() {
        List entities = this.namingService.getEntitiesWithName(this.getKey());
        for (NamedEntity each : entities) {
            if (!(each instanceof GeomFeature)) continue;
            return (GeomFeature)each;
        }
        return null;
    }

    public String toString() {
        GeomFeature referencedGeomFeature = this.dereference();
        if (referencedGeomFeature != null) {
            return referencedGeomFeature.toString();
        }
        String referencedName = this.getKey();
        if (referencedName != null) {
            return GeomFeatureReferenceBase.getFeatureClassName(referencedName);
        }
        Log.error((String)"The name of the referenced feature is null", (Throwable)new NullPointerException());
        return "FEATURE ERROR";
    }

    public static String getFeatureClassName(String referencedName) {
        if (referencedName != null && referencedName.matches("Joint_[06]_name")) {
            referencedName = LanguagePack.getTextResource().get(referencedName);
        }
        return referencedName;
    }

    public SpatialFeature dereferenceInUnderwayInstallation() {
        return ((SetupFeatureContainerNode)this.underwayInstallationProvider.getUnderwayInstallation().getComponent(SetupFeatureContainerNode.class)).getFeatureByName(this.getKey());
    }
}

