/*
 * Decompiled with CFR 0.152.
 */
package gui.program.services.geom;

import com.google.common.collect.Iterables;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.polyscope.visualizer.geomfeature.GeomFeatureObserver;
import com.ur.reference.Reference;
import com.ur.reference.ReferenceHandlingStrategy;
import com.ur.reference.ReferenceOwner;
import com.ur.util.event.EventNotificationService;
import gui.program.services.geom.FeatureOwnerUpdater;
import gui.program.services.geom.FeaturePermanentReferenceOwner;
import gui.program.services.geom.GeomFeatureReference;
import gui.program.services.geom.GeomFeatureReferenceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GeomFeatureReferenceHandlingStrategy
implements ReferenceHandlingStrategy<String, GeomFeature, GeomFeatureReference> {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    Map<String, GeomFeatureReference> references = new HashMap<String, GeomFeatureReference>();
    Map<String, Collection<ReferenceOwner>> ownerMap = new HashMap<String, Collection<ReferenceOwner>>();
    private GeomFeatureReferenceFactory factory;

    @Inject
    public GeomFeatureReferenceHandlingStrategy(GeomFeatureReferenceFactory factory) {
        this.factory = factory;
        EventNotificationService.register((Object)this, GeomFeatureObserver.class, new FeatureOwnerUpdater<GeomFeatureReference>(this));
    }

    public GeomFeatureReference getReferenceTo(GeomFeature target) {
        return this.getReference(target.getName());
    }

    public GeomFeatureReference getReference(String key) {
        this.writeLock.lock();
        try {
            if (!this.references.containsKey(key)) {
                this.references.put(key, this.factory.createReference(key));
            }
            GeomFeatureReference geomFeatureReference = this.references.get(key);
            return geomFeatureReference;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setOwnedReferences(ReferenceOwner owner, Iterable<GeomFeatureReference> ownedReferences) {
        this.writeLock.lock();
        try {
            Collection<String> newKeys = this.extractKeysFromReferences(ownedReferences);
            this.removeEmptyReferences(owner, newKeys);
            this.updateReferenceOwners(owner, ownedReferences);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void removeEmptyReferences(ReferenceOwner owner, Collection<String> newKeys) {
        this.writeLock.lock();
        try {
            for (String each : new ArrayList<String>(this.ownerMap.keySet())) {
                Collection<ReferenceOwner> owners = this.ownerMap.get(each);
                if (!owners.contains(owner) || newKeys.contains(each)) continue;
                owners.remove(owner);
                if (!owners.isEmpty()) continue;
                this.ownerMap.remove(each);
                this.references.remove(each);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateReferenceOwners(ReferenceOwner owner, Iterable<GeomFeatureReference> ownedReferences) {
        this.writeLock.lock();
        try {
            for (GeomFeatureReference each : ownedReferences) {
                GeomFeatureReference original;
                String eachKey = each.getKey();
                Collection<ReferenceOwner> owners = this.ownerMap.get(eachKey);
                if (owners == null) {
                    owners = new ArrayList<ReferenceOwner>();
                    this.ownerMap.put(eachKey, owners);
                }
                if (!owners.contains(owner)) {
                    owners.add(owner);
                }
                if ((original = this.references.get(eachKey)) == each) continue;
                if (original != null) {
                    this.fireSubstituteReference(original, each);
                }
                this.references.put(eachKey, each);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Collection<String> extractKeysFromReferences(Iterable<GeomFeatureReference> ownedReferences) {
        this.readLock.lock();
        try {
            ArrayList<String> newKeys = new ArrayList<String>();
            for (GeomFeatureReference each : ownedReferences) {
                newKeys.add(each.getKey());
            }
            ArrayList<String> arrayList = newKeys;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void clear() {
        this.writeLock.lock();
        try {
            ArrayList<FeaturePermanentReferenceOwner<?>> permanentOwners = this.extractPermanentOwners();
            this.references.clear();
            this.ownerMap.clear();
            for (FeaturePermanentReferenceOwner<?> owner : permanentOwners) {
                GeomFeatureReference newRef = this.factory.createReference(owner.getKey());
                ArrayList<GeomFeatureReference> list = new ArrayList<GeomFeatureReference>();
                list.add(newRef);
                this.setOwnedReferences(owner, list);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeInvalidReferences() {
        this.writeLock.lock();
        try {
            HashMap validMap = new HashMap();
            for (String key : this.ownerMap.keySet()) {
                ArrayList<ReferenceOwner> validOwners = new ArrayList<ReferenceOwner>();
                Collection<ReferenceOwner> owners = this.ownerMap.get(key);
                for (ReferenceOwner owner : owners) {
                    if (owner instanceof FeaturePermanentReferenceOwner && !((FeaturePermanentReferenceOwner)owner).hasRealOwner()) continue;
                    validOwners.add(owner);
                }
                validMap.put(key, validOwners);
            }
            this.ownerMap.clear();
            this.ownerMap.putAll(validMap);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private ArrayList<FeaturePermanentReferenceOwner<?>> extractPermanentOwners() {
        this.readLock.lock();
        try {
            ArrayList result = new ArrayList();
            for (Collection<ReferenceOwner> ownersCollection : this.ownerMap.values()) {
                for (FeaturePermanentReferenceOwner owner : Iterables.filter(ownersCollection, FeaturePermanentReferenceOwner.class)) {
                    if (!owner.hasRealOwner()) continue;
                    result.add(owner);
                }
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void keyChange(String oldKey, String newKey) {
        this.writeLock.lock();
        try {
            Collection<ReferenceOwner> oldOwners;
            this.referenceChange(this.getReference(newKey));
            GeomFeatureReference referenceToMove = this.references.get(oldKey);
            if (referenceToMove != null) {
                this.fireSubstituteReference(referenceToMove, this.getReference(newKey));
                this.references.remove(oldKey);
            }
            if ((oldOwners = this.ownerMap.get(oldKey)) != null) {
                Collection<ReferenceOwner> newOwners = this.ownerMap.get(newKey);
                if (newOwners == null) {
                    newOwners = new ArrayList<ReferenceOwner>();
                    this.ownerMap.put(newKey, newOwners);
                }
                for (ReferenceOwner each : oldOwners) {
                    if (newOwners.contains(each)) continue;
                    newOwners.add(each);
                }
                this.ownerMap.remove(oldKey);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void referenceChange(GeomFeatureReference reference) {
        Collection<ReferenceOwner> owners;
        if (reference == null) {
            return;
        }
        this.readLock.lock();
        try {
            owners = this.ownerMap.get(reference.getKey());
        }
        finally {
            this.readLock.unlock();
        }
        if (owners != null) {
            for (ReferenceOwner each : new ArrayList<ReferenceOwner>(owners)) {
                each.referenceStateChanged((Reference)reference);
            }
        }
    }

    public void allReferencesChanged() {
        this.writeLock.lock();
        try {
            for (String each : new ArrayList<String>(this.ownerMap.keySet())) {
                this.referenceChange(this.getReference(each));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void fireSubstituteReference(GeomFeatureReference oldReference, GeomFeatureReference newReference) {
        Collection<ReferenceOwner> owners = this.ownerMap.get(oldReference.getKey());
        if (owners != null) {
            for (ReferenceOwner each : new ArrayList<ReferenceOwner>(owners)) {
                each.substituteReference((Reference)oldReference, (Reference)newReference);
            }
        }
    }
}

