/*
 * Decompiled with CFR 0.152.
 */
package gui.program.setnode;

import com.ur.lang.StringUtils;
import com.ur.polyscope.io.AnalogDomain;
import com.ur.polyscope.pin.AnalogIOPin;
import com.ur.polyscope.pin.GeneralPurposeFloatRegister;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.pin.Register;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.viewfacade.pin.Pin;
import gui.program.setnode.ActionState;
import java.util.Collection;

public class AnalogOutputActionState
implements ActionState {
    public static final int VOLTAGE_DOMAIN = 1;
    public final PinReference pinReference;
    public double value;

    public AnalogOutputActionState(PinReference analogOutput, double analogValue) {
        this.pinReference = analogOutput;
        this.value = this.initAnalogValue(analogValue);
    }

    public AnalogOutputActionState() {
        this(null, 4.0);
    }

    @Override
    public void generateCode(ScriptWriter writer) {
        double computedValue = this.value;
        if (!(this.pinReference.dereference() instanceof GeneralPurposeFloatRegister)) {
            computedValue = this.getAnalogOutputDomain() == AnalogDomain.VOLTAGE.asId() ? this.value / 10.0 : (this.value - 4.0) / 16.0;
        }
        this.getGeneratedScriptCode(writer, "" + computedValue);
    }

    private void getGeneratedScriptCode(ScriptWriter writer, String value) {
        if (this.pinReference == null) {
            return;
        }
        Pin pin = this.pinReference.dereference();
        if (pin == null) {
            return;
        }
        writer.assignPinToValue(pin.generateSetterScriptCode(value));
    }

    @Override
    public ActionState substituteReference(Object original, Object substitute) {
        if (this.pinReference == original && substitute instanceof PinReference) {
            return new AnalogOutputActionState((PinReference)substitute, this.value);
        }
        return this;
    }

    @Override
    public void collectInternalEntities(Collection<Object> collection) {
        collection.add(this.pinReference);
    }

    @Override
    public boolean isUndefined() {
        return this.pinReference.isUndefined();
    }

    @Override
    public String getCommand(String commandName) {
        if (this.pinReference == null) {
            return commandName;
        }
        Pin pin = this.pinReference.dereference();
        String pinName = pin == null ? this.pinReference.getKey() : (StringUtils.isNullOrOnlyWhitespace((String)pin.getDefinedName()) ? pin.getShortName() : pin.getDefinedName());
        return String.valueOf(commandName) + " " + pinName + "=" + this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnalogOutputActionState)) {
            return false;
        }
        AnalogOutputActionState that = (AnalogOutputActionState)o;
        if (Double.compare(that.value, this.value) != 0) {
            return false;
        }
        return this.pinReference != null ? this.pinReference.equals((Object)that.pinReference) : that.pinReference == null;
    }

    public int hashCode() {
        int result = this.pinReference != null ? this.pinReference.hashCode() : 0;
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.getAnalogOutputDomain();
        return result;
    }

    public Pin<?> getAnalogOutput() {
        if (this.pinReference == null) {
            return null;
        }
        Pin result = this.pinReference.dereference();
        if (result != null && result.isInput()) {
            result = null;
        }
        return result;
    }

    public int getAnalogOutputDomain() {
        Pin<?> pin = this.getAnalogOutput();
        if (pin == null) {
            return 0;
        }
        if (pin instanceof AnalogIOPin) {
            int analogOutputDomain = ((AnalogIOPin)pin).getAnalogOutputDomain();
            if (analogOutputDomain < 0) {
                analogOutputDomain = 0;
            }
            return analogOutputDomain;
        }
        return 0;
    }

    public double initAnalogValue(double analogValue) {
        if (!(this.getAnalogOutput() instanceof Register)) {
            if (this.getAnalogOutputDomain() == 0) {
                if (analogValue > 20.0) {
                    analogValue = 20.0;
                } else if (analogValue < 4.0) {
                    analogValue = 4.0;
                }
            } else if (analogValue > 10.0) {
                analogValue = 10.0;
            } else if (analogValue < 0.0) {
                analogValue = 0.0;
            }
        }
        return analogValue;
    }

    public double getAnalogValue() {
        if (!(this.getAnalogOutput() instanceof Register)) {
            if (this.getAnalogOutputDomain() == 0) {
                if (this.value > 20.0) {
                    this.value = 20.0;
                } else if (this.value < 4.0) {
                    this.value = 4.0;
                }
            } else if (this.value > 10.0) {
                this.value = 10.0;
            } else if (this.value < 0.0) {
                this.value = 0.0;
            }
            return this.value;
        }
        return this.value;
    }
}

