/*
 * Decompiled with CFR 0.152.
 */
package gui.program.setnode;

import com.ur.lang.StringUtils;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.viewfacade.pin.Pin;
import gui.program.setnode.ActionState;
import gui.program.setnode.SetNode;
import gui.tools.LanguagePack;
import java.util.Collection;

public class DigitalOutputActionState
implements ActionState {
    public final PinReference pinReference;
    public final int value;

    public DigitalOutputActionState(PinReference pinReference, int digitalValue) {
        this.pinReference = pinReference;
        this.value = digitalValue;
    }

    public DigitalOutputActionState() {
        this(null, 0);
    }

    @Override
    public void generateCode(ScriptWriter scriptGenerator) {
        this.getGeneratedScriptCode(scriptGenerator, this.value == 0 ? "False" : "True");
    }

    private void getGeneratedScriptCode(ScriptWriter writer, String value) {
        if (this.pinReference == null) {
            return;
        }
        Pin pin = this.pinReference.dereference();
        if (pin == null) {
            return;
        }
        writer.assignPinToValue(pin.generateSetterScriptCode(value));
    }

    @Override
    public ActionState substituteReference(Object original, Object substitute) {
        if (this.pinReference == original && substitute instanceof PinReference) {
            return new DigitalOutputActionState((PinReference)substitute, this.value);
        }
        return this;
    }

    @Override
    public void collectInternalEntities(Collection<Object> collection) {
        collection.add(this.pinReference);
    }

    @Override
    public boolean isUndefined() {
        return this.getDigitalOutputPin() == null;
    }

    @Override
    public String getCommand(String commandName) {
        if (this.pinReference == null) {
            return commandName;
        }
        Pin pin = this.pinReference.dereference();
        String pinName = pin == null ? this.pinReference.getKey() : (StringUtils.isNullOrOnlyWhitespace((String)pin.getDefinedName()) ? pin.getShortName() : pin.getDefinedName());
        String assignment = this.value == 0 ? LanguagePack.getTextResource().Off() : LanguagePack.getTextResource().On();
        return String.valueOf(commandName) + " " + pinName + "=" + assignment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DigitalOutputActionState)) {
            return false;
        }
        DigitalOutputActionState that = (DigitalOutputActionState)o;
        if (this.value != that.value) {
            return false;
        }
        return this.pinReference != null ? this.pinReference.equals((Object)that.pinReference) : that.pinReference == null;
    }

    public int hashCode() {
        int result = this.pinReference != null ? this.pinReference.hashCode() : 0;
        result = 31 * result + this.value;
        return result;
    }

    public Pin<?> getDigitalOutputPin() {
        if (this.pinReference == null || this.pinReference.dereference() == null) {
            return null;
        }
        Pin result = this.pinReference.dereference();
        if (SetNode.VALID_DIGITAL_OUTPUT.test((Object)result)) {
            return result;
        }
        return null;
    }
}

