/*
 * Decompiled with CFR 0.152.
 */
package gui.program.setnode;

import com.ur.lang.StringUtils;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.swing.expression.Expression;
import gui.program.setnode.ActionState;
import java.util.Collection;

public class ExpressionOutputActionState
implements ActionState {
    public final Expression expression;
    public final PinReference pinReference;

    public ExpressionOutputActionState(PinReference pinReference, Expression expression) {
        this.pinReference = pinReference;
        this.expression = expression;
    }

    public ExpressionOutputActionState() {
        this(null, new Expression());
    }

    @Override
    public void generateCode(ScriptWriter scriptGenerator) {
        this.getGeneratedScriptCode(scriptGenerator, this.expression.getScriptCodeText());
    }

    private void getGeneratedScriptCode(ScriptWriter writer, String value) {
        if (this.pinReference == null) {
            return;
        }
        Pin pin = this.pinReference.dereference();
        if (pin == null) {
            return;
        }
        writer.assignPinToValue(pin.generateSetterScriptCode(value));
    }

    @Override
    public ActionState substituteReference(Object original, Object substitute) {
        if (this.pinReference == original && substitute instanceof PinReference) {
            return new ExpressionOutputActionState((PinReference)substitute, this.expression);
        }
        return this;
    }

    @Override
    public void collectInternalEntities(Collection<Object> collection) {
        collection.add(this.pinReference);
        this.expression.getExpression().getProgramEntities(collection);
    }

    @Override
    public boolean isUndefined() {
        if (this.pinReference != null) {
            return this.pinReference.isUndefined() || this.expression.isUndefined();
        }
        return true;
    }

    @Override
    public String getCommand(String commandName) {
        if (this.pinReference == null || this.expression == null) {
            return commandName;
        }
        Pin pin = this.pinReference.dereference();
        String pinName = pin == null ? this.pinReference.getKey() : (StringUtils.isNullOrOnlyWhitespace((String)pin.getDefinedName()) ? pin.getShortName() : pin.getDefinedName());
        return String.valueOf(commandName) + " " + pinName + "=" + this.expression.getText();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExpressionOutputActionState)) {
            return false;
        }
        ExpressionOutputActionState that = (ExpressionOutputActionState)o;
        if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) {
            return false;
        }
        return this.pinReference != null ? this.pinReference.equals((Object)that.pinReference) : that.pinReference == null;
    }

    public int hashCode() {
        int result = this.expression != null ? this.expression.hashCode() : 0;
        result = 31 * result + (this.pinReference != null ? this.pinReference.hashCode() : 0);
        return result;
    }
}

