/*
 * Decompiled with CFR 0.152.
 */
package gui.program.setnode;

import com.ur.lang.StringUtils;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.view.variables.InstallationVariableReference;
import gui.program.setnode.ActionState;
import java.util.Collection;

public class IncrementVariableActionState
implements ActionState {
    public final InstallationVariableReference variable;

    public IncrementVariableActionState(InstallationVariableReference variable) {
        this.variable = variable;
    }

    public IncrementVariableActionState() {
        this(null);
    }

    @Override
    public void generateCode(ScriptWriter scriptGenerator) {
        String variableName;
        String string = variableName = this.variable == null ? null : this.variable.getName();
        if (!StringUtils.isNullOrOnlyWhitespace((String)variableName)) {
            scriptGenerator.incrementVariable(variableName);
        }
    }

    @Override
    public ActionState substituteReference(Object original, Object substitute) {
        return this;
    }

    @Override
    public void collectInternalEntities(Collection<Object> collection) {
    }

    @Override
    public boolean isUndefined() {
        return this.variable == null || this.variable.isUndefined() || !this.variable.isNumber();
    }

    @Override
    public String getCommand(String commandName) {
        if (this.variable == null) {
            return commandName;
        }
        String variableName = this.variable.getName();
        if (!StringUtils.isNullOrOnlyWhitespace((String)variableName)) {
            commandName = String.valueOf(commandName) + String.format(" %s=%s+1", variableName, variableName);
        }
        return commandName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IncrementVariableActionState)) {
            return false;
        }
        IncrementVariableActionState that = (IncrementVariableActionState)o;
        return this.variable != null ? this.variable.equals(that.variable) : that.variable == null;
    }

    public int hashCode() {
        return this.variable != null ? this.variable.hashCode() : 0;
    }
}

