/*
 * Decompiled with CFR 0.152.
 */
package gui.program.setnode;

import com.ur.lang.EqualsUtil;
import com.ur.math.Time;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.viewfacade.pin.Pin;
import gui.program.setnode.ActionState;
import gui.program.setnode.SetNode;
import java.security.InvalidParameterException;
import java.util.Collection;

public class SingleDigitalPulseActionState
implements ActionState {
    private static int counterId = 0;
    public static final Time DEFAULT_PULSE_TIME = Time.from((double)500.0, (Time.Unit)Time.Unit.MILLI_SECONDS);
    private PinReference pinReference;
    private Time time;

    public SingleDigitalPulseActionState(PinReference pinReference, Time time) {
        if (time == null) {
            throw new InvalidParameterException("Time cannot be null");
        }
        this.pinReference = pinReference;
        this.time = time;
    }

    public SingleDigitalPulseActionState() {
        this(null, DEFAULT_PULSE_TIME);
    }

    public Time getTime() {
        return this.time;
    }

    public PinReference getPinReference() {
        return this.pinReference;
    }

    @Override
    public void generateCode(ScriptWriter writer) {
        writer.defineThread("SinglePulse" + counterId);
        this.getGeneratedScriptCode(writer, "True");
        writer.sleep(this.time.getIn(Time.Unit.SECONDS));
        this.getGeneratedScriptCode(writer, "False");
        writer.end();
        writer.runThread("singlePulse" + counterId, "SinglePulse" + counterId);
        ++counterId;
    }

    public void generateCodeTestAction(ScriptWriter writer) {
        this.getGeneratedScriptCode(writer, "True");
        writer.sleep(this.time.getIn(Time.Unit.SECONDS));
        this.getGeneratedScriptCode(writer, "False");
    }

    private void getGeneratedScriptCode(ScriptWriter writer, String value) {
        if (this.pinReference == null) {
            return;
        }
        Pin pin = this.pinReference.dereference();
        if (pin == null) {
            return;
        }
        writer.assignPinToValue(pin.generateSetterScriptCode(value));
    }

    @Override
    public ActionState substituteReference(Object original, Object substitute) {
        if (this.pinReference == original && substitute instanceof PinReference) {
            return new SingleDigitalPulseActionState((PinReference)substitute, this.time);
        }
        return this;
    }

    @Override
    public void collectInternalEntities(Collection<Object> collection) {
        collection.add(this.pinReference);
    }

    @Override
    public boolean isUndefined() {
        return this.pinReference == null || this.pinReference.isUndefined() || !SetNode.VALID_DIGITAL_OUTPUT.test((Object)this.pinReference.dereference());
    }

    @Override
    public String getCommand(String command) {
        String pulseTime = this.pinReference == null ? "" : ":Pulse " + this.time.getIn(Time.Unit.SECONDS);
        return String.valueOf(SetNode.generateDisplayableSetCommand(this.pinReference, command, "HI")) + pulseTime;
    }

    public boolean equals(Object o) {
        if (o instanceof SingleDigitalPulseActionState) {
            SingleDigitalPulseActionState other = (SingleDigitalPulseActionState)o;
            return EqualsUtil.equals((Object)this.pinReference, (Object)other.getPinReference()) && this.time.equals((Object)other.getTime());
        }
        return false;
    }
}

