/*
 * Decompiled with CFR 0.152.
 */
package gui.program.setnode;

import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.internaltcp.domain.TCPReference;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import java.util.Collection;

public class ToolState {
    public final boolean isPayloadValue;
    public final boolean isUseTCPasCOG;
    public final double payload;
    public final TCPReference tcpReference;

    public ToolState(boolean isPayloadValue, boolean isUseTCPasCOG, double payload, TCPReference reference) {
        this.isPayloadValue = isPayloadValue;
        this.isUseTCPasCOG = isUseTCPasCOG;
        this.payload = payload;
        this.tcpReference = reference;
    }

    public void generateCode(ScriptWriter writer) {
        if (this.isPayloadValue) {
            if (this.isUseTCPasCOG) {
                writer.set_payload(this.payload);
            } else {
                writer.set_payload_mass(this.payload);
            }
        }
        if (this.tcpReference != null) {
            writer.set_tcp(new Pose6d(this.tcpReference.dereference().getOffsetPose().asArray()));
        }
    }

    public ToolState substituteReference(Object original, Object substitute) {
        if (this.tcpReference == original && substitute instanceof TCPReference) {
            return new ToolState(this.isPayloadValue, this.isUseTCPasCOG, this.payload, (TCPReference)substitute);
        }
        return this;
    }

    public void collectInternalEntities(Collection<Object> collection) {
        collection.add(this.tcpReference);
    }

    public boolean isUndefined() {
        return this.tcpReference != null && this.tcpReference.dereference() == null;
    }
}

